/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.tools;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class SortHeaderRenderer
extends JButton
implements TableCellRenderer {
    private Icon m_EmptyIcon = null;
    private Icon m_AscendIcon = null;
    private Icon m_DescendIcon = null;
    private int m_SortColumn = -1;
    private boolean m_Ascend = true;

    public SortHeaderRenderer() {
        this.setHorizontalTextPosition(2);
        this.setMargin(new Insets(1, 1, 1, 1));
    }

    protected void finalize() throws Throwable {
        this.m_AscendIcon = null;
        this.m_DescendIcon = null;
        this.m_EmptyIcon = null;
        super.finalize();
    }

    public void setSortIcons(Icon ascend, Icon descend) {
        this.m_AscendIcon = ascend;
        this.m_DescendIcon = descend;
        this.m_EmptyIcon = this.m_AscendIcon != null ? null.new EmptyIcon(this.m_AscendIcon.getIconWidth()) : (this.m_DescendIcon != null ? null.new EmptyIcon(this.m_DescendIcon.getIconWidth()) : null);
    }

    public void setSortColumn(int col, boolean ascend) {
        this.m_SortColumn = col;
        this.m_Ascend = ascend;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table.convertColumnIndexToModel(column) == this.m_SortColumn) {
            if (this.m_Ascend) {
                this.setIcon(this.m_AscendIcon);
            } else {
                this.setIcon(this.m_DescendIcon);
            }
        } else {
            this.setIcon(this.m_EmptyIcon);
        }
        this.setText(value.toString());
        return this;
    }

    public int getMaxIconWidth() {
        int width = 0;
        if (this.m_EmptyIcon != null) {
            width = Math.max(width, this.m_EmptyIcon.getIconWidth());
        }
        return width;
    }

    private class EmptyIcon
    implements Icon {
        private int m_Width = 0;

        public EmptyIcon(int width) {
            this.m_Width = width;
        }

        public int getIconWidth() {
            return this.m_Width;
        }

        public int getIconHeight() {
            return 0;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }
}

