/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.tools;

import com.qlogic.util.EventEntry;
import com.qlogic.util.QPrintable;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.util.Date;

public class EventsPrintable
extends QPrintable {
    private static final Font HEADER_FONT = new Font("Courier", 1, 10);
    private static final Font BODY_FONT = new Font("Courier", 0, 10);
    private static final int HEADER_TEXT_OFFSET = 2;
    private static final int TEXT_OFFSET = 1;
    private int i = 0;
    private int iStart = 0;
    private int maxPages = 1;
    private int pageProcessing = -1;
    private EventEntry[] m_EventEntries;

    public EventsPrintable(EventEntry[] entries) {
        this.m_EventEntries = entries;
    }

    protected boolean pageExists(int pageIndex) {
        return pageIndex < this.maxPages && this.pageProcessing <= pageIndex;
    }

    public double printHeader(Graphics2D g2, PageFormat format, int pageIndex, double currentY) {
        double startX = format.getImageableX();
        double pageWidth = format.getImageableWidth();
        double pageHeight = format.getImageableHeight();
        g2.setFont(HEADER_FONT);
        FontMetrics metrics = g2.getFontMetrics();
        StringBuffer buffer = new StringBuffer("");
        buffer.append("Event Log");
        buffer.append(" Date: ");
        buffer.append(new Date());
        buffer.append(" Page: ");
        buffer.append(pageIndex);
        g2.drawString(buffer.toString(), (float)startX + (float)2, (float)currentY + (float)metrics.getAscent());
        currentY += (double)(metrics.getHeight() + 2);
        this.printOutline(g2, format);
        currentY = this.printSeparator(g2, format, 2.0, currentY);
        return currentY;
    }

    public double printBody(Graphics2D g2, PageFormat format, int pageIndex, double currentY) {
        g2.setFont(BODY_FONT);
        FontMetrics metrics = g2.getFontMetrics();
        int lineHeight = metrics.getHeight();
        double x = format.getImageableX() + 1.0;
        boolean bNewPage = false;
        if (this.pageProcessing != pageIndex) {
            bNewPage = true;
            this.pageProcessing = pageIndex;
            this.iStart = this.i;
        } else {
            this.i = this.iStart;
        }
        StringBuffer buffer = new StringBuffer();
        g2.setPaint(Color.black);
        currentY = this.printSeparator(g2, format, 2.0, currentY);
        while (this.i < this.m_EventEntries.length) {
            EventEntry entry = this.m_EventEntries[this.i];
            buffer.append(entry.getTimeStamp());
            buffer.append("  Message: ");
            buffer.append(entry.getDescription());
            g2.drawString(buffer.toString(), (float)x + 1.0f, (float)currentY + (float)metrics.getAscent());
            if (this.checkPageBreak(format, currentY += (double)metrics.getHeight(), metrics.getHeight())) {
                if (bNewPage) {
                    ++this.maxPages;
                }
                return currentY;
            }
            buffer.delete(0, buffer.length());
            currentY = this.printSeparator(g2, format, 2.0, currentY);
            if (this.checkPageBreak(format, currentY, metrics.getHeight())) {
                if (bNewPage) {
                    ++this.maxPages;
                }
                return currentY;
            }
            ++this.i;
        }
        this.i = 0;
        return currentY;
    }
}

