/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui;

import com.qlogic.SkinConstants;
import com.qlogic.ui.SplashPanel;
import com.qlogic.util.SplashInfo;
import com.qlogic.util.Trace;
import com.qlogic.util.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JWindow;
import javax.swing.Timer;
import javax.swing.border.LineBorder;

public class SplashWindow
extends JWindow
implements ActionListener {
    private static final SplashWindow INSTANCE = new SplashWindow();
    public static final int SPLASH_DISPLAY_TIME = 20000;
    private int closeRequests = 0;

    public static SplashWindow instance() {
        return INSTANCE;
    }

    public void close() {
        Trace.warn("The Splash Window should be closing.");
        ((Component)this).setVisible(false);
    }

    private SplashWindow() {
        SplashInfo info = SplashWindow.loadSplashInfo();
        SplashPanel panel = new SplashPanel(info, SkinConstants.SPLASH_IMAGE);
        panel.setBorder(new LineBorder(Color.black, 1));
        this.getContentPane().add(panel);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = this.getSize();
        ((Component)this).setLocation(screenSize.width / 2 - windowSize.width / 2, screenSize.height / 2 - windowSize.height / 2);
        String delayStr = Utilities.getProperty("splash.delay");
        ((Component)this).setVisible(true);
        int delay = 20000;
        if (delayStr != null) {
            try {
                int temp = Integer.parseInt(delayStr);
                if (temp > 0) {
                    delay = temp;
                }
            }
            catch (NumberFormatException temp) {
                // empty catch block
            }
        }
        Trace.warn(String.valueOf(String.valueOf("The Timer Delay is:  ").concat(String.valueOf(delay))).concat(String.valueOf(".")));
        Timer timer = new Timer(delay, this);
        timer.setRepeats(false);
        timer.start();
    }

    public static SplashInfo loadSplashInfo() {
        SplashInfo info;
        block3: {
            info = null;
            String infoKey = Utilities.getProperty("splash.info");
            if (infoKey == null) break block3;
            try {
                Class<?> c = Class.forName(infoKey);
                Object o = c.newInstance();
                if (o != null && o instanceof SplashInfo) {
                    info = (SplashInfo)o;
                }
            }
            catch (Exception exception) {}
        }
        return info;
    }

    public void actionPerformed(ActionEvent e) {
        Trace.warn("The Splash Window should be closing.");
        ((Component)this).setVisible(false);
    }
}

