/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class SeverityCellRenderer
extends JLabel
implements TableCellRenderer {
    private static Color m_SelectFore = UIManager.getColor("Table.selectionForeground");
    private static Color m_SelectBack = UIManager.getColor("Table.selectionBackground");
    private static Color m_NonSelectFore = UIManager.getColor("Table.textForeground");
    private static Color m_NonSelectBack = UIManager.getColor("Table.textBackground");
    private SeverityIcon m_SeverityIcon = new SeverityIcon();

    public SeverityCellRenderer() {
        this.setOpaque(true);
        this.setIcon(this.m_SeverityIcon);
        this.setHorizontalAlignment(0);
        this.setPreferredSize(new Dimension(16, 16));
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setFont(table.getFont());
        if (isSelected) {
            this.setForeground(m_SelectFore);
            this.setBackground(m_SelectBack);
        } else {
            this.setForeground(m_NonSelectFore);
            this.setBackground(m_NonSelectBack);
        }
        Icon icon = (Icon)value;
        this.m_SeverityIcon.setIcon(icon);
        return this;
    }

    private class SeverityIcon
    implements Icon {
        private Icon baseIcon = null;
        private Color baseColor = SeverityCellRenderer.this.getBackground();

        SeverityIcon() {
        }

        public void setIcon(Icon icon) {
            this.baseIcon = icon;
        }

        public void setColor(Color color) {
            this.baseColor = new Color(color.getRGB());
        }

        public void paintIcon(Component component, Graphics g, int x, int y) {
            if (this.baseIcon != null) {
                this.baseIcon.paintIcon(component, g, x, y);
            }
        }

        private int getBaseIconWidth() {
            return this.baseIcon == null ? 0 : this.baseIcon.getIconWidth();
        }

        public int getIconWidth() {
            return this.getBaseIconWidth();
        }

        public int getIconHeight() {
            return this.baseIcon == null ? 0 : this.baseIcon.getIconHeight();
        }
    }
}

