/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui;

import com.qlogic.QConstants;
import com.qlogic.SkinConstants;
import com.qlogic.util.EventEntry;
import com.qlogic.util.Trace;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class EventTableModel
extends AbstractTableModel {
    public static final int TYPE = 0;
    public static final int TIME_STAMP = 1;
    public static final int MESSAGE = 2;
    private EventEntry[] m_Events = null;
    private static final String[] HEADERS = new String[]{QConstants.getString("event_hdr_type"), QConstants.getString("event_hdr_time"), QConstants.getString("event_hdr_message")};
    private Class[] columnClasses = new Class[]{Class.forName("javax.swing.Icon"), Class.forName("java.util.Date"), Class.forName("java.lang.String")};

    public EventTableModel(EventEntry[] events) {
        this.m_Events = events;
    }

    public int getColumnCount() {
        return HEADERS.length;
    }

    public void addEvent(EventEntry event) {
        EventEntry[] events;
        int insertRow;
        EventEntry[] oldEvents = this.m_Events;
        if (oldEvents == null) {
            insertRow = 0;
            events = new EventEntry[]{event};
        } else {
            insertRow = this.m_Events.length;
            events = new EventEntry[this.m_Events.length + 1];
            System.arraycopy(this.m_Events, 0, events, 1, this.m_Events.length);
            events[0] = event;
        }
        this.m_Events = events;
        this.fireTableRowsInserted(insertRow, insertRow);
    }

    public void setData(EventEntry[] events) {
        this.m_Events = events;
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        if (this.m_Events == null) {
            return 0;
        }
        return this.m_Events.length;
    }

    public String getColumnName(int col) {
        return HEADERS[col];
    }

    public Class getColumnClass(int col) {
        return this.columnClasses[col];
    }

    public Object getValueAt(int row, int col) {
        if (this.m_Events == null) {
            return null;
        }
        EventEntry event = this.m_Events[row];
        switch (col) {
            case 0: {
                return this.getSeverityIcon(event.getSeverity());
            }
            case 1: {
                return event.getTimeStamp();
            }
            case 2: {
                return event.getDescription();
            }
        }
        return null;
    }

    private Icon getSeverityIcon(int severity) {
        switch (severity) {
            case 2: {
                return SkinConstants.ERROR_IMAGE;
            }
            case 0: {
                return SkinConstants.INFO_IMAGE;
            }
            case 1: {
                return SkinConstants.WARN_IMAGE;
            }
        }
        Trace.warn(String.valueOf(QConstants.getString("Invalid_Event")).concat(String.valueOf(" Unknown Severity!")));
        return null;
    }
}

