/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui;

import com.qlogic.QConstants;
import com.qlogic.SkinConstants;
import com.qlogic.ui.tools.SortableComboBoxModel;
import com.qlogic.util.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public abstract class ConnectionDialog
extends JDialog
implements ActionListener {
    private SortableComboBoxModel m_ComboBoxModel = new SortableComboBoxModel();
    private JButton m_ConnectButton = new JButton(QConstants.getString("Connect"));
    private JButton m_CancelButton = new JButton(QConstants.getString("Cancel"));
    private JButton m_ClearButton = new JButton(QConstants.getString("Clear"));
    private JComboBox m_HostComboBox = new JComboBox(this.m_ComboBoxModel);

    public ConnectionDialog(Frame frame, String title, boolean bModal) {
        super(frame, title, bModal);
        Trace.traceAt(600, "in ConnectionDialog (Dialog) constructor");
        this.getContentPane().setLayout(new FlowLayout());
        JPanel basePanel = new JPanel(new BorderLayout(0, 10));
        JPanel formatPanel = new JPanel(new GridLayout(3, 1, 10, 10));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        JLabel imageLabel = new JLabel(SkinConstants.CONNECT_IMAGE);
        JPanel containerPanel = new JPanel(new BorderLayout());
        JPanel imagePanel = new JPanel();
        JLabel enterIPLabel = new JLabel(QConstants.getString("Enter_Host_Name_or_IP"));
        CompoundBorder border = new CompoundBorder(new EtchedBorder(), new EmptyBorder(10, 10, 10, 10));
        containerPanel.setBorder(border);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        buttonPanel.add((Component)this.m_ConnectButton, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        buttonPanel.add((Component)this.m_ClearButton, gbc);
        gbc.gridx = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        buttonPanel.add((Component)this.m_CancelButton, gbc);
        imagePanel.add((Component)imageLabel, null);
        formatPanel.add((Component)enterIPLabel, null);
        formatPanel.add((Component)this.m_HostComboBox, null);
        containerPanel.add((Component)formatPanel, "North");
        containerPanel.add((Component)imagePanel, "Center");
        basePanel.add((Component)buttonPanel, "South");
        basePanel.add((Component)containerPanel, "Center");
        this.getContentPane().add(basePanel);
        this.m_ConnectButton.addActionListener(this);
        this.m_CancelButton.addActionListener(this);
        this.m_ClearButton.addActionListener(this);
        this.m_HostComboBox.getEditor().addActionListener(new 1());
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        Trace.traceAt(600, "in ConnectionDialog (Frame) constructor");
    }

    protected abstract void connect();

    protected abstract void clear();

    protected abstract void cancel();

    public final void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_ConnectButton) {
            this.connect();
        } else if (obj == this.m_CancelButton) {
            this.cancel();
        } else if (obj == this.m_ClearButton) {
            this.clear();
        }
    }

    public void comboBoxActivated() {
        String selectedString;
        String editString = (String)this.m_HostComboBox.getEditor().getItem();
        if (!editString.equalsIgnoreCase(selectedString = (String)this.m_HostComboBox.getSelectedItem())) {
            int iCount = this.m_HostComboBox.getItemCount();
            boolean bFound = false;
            for (int i = 0; i < iCount; ++i) {
                if (!((String)this.m_HostComboBox.getItemAt(i)).equalsIgnoreCase(editString)) continue;
                bFound = true;
                this.m_HostComboBox.setSelectedIndex(i);
                this.m_HostComboBox.validate();
                break;
            }
            if (!bFound) {
                this.m_HostComboBox.addItem(editString);
                this.m_HostComboBox.setSelectedItem(editString);
                this.m_HostComboBox.validate();
            }
        }
        this.connect();
    }

    public void addItem(Object item) {
        this.m_HostComboBox.addItem(item);
    }

    public void removeAllItems() {
        if (this.m_HostComboBox.getItemCount() > 0) {
            this.m_HostComboBox.removeAllItems();
        }
    }

    public Object getSelectedItem() {
        return this.m_HostComboBox.getSelectedItem();
    }

    public void setSelectedItem(Object item) {
        this.m_HostComboBox.setSelectedItem(item);
    }

    public void enableComboBoxEditing(boolean enable) {
        this.m_HostComboBox.setEditable(enable);
    }

    public void sort(Comparator c) {
        this.m_ComboBoxModel.sort(c);
    }

    public void sort() {
        this.m_ComboBoxModel.sort();
    }

    class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ConnectionDialog.this.comboBoxActivated();
        }

        1() {
        }
    }
}

