/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui;

import com.qlogic.QConstants;
import com.qlogic.util.AlarmEntry;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class AlarmRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color WARN_FORE = Color.blue;
    public static final Color WARN_BACK = Color.yellow;
    public static final Color UKWN_FORE = Color.white;
    public static final Color UKWN_BACK = Color.blue;
    public static final Color INFO_FORE = UIManager.getColor("Table.foreground");
    public static final Color INFO_BACK = UIManager.getColor("Table.background");
    public static final Color BAD_FORE = Color.yellow;
    public static final Color BAD_BACK = Color.red;

    public AlarmRenderer() {
        this.setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            AlarmEntry alarm = (AlarmEntry)table.getModel().getValueAt(row, 4);
            int status = alarm.getSeverity();
            switch (status) {
                case 0: {
                    this.setForeground(INFO_FORE);
                    this.setBackground(INFO_BACK);
                    break;
                }
                case 1: {
                    this.setForeground(WARN_FORE);
                    this.setBackground(WARN_BACK);
                    break;
                }
                case 2: {
                    this.setForeground(BAD_FORE);
                    this.setBackground(BAD_BACK);
                    break;
                }
                default: {
                    this.setForeground(UKWN_FORE);
                    this.setBackground(UKWN_BACK);
                }
            }
        }
        this.setFont(table.getFont());
        if (table.getColumnClass(col) == Class.forName("java.util.Date")) {
            this.setText(QConstants.DATE_FORMAT.format((Date)value));
        } else {
            this.setText(value.toString());
        }
        return this;
    }
}

