#!/usr/perl5/bin/perl
#
# Copyright (c) 2001 by Sun Microsystems, Inc.
# All rights reserved.
#
#ident  "@(#)SUNW_cluster_privatenet.pl 1.2     01/08/15 SMI"
#
#
# This RCM script prevents the removal of Sun Cluster private network
# adapters.
#

require 5.005;

use English;
use strict;
use POSIX qw(locale_h EEXIST ENOENT);
use Sun::Solaris::Utils qw(textdomain gettext);

my ($resource, $resource_short, $isprivatenet, $retval, $privatenetlist,
    $isclustered, $loc);

#
# Specify location of Sun Cluster private network helper scripts
#
$isprivatenet = "/usr/cluster/lib/sc/isprivatenet";
$privatenetlist = "/usr/cluster/lib/sc/privatenetlist";
$isclustered = "/usr/sbin/clinfo";

$ARG = shift(@ARGV);

 SWITCH: {
     /scriptinfo/   && do {
	 print "rcm_script_version=1\n";
	 print "rcm_script_func_info=",
		gettext("Sun Cluster Private Network"), "\n";
	 print "rcm_cmd_timeout=86400\n";
	 exit (0);
     };
     
     /register/ && do {

	  if((system($isclustered)/256) != 0) {
	      exit(0);
	  }

	 if(!open(PRIVATENET, "$privatenetlist|")) {
	     print "rcm_failure_reason=",
		gettext("Cannot call $privatenetlist."), "\n";
	     exit(1);
	 }

	 while(<PRIVATENET>) {
	     if(/^([A-Za-z0-9]+)/) {
		 print "rcm_resource_name=SUNW_network/$1\n";
	     }
	 }

	 if(!close(PRIVATENET)) {
	     print "rcm_failure_reason=",
		gettext("Cannot read private network list."), "\n";
	     exit(1);
	 }
	 exit (0);
     };
     
     /resourceinfo/ && do {
	 print "rcm_resource_usage_info=",
		gettext("Sun Cluster Private Network"), "\n";
	 exit (0);
     };
     
     /queryremove/ && do {
	 $resource = shift(@ARGV); 

	 $resource =~ /SUNW_network\/(.+)/;
	 if(($resource_short = $1) eq "") {
	     print "rcm_log_error=",
		"Unable to determine private network resources.\n";
	     exit(2);
	 }

	 $loc = setlocale(LC_ALL, "C");
	 if(($retval = system("$isprivatenet $resource_short")) != 0) {
	     setlocale(LC_ALL, $loc);
	     print "rcm_failure_reason=";
	     printf gettext("%s is a Sun Cluster Private Network Adapter."),
		$resource_short;
	     print "\n";
	     exit (3);
	 } else {
	     setlocale(LC_ALL, $loc);
	     exit(0);
	 }
     };
     
     /preremove/ && do {
	 exit (0);
     };
     
     /cancelremove/ && do {
	 exit (0);
     };
     
     /postresume/ && do {
	 exit (0);
     };
 }

exit (2);
