/* Gate Specific Code -- BEGIN */
#
# Copyright 1998-2002 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident  "@(#)dns_validate.ksh 1.9     02/02/20 SMI"
/* Gate Specific Code -- END */
#!/bin/ksh
# Sun Cluster Data Services Builder template version 1.0
#
# Validate method for DNS.
# ex: When the resource is being created command args will be
#   
# dns_validate -c -R <..> -G <...> -T <..> -r <sysdef-prop=value>... 
#       -x <extension-prop=value>.... -g <resourcegroup-prop=value>....
#
# when the resource property is being updated
#
# dns_validate -u -R <..> -G <...> -T <..> -r <sys-prop_being_updated=value>
#   OR
# dns_validate -u -R <..> -G <...> -T <..> -x <extn-prop_being_updated=value>
#

###############################################################################
# Parse program arguments.
#
function parse_args # [args ...]
{
	typeset opt

	while getopts 'cur:x:g:R:T:G:' opt
	do
		case "$opt" in

		R)
		# Name of the DNS resource.
		RESOURCE_NAME=$OPTARG
		;;

		G)
		# Name of the resource group in which the resource is
		# configured.
		RESOURCEGROUP_NAME=$OPTARG
		;;

		T)
		# Name of the resource type.
		RESOURCETYPE_NAME=$OPTARG
		;;

		r)      
		# We are not accessing any system defined property.
		# So, this is a no-op
		;;

		g)
		# This is a no-op as we are not bothered about 
		# Resource group properties
		;;

		c)
		# This is a no-op as this just a flag which indicates
		# that the validate method is being called while
		# creating the resource.
		;;

		u)
		# This is a flag to indicate the updating of property 
		# of an existing resource.
		UPDATE_PROPERTY=1
		;;

		x)
		;;

		*)
		logger -p ${SYSLOG_FACILITY}.err \
		-t [$RESOURCETYPE_NAME,$RESOURCEGROUP_NAME,$RESOURCE_NAME] \
		"ERROR: Option $OPTARG unknown"
		exit 1
		;;

		esac
	done
}

###############################################################################
# MAIN
##############################################################################

export PATH=/bin:/usr/bin:/usr/cluster/bin:/usr/sbin:/usr/proc/bin:$PATH

# Obtain the syslog facility to use. This will be used to log the messages.
SYSLOG_FACILITY=`scha_cluster_get -O SYSLOG_FACILITY`

UPDATE_PROPERTY=0

# Parse the arguments that have been passed to this method.
parse_args "$@"

SYSLOG_TAG=$RESOURCETYPE_NAME,$RESOURCEGROUP_NAME,$RESOURCE_NAME

if [[ -f /opt/SUNWdns/bin/hasp_check && \
	-x /opt/SUNWdns/bin/hasp_check ]]; then
	/opt/SUNWdns/bin/hasp_check "$@"
	hasp_status=$?
else
	# the binary doesn't exist so we cannot call it
	hasp_status=2
fi

case "$hasp_status" in

	1) 
	logger -p ${SYSLOG_FACILITY}.err -t [$SYSLOG_TAG] \
		"${ARGV0} Internal Error. Failed to check status of \
SUNW.HAStoragePlus resource."
	exit 1
	;;

	2)
	logger -p ${SYSLOG_FACILITY}.info -t [$SYSLOG_TAG] \
		"${ARGV0} This resource doesn't depend on any \
SUNW.HAStoragePlus resources. Proceeding with the normal checks."

	;;

	3)
	logger -p ${SYSLOG_FACILITY}.err -t [$SYSLOG_TAG] \
		"${ARGV0} One or more of the SUNW.HAStoragePlus resources \
that this resource depends on is in a different RG. \
Failing validate method configuration checks."
	exit 1
	;;

	4)
	logger -p ${SYSLOG_FACILITY}.err -t [$SYSLOG_TAG] \
		"${ARGV0} One or more of the SUNW.HAStoragePlus resources \
that this resource depends on is not online anywhere. \
Failing validate method."
	exit 1
	;;

	5)
	logger -p ${SYSLOG_FACILITY}.info -t [$SYSLOG_TAG] \
		"${ARGV0} All the SUNW.HAStoragePlus resources that this \
resource depends on are not online on the local node. \
Skipping the checks for the existence and permissions of the start/stop/probe \
commands."
	exit 0
	;;

	6)
	logger -p ${SYSLOG_FACILITY}.info -t [$SYSLOG_TAG] \
		"${ARGV0} All the SUNW.HAStoragePlus resources that this \
resource depends on are online on the local node. \
Proceeding with the checks for the existence and permissions of the \
start/stop/probe commands."
	;;

	*)
	logger -p ${SYSLOG_FACILITY}.err -t [$SYSLOG_TAG] \
		"${ARGV0} Unknown status code $hasp_status"
	;;

esac

start_cmd_args=
start_cmd_prog=`echo $start_cmd_args | nawk '{print $1}'`
if [[ ! -f $start_cmd_prog || ! -x $start_cmd_prog ]]; then
	logger -p ${SYSLOG_FACILITY}.err -t [$SYSLOG_TAG] \
		"${ARGV0} File $start_cmd_prog is missing or not executable"
	exit 1
fi

stop_cmd_args=
stop_cmd_prog=`echo $stop_cmd_args | nawk '{print $1}'`
if [[ ! -z $stop_cmd_prog ]]; then
	if [[ ! -f $stop_cmd_prog || ! -x $stop_cmd_prog ]]; then
		logger -p ${SYSLOG_FACILITY}.err -t [$SYSLOG_TAG] \
			"${ARGV0} File $stop_cmd_prog is missing or "
			"not executable"
		exit 1
	fi
fi

probe_cmd_args=
probe_cmd_prog=`echo $probe_cmd_args | nawk '{print $1}'`
if [[ ! -z $probe_cmd_prog ]]; then
	if [[ ! -f $probe_cmd_prog || ! -x $probe_cmd_prog ]]; then
		logger -p ${SYSLOG_FACILITY}.err -t [$SYSLOG_TAG] \
			"${ARGV0} File $probe_cmd_prog is missing or "
			"not executable"
		exit 1
	fi
fi

# User added code -- BEGIN vvvvvvvvvvvvvvv
# User added code -- END   ^^^^^^^^^^^^^^^

# Log a message indicating that validate method was successful.
logger -p ${SYSLOG_FACILITY}.info \
	-t [$SYSLOG_TAG] \
	"${ARGV0} Validate method for resource "$RESOURCE_NAME \
	" completed successfully"

exit 0
