/* Gate Specific Code -- BEGIN */
#
# Copyright (c) 1998-2001 by Sun Microsystems, Inc.
# All rights reserved.
#
#ident  "@(#)dns_mon_start.ksh 1.6     01/01/30 SMI"
/* Gate Specific Code -- END */
#!/bin/ksh
# Sun Cluster Data Services Builder template version 1.0
#
# Monitor start Method for DNS.
#

###############################################################################
# Parse program arguments.
#
function parse_args # [args ...]
{
	typeset opt

	while getopts 'R:G:T:' opt
	do
		case "$opt" in
		R)
		# Name of the DNS resource.
		RESOURCE_NAME=$OPTARG
		;;

		G)
		# Name of the resource group in which the resource is
		# configured.
		RESOURCEGROUP_NAME=$OPTARG
		;;

		T)
		# Name of the resource type.
		RESOURCETYPE_NAME=$OPTARG
		;;

		*)
		logger -p ${SYSLOG_FACILITY}.err \
	    	-t [$RESOURCETYPE_NAME,$RESOURCEGROUP_NAME,$RESOURCE_NAME] \
		"ERROR: Option $OPTARG unknown"
		exit 1
		;;

		esac
	done

}

###############################################################################
# MAIN
##############################################################################

export PATH=/bin:/usr/bin:/usr/cluster/bin:/usr/sbin:/usr/proc/bin:$PATH

# Obtain the syslog facility to use. This will be used to log the messages.
SYSLOG_FACILITY=`scha_cluster_get -O SYSLOG_FACILITY`

# Parse the arguments that have been passed to this method
parse_args "$@"

# We need to know where the probe method resides. This is specified in the 
# RT_BASEDIR property of the resource type.
RT_BASEDIR=`scha_resource_get -O RT_BASEDIR -R $RESOURCE_NAME \
	-G $RESOURCEGROUP_NAME`

PMF_TAG=$RESOURCEGROUP_NAME,$RESOURCE_NAME,0.mon
SYSLOG_TAG=$RESOURCETYPE_NAME,$RESOURCEGROUP_NAME,$RESOURCE_NAME

# User added code -- BEGIN vvvvvvvvvvvvvvv
# User added code -- END   ^^^^^^^^^^^^^^^

# Start the probe for the data service under PMF. Use the infinite retries 
# option to start the probe. Pass the the Resource name, type and group to the 
# probe method. 
pmfadm -c $PMF_TAG -n -1 -t -1 \
	$RT_BASEDIR/dns_probe.ksh -R $RESOURCE_NAME -G $RESOURCEGROUP_NAME \
	-T $RESOURCETYPE_NAME

# Log a message indicating that the monitor for DNS has been started.
if [ $? -eq 0 ]; then
	logger -p ${SYSLOG_FACILITY}.info \
		-t [$SYSLOG_TAG] \
		"${ARGV0} Monitor for DNS successfully started"
fi

# User added code -- BEGIN vvvvvvvvvvvvvvv
# User added code -- END   ^^^^^^^^^^^^^^^

exit 0
 
