#!/bin/bash
# samba-print-pdf
# This is a script which allows you to set up a virtual printer on samba
# which will take the file (generated by a postscript filter on windows)
# and turn it into a PDF, informing the user of where it is when it
# is done
#
# (c) Buchan Milne <bgmilne@cae.co.za> 2002 
# License: GPLv2
# Changelog
# v0.0.6 20030428
#  - Allow options passed as env. variables from print command
#  - Inline and simplify sed (use tr) clean script
#  - Ensure file arrives in PREFIX even if TEMP is used without provided name
#  - Changes from Joshua M. Schmidlkofer <joshua@imr-net.com> 20030425
#    - Debugging, adjustments, and corrections.
#    - Stupid sed sanitizing script. [probably horribly inefficient also]. 
#    - Temp file usage cleanup.
# v0.0.5 20020723
#  - Add support for preset settings
#  - Allow passing of filename provided by client as final filename
#
# Arguments:
# $1 = file (usually passed with %s from samba)
# $2 = unix prefix to where to place the file (~%u should work)
# $3 = windows prefix to the same location (//%L/%u should work)
# $4 = user/computer to send a notification to (%u or %m)
# $5 = IP address of client (%I)
# $6 = Name of destination file without extension (%J)
# $7 = PDF setting (prepress,print,screen etc)
#
# If you want to customise any of the following configuration defaults, 
# you can place them in the file /etc/samba/print-pdf.conf.
# If you need to modify anything in this script, please provide me with your
# changes, preferably in such a way that the changes are configurable.

PS2PDF=ps2pdf13 
OPTIONS="-dAutoFilterColorImages=false -sColorImageFilter=FlateEncode"
#Values taken from arguments:
INPUT=$1
PREFIX="$2"
WINBASE=$(echo "$3"|sed -e 's,/,\\\\,g')
#NAME=`echo "$6"|sed -e 's/[&/:{}\\\[<>$#@*^!?=|]/-/g;s/\]/-/g'`
NAME=`echo "$6"|tr '[:punct:]' '[-*]'`

# Source config file if it exists:
CONFFILE=/etc/samba/print-pdf.conf
[ -e $CONFFILE ] && . $CONFFILE

#Values not taken as arguments, could be set via env. vars (?) or config file
KEEP_PS=${KEEP_PS=0}
PERMS=${PERMS=640}
BASEFILE=${BASEFILE=pdf-service}
TEMP="${TEMP=$2}"
UMASK=${UMASK=006}

#Make sure that destination directory exists
mkdir -p "$PREFIX"

INFILE=$(basename $INPUT)

umask $UMASK

[ -n "$NAME" ] && TEMP="$PREFIX"

#make a temp file to use for the output of the PDF
OUTPUT=`mktemp -q $TEMP/$BASEFILE-XXXXXX`
if [ $? -ne 0 ]; then
	echo "$0: Can't create temp file $TEMP/$OUTPUT, exiting..."
	exit 1
fi
if [ -n "$NAME" ]; then
	FINALOUTPUT="$PREFIX/$NAME"
else
	FINALOUTPUT="$OUTPUT"
fi
if [ -n "$7" ]; then
	OPTIONS="$OPTIONS -dPDFSETTINGS=/${7#pdf-}"
else
	OPTIONS="$OPTIONS -dPDFSETTINGS=/default"
fi

WIN_OUTPUT="$WINBASE\\"`basename "$FINALOUTPUT"`
#mv "$INPUT" "$INPUT.ps";INPUT="$INPUT.ps"

# create the pdf
$PS2PDF $OPTIONS "$INPUT" "$OUTPUT.pdf" >/dev/null 2>&1
mv -f "${OUTPUT}.pdf" "${FINALOUTPUT}".pdf

# Generate a message to send to the user, and deal with the original file:
MESSAGE=$(echo "Your PDF file has been created as $WIN_OUTPUT.pdf\n")


# Cleanup
if [ $KEEP_PS != 0 ];then
	mv -f $INPUT "${FINALOUTPUT}".ps
	MESSAGE=$(echo "$MESSAGE and your postscript file as $WIN_OUTPUT.ps")
	# Fix permissions on the generated files
	chmod $PERMS "${FINALOUTPUT}".ps "${FINALOUTPUT}".pdf
else
	rm -f $INPUT
	# Fix permissions on the generated files
	chmod $PERMS "${FINALOUTPUT}".pdf
fi
                                            
#Remove empty file from mktemp:
rm -f  $OUTPUT

# Send notification to user
echo -e $MESSAGE|smbclient -M $4 -I $5 -U "PDF Generator" >/dev/null 2>&1

