/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_SYS_MACHASI_H
#define	_SYS_MACHASI_H

#pragma ident	"@(#)machasi.h	1.14	05/06/30 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Spitfire ancillary state registers, for asrset_t
 */
#define	ASR_GSR	(3)

/*
 * alternate address space identifiers
 *
 * 0x00 - 0x7F are privileged
 * 0x80 - 0xFF can be used by users
 */


/*
 * UltraSPARC ASIs
 */
#define	ASI_NQUAD_LD		0x24	/* 128-bit atomic load */
#define	ASI_NQUAD_LD_L		0x2c	/* 128-bit atomic load little */

#define	ASI_QUAD_LDD_PHYS	0x34	/* 128-bit physical atomic load */
#define	ASI_QUAD_LDD_PHYS_L	0x3C	/* 128-bit phys. atomic load little */

#define	ASI_INTR_DISPATCH_STATUS 0x48	/* interrupt vector dispatch status */
#define	ASI_INTR_RECEIVE_STATUS	0x49	/* interrupt vector receive status */

#define	ASI_BLK_AIUP		0x70	/* block as if user primary */
#define	ASI_BLK_AIUS		0x71	/* block as if user secondary */

#define	ASI_SDB_INTR_W		0x77	/* interrupt vector dispatch */
#define	ASI_SDB_INTR_R		0x7F	/* incoming interrupt vector */
#define	ASI_INTR_DISPATCH	ASI_SDB_INTR_W
#define	ASI_INTR_RECEIVE	ASI_SDB_INTR_R

#define	ASI_BLK_AIUPL		0x78	/* block as if user primary little */
#define	ASI_BLK_AIUSL		0x79	/* block as if user secondary little */

/*
 * Spitfire asis
 */
#define	ASI_LSU			0x45	/* load-store unit control */
#define	ASI_DC_INVAL		0x42	/* d$ invalidate */


#define	ASI_DC_DATA		0x46	/* d$ data */
#define	ASI_DC_TAG		0x47	/* d$ tag */

#define	ASI_UPA_CONFIG		0x4A	/* upa configuration reg */

#define	ASI_ESTATE_ERR		0x4B	/* estate error enable reg */

#define	ASI_AFSR		0x4C	/* asynchronous fault status */
#define	ASI_AFAR		0x4D	/* asynchronous fault address */

#define	ASI_IMMU		0x50	/* instruction mmu */
#define	ASI_IMMU_TSB_8K		0x51	/* immu tsb 8k ptr */
#define	ASI_IMMU_TSB_64K	0x52	/* immu tsb 64k ptr */
#define	ASI_DEVICE_SERIAL_ID	0x53	/* device serial id */
#define	ASI_ITLB_IN		0x54	/* immu tlb data in */
#define	ASI_ITLB_ACCESS		0x55	/* immu tlb data access */
#define	ASI_ITLB_TAGREAD	0x56	/* immu tlb tag read */
#define	ASI_ITLB_DEMAP		0x57	/* immu tlb demap */

#define	ASI_DMMU		0x58	/* data mmu */
#define	ASI_MMU_CTX		ASI_DMMU
#define	ASI_DMMU_TSB_8K		0x59	/* dmmu tsb 8k ptr */
#define	ASI_DMMU_TSB_64K	0x5A	/* dmmu tsb 64k ptr */
#define	ASI_DMMU_TSB_DIRECT	0x5B	/* dmmu tsb direct ptr */
#define	ASI_DTLB_IN		0x5C	/* dmmu tlb data in */
#define	ASI_DTLB_ACCESS		0x5D	/* dmmu tlb data access */
#define	ASI_DTLB_TAGREAD	0x5E	/* dmmu tlb tag read */
#define	ASI_DTLB_DEMAP		0x5F	/* dmmu tlb demap */

#define	ASI_IC_DATA		0x66	/* i$ data */
#define	ASI_IC_TAG		0x67	/* i$ tag */
#define	ASI_IC_DECODE		0x6E	/* i$ pre-decode */
#define	ASI_IC_NEXT		0x6F	/* i$ next field */

#define	ASI_EC_W		0x76	/* e$ access write */
#define	ASI_EC_R		0x7E	/* e$ access read */
#define	ASI_EC_DIAG		0x4E	/* e$ diagnostic reg */
					/* PRM calls this ASI_ECACHE_TAG */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_MACHASI_H */
