/*
 * Copyright (c) 1999-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_SYS_FIBRE_CHANNEL_FCA_QLC_DEBUG_H
#define	_SYS_FIBRE_CHANNEL_FCA_QLC_DEBUG_H

#pragma ident	"@(#)qlc_debug.h	1.3	00/10/11 SMI"

/*
 * Qlogic ISP2200/ISP2202 FCA driver header
 */

/*
 * ISP2200 Extended LUN Solaris SPARC v2.7/v2.8
 * Fibre Channel Adapter (FCA) driver debug include file.
 *
 * ***********************************************************************
 * *									**
 * *				NOTICE					**
 * *		COPYRIGHT (C) 1996-2000 QLOGIC CORPORATION		**
 * *			ALL RIGHTS RESERVED				**
 * *									**
 * *	This  computer program is CONFIDENTIAL and contains TRADE	**
 * *	SECRETS of QLOGIC CORPORATION. The receipt or possession of	**
 * *	this program does not convey any rights to reproduce or		**
 * *	disclose its contents, or to manufacture, use, or sell anything **
 * *	that it may describe, in whole or in part, without the specific **
 * *	written consent of QLOGIC CORPORATION. Any reproduction of this **
 * *	program without the express written consent of  QLOGIC		**
 * *	CORPORATION is a violation of the copyright laws and may	**
 * *	subject you to civil liability and criminal prosecution.	**
 * *									**
 * ***********************************************************************
 */


#ifdef	__cplusplus
extern "C" {
#endif


/*
 * Message printing levels
 *	QDL_1 	Output register accesses
 *	QDL_2 	Output error msgs
 *	QDL_3 	Output function trace msgs
 *	QDL_4 	Output NVRAM trace msgs
 *	QDL_5 	Output ring trace msgs
 *	QDL_6 	Output WATCHDOG timer trace
 *	QDL_7 	Output ring staturation msgs
 *	QDL_8	Undocumented
 *	QDL_9	Output target mode trace
 */
#define	QDL_1		0x0001
#define	QDL_2		0x0002
#define	QDL_3		0x0004
#define	QDL_4		0x0008
#define	QDL_5		0x0010
#define	QDL_6		0x0020
#define	QDL_7		0x0040
#define	QDL_8		0x0080
#define	QDL_9		0x0100
#define	QDL_2_OR_3	(QDL_2 | QDL_3)

#ifdef	DEBUG

#define	QLC_PRINT(level, args)\
	if (qlc_debug & (level)) qlc_print args

#define	QLC_PRINT_BUFFER(level, args)\
	if (qlc_debug & (level)) qlc_print_buffer args

/* Number radix. */
#define	SDBG_NO_NUM	0	/* No number. */
#define	SDBG_DEC_NUM	10	/* Decimal number. */
#define	SDBG_HEX_NUM	16	/* Hexadecimal number. */

/* Insert newline at end of srting. */
#define	SDBG_NL		1	/* Add newline. */
#define	SDBG_NNL	0	/* No newline. */

#define	SDBG_CONSOLE		/* Output to console instead of COM2 */
#define	SDBG_CONSOLE_DELAY	5	/* In clock ticks. */

/*
 * Global Data in qlc_debug.c source file.
 */
extern uint8_t sdbg_print;
extern int qlc_debug;

/*
 * Global Function Prototypes in qlc_debug.c source file.
 */
uint8_t qlc_getbyte(qlc_adapter_state_t *, uint8_t *);
uint16_t qlc_getword(qlc_adapter_state_t *, uint16_t *);
uint32_t qlc_getdword(qlc_adapter_state_t *, uint32_t *);
void qlc_putbyte(qlc_adapter_state_t *, uint8_t *, uint8_t);
void qlc_putword(qlc_adapter_state_t *, uint16_t *, uint16_t);
void qlc_putdword(qlc_adapter_state_t *, uint32_t *, uint32_t);
void qlc_print(char *, uint64_t, uint8_t, uint8_t);
void qlc_print_buffer(char *, uint8_t *, uint8_t, uint32_t);

#else

#define	QLC_PRINT_BUFFER(level, args)
#define	QLC_PRINT(level, args)

#endif	/* DEBUG */

#ifdef	__cplusplus
}
#endif

#endif /* !_SYS_FIBRE_CHANNEL_FCA_QLC_DEBUG_H */
