/*
 * Copyright (c) 2001 by Fujitsu Softwate Corp.
 * All rights reserved.
 */

#pragma ident	 "@(#)sfdr_mig.h        1.0      06/05/01 FS"

#ifndef	_SYS_SFDR_MIG_H
#define	_SYS_SFDR_MIG_H

#ifdef	__cplusplus
extern "C" {
#endif

#define FMA_TIMEOUT (17)
#define FMA_MAX_CNT (15)

/*
 * UC#1517: The macro, RTN_INSTR and ZEUS_PADDING are confusing. 
 * UC#1509: The value of FMA_SIZE macro is 8 byte less.
 *
 * RTN_INSTR is the start address.
 */
#define RTN_INSTR (2*4)
#define FMA_LOOP_ADDR (RTN_INSTR)
#define FMA_SCF_CMD_ADDR (FMA_LOOP_ADDR+2*4)
#define FMA_TIMEOUT_ADDR (FMA_SCF_CMD_ADDR+2*4)
#define FMA_BOARD1	(FMA_TIMEOUT_ADDR+2*4)
#define FMA_BOARD2	(FMA_BOARD1+2*4)
#define FMA_SWAP_BOARDS	(FMA_BOARD2+2*4)
#define ZEUS_PADDING	(1024)

#define FMA_SIZE	(FMA_SWAP_BOARDS + RTN_INSTR + ZEUS_PADDING)
#define LOOP_SIZE	(RTN_INSTR + ZEUS_PADDING)

/* error code */
#define FMA_COMPLETE	(0)
#define FMA_TIME_OUT	(1)
#define FMA_BUSY	(2)
#define	FMA_RETRY_OUT	(3)

#define FJSV_MBOX_START (0)
#define FJSV_MBOX_FLUSH (1)
#define FJSV_MBOX_CP (2)
#define FJSV_MBOX_CACHE_LOAD (3)
#define FJSV_MBOX_END (4)
#define FJSV_MBOX_FAILURE (-1)

#define FJSV_PAGE_8K	(3)
#define FJSV_PAGE_64K	(2)
#define FJSV_PAGE_512K	(1)
#define FJSV_PAGE_4M	(0)

#define FJSV_GET_MAP_SIZE(x)	\
(((x) == FJSV_PAGE_8K) ? MMU_PAGESIZE : \
((x) == FJSV_PAGE_64K) ? MMU_PAGESIZE64K : \
((x) == FJSV_PAGE_512K) ? MMU_PAGESIZE512K : \
((x) == FJSV_PAGE_4M) ? MMU_PAGESIZE4M : -1 )

#define FJSV_GET_MAP_MASK(x)	\
(((x) == FJSV_PAGE_8K) ? MMU_PAGEMASK : \
((x) == FJSV_PAGE_64K) ? MMU_PAGEMASK64K : \
((x) == FJSV_PAGE_512K) ? MMU_PAGEMASK512K : \
((x) == FJSV_PAGE_4M) ? MMU_PAGEMASK4M : -1 )

#define FJSV_GET_MAP_TTE(x)	\
(((x) == FJSV_PAGE_8K) ? TTE8K : \
((x) == FJSV_PAGE_64K) ? TTE64K : \
((x) == FJSV_PAGE_512K) ? TTE512K : \
((x) == FJSV_PAGE_4M) ? TTE4M : -1 )

#define SCF_BUSY_MASK	(0x8000)
#define SCF_STATUS_OFFSET (0x4)
#define SCF_T0_DATA_REG (0x10)
#define SCF_T1_DATA_REG (0x14)
#define SCF_T2_DATA_REG (0x18)
#define SCF_T3_DATA_REG (0x1c)

/* Status Register  */
#define STATUS_SCF_READY        (0x8000)
#define STATUS_SHUTDOWN         (0x4000)
#define STATUS_POFF             (0x2000)
#define STATUS_EVENT            (0x1000)
#define STATUS_TIMER_ADJUST     (0x0800)
#define STATUS_ALIVE            (0x0400)
#define STATUS_MODE_CHANGED     (0x0200)
#define STATUS_CMD_U_PARITY     (0x0100)
#define STATUS_CMD_RTN_CODE     (0x00f0)
#define STATUS_MODE_SWITCH      (0x000c)
#define STATUS_CMD_COMPLETE     (0x0002)
#define STATUS_CMD_L_PARITY     (0x0001)

/* SCF Command register  */
#define CMD_SCFC_PATH           (0x10)          /* SCFI */
#define CMD_FMA_CTRL            (0xff)          /* FMA */
#define SUB_CMD_PATH            (0x00)
#define SUB_PA_SWAP             (0x01)
#define NORMAL_END              (0x00)
#define E_SCFC_NOPATH           (0x0a)          /* SCFI */

#define	TRUE	(1)
#define	FALSE	(0)

#define FMA_MEM	(1)
#define NOT_FMA (0)

#define TAG_PA_MASK	(0x3FFFFC00)
#define INDEX_MASK	(0x00FFFFC0)
#define FJSV_GET_PA(tag, index) (((tag) & TAG_PA_MASK) << (22-10) | ((index) & INDEX_MASK))
#define U2TAG_MOESI_VALID_BIT  0x4
#define FJSV_LINE_IS_CLEAN(tag) (((tag) & U2TAG_MOESI_VALID_BIT) == 0x0)

#define	PA_IN_BOARD(pa, b)			\
	(((pa) >= board_mem_ranges[b].low) &&	\
	 ((pa) < board_mem_ranges[b].high))

#ifdef _COLUMBUS
#define	MEMLESS_BOARD(b)			\
	((board_mem_ranges[b].low == 0) &&	\
	(board_mem_ranges[b].high == 0))
#else /* Kaiser */
#define	MEMLESS_BOARD(b)						\
	((board_mem_ranges[b].low == board_mem_ranges[b].obp_low) &&	\
	(board_mem_ranges[b].high == board_mem_ranges[b].obp_high))
#endif /* _COLUMBUS */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_SFDR_MIG_H */
