/*
 * Copyright (c) 1999-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_SYS_FIBRE_CHANNEL_FCA_QLC_IOCTL_H
#define	_SYS_FIBRE_CHANNEL_FCA_QLC_IOCTL_H

#pragma ident	"@(#)qlc_ioctl.h	1.3	00/06/01 SMI"

/*
 * ISP2200 Extended LUN Solaris SPARC v2.7/v2.8
 * Fibre Channel Adapter (FCA) driver IOCTL include file.
 *
 * ***********************************************************************
 * *									**
 * *				NOTICE					**
 * *		COPYRIGHT (C) 1996-2000 QLOGIC CORPORATION		**
 * *			ALL RIGHTS RESERVED				**
 * *									**
 * *	This  computer program is CONFIDENTIAL and contains TRADE	**
 * *	SECRETS of QLOGIC CORPORATION. The receipt or possession of	**
 * *	this program does not convey any rights to reproduce or		**
 * *	disclose its contents, or to manufacture, use, or sell anything **
 * *	that it may describe, in whole or in part, without the specific **
 * *	written consent of QLOGIC CORPORATION. Any reproduction of this **
 * *	program without the express written consent of  QLOGIC		**
 * *	CORPORATION is a violation of the copyright laws and may	**
 * *	subject you to civil liability and criminal prosecution.	**
 * *									**
 * ***********************************************************************
 */


#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Global Function Prototypes in qlc_ioctl.c source file.
 */
int qlc_ioctl(dev_t, int, intptr_t, int, cred_t *, int *);
int qlc_open(dev_t *dev_p, int flags, int otyp, cred_t *cred_p);
int qlc_close(dev_t dev, int flags, int otyp, cred_t *cred_p);

/*
 * defines to aid in FCODE download and Diagnostics of 220x adapters
 */
#define	QLC_FCODE_VERSTROFFSET		0x4e
#define	QLC_FCODE_VERSTRLEN		80

/*
 * new diag switch clause hooks provided for requested diagnostic functionality
 * (Check command Queue, Revision Level, Firmwware Checksum, Self Test,
 * Loopback Mailbox, Loopback Data, Execute Firmware)
 */
#define	QLC_DIAG_CHKCMDQUE 		0
#define	QLC_DIAG_FMWCHKSUM 		1
#define	QLC_DIAG_SLFTST 		2
#define	QLC_DIAG_REVLVL 		3
#define	QLC_DIAG_LPBMBX 		4
#define	QLC_DIAG_LPBDTA 		5
#define	QLC_DIAG_EXEFMW 		6
#define	QLC_GET_ADAPTER_FEATURE_BITS	7
#define	QLC_SET_ADAPTER_FEATURE_BITS	8
#define	QLC_SET_ADAPTER_NVRAM_DEFAULTS	9

/*
 * QLogic NVRAM utility IOCTL
 */
#define	QLC_UTIL_LOAD	100
#define	QLC_UTIL_DUMP	101

#ifdef	__cplusplus
}
#endif

#endif /* !_SYS_FIBRE_CHANNEL_FCA_QLC_IOCTL_H */
