/*
 * Copyright (c) 1999-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _SYS_CHEETAHREGS_H
#define	_SYS_CHEETAHREGS_H

#pragma ident	"@(#)cheetahregs.h	1.4	00/08/24 SMI"

#include <sys/spitasi.h>

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * This file is cpu dependent.
 */

#ifdef _KERNEL

#ifdef _ASM
/*
 * assembler doesn't understand the 'ull' suffix for C constants so
 * use the inttypes.h macros and undefine them here for assembly code
 */
#undef INT64_C
#define	INT64_C(x)	(x)
#endif

/*
 * DCU Control Register
 *
 * +------+----+----+----+----+----+-----+-----+----+----+----+
 * | Resv | CP | CV | ME | RE | PE | HPE | SPE | SL | WE | PM |
 * +------+----+----+----+----+----+-----+-----+----+----+----+
 *  63:50   49   48   47   46	45    44    43   42   41 40:33
 *
 * +----+----+----+----+----+------------+----+----+----+---+
 * | VM | PR | PW | VR | VW | Reserved   | DM | IM | DC | IC|
 * +----+----+----+----+----+------------+----+----+----+---+
 * 32:25  24   23   22   21      20:4       3    2    1   0
 */

#define	ASI_DCU	ASI_LSU			    /* same as spitfire ASI_LSU 0x45 */
#define	DCU_IC	INT64_C(0x0000000000000001) /* icache enable		*/
#define	DCU_DC	INT64_C(0x0000000000000002) /* dcache enable		*/
#define	DCU_IM	INT64_C(0x0000000000000004) /* immu enable		*/
#define	DCU_DM	INT64_C(0x0000000000000008) /* dmmu enable		*/
#define	DCU_VW	INT64_C(0x0000000000200000) /* virt watchpoint write enable  */
#define	DCU_VR	INT64_C(0x0000000000400000) /* virt watchpoint read enable   */
#define	DCU_PW	INT64_C(0x0000000000800000) /* phys watchpoint write enable  */
#define	DCU_PR	INT64_C(0x0000000001000000) /* phys watchpoint read enable   */
#define	DCU_VM	INT64_C(0x00000001FE000000) /* virtual watchpoint write mask */
#define	DCU_PM	INT64_C(0x000001FE00000000) /* phys watchpoint write mask    */
#define	DCU_WE	INT64_C(0x0000020000000000) /* write cache enable	*/
#define	DCU_SL	INT64_C(0x0000040000000000) /* second load control	*/
#define	DCU_SPE	INT64_C(0x0000080000000000) /* software prefetch enable */
#define	DCU_HPE	INT64_C(0x0000100000000000) /* hardware prefetch enable */
#define	DCU_PE	INT64_C(0x0000200000000000) /* prefetch enable		*/
#define	DCU_RE	INT64_C(0x0000400000000000) /* RAW bypass enable	*/
#define	DCU_ME	INT64_C(0x0000800000000000) /* noncache store merging enable */
#define	DCU_CV	INT64_C(0x0001000000000000) /* virt cacheability when DM=0   */
#define	DCU_CP	INT64_C(0x0002000000000000) /* phys cacheable when DM,IM=0   */
#define	DCU_CACHE (DCU_IC|DCU_DC|DCU_WE|DCU_SPE|DCU_HPE|DCU_PE)

/*
 * Safari Configuration Register
 */
#define	ASI_SAFARI_CONFIG	ASI_UPA_CONFIG /* Safari Config Reg, 0x4A */
#define	SAFARI_CONFIG_ECLK_1	INT64_C(0x0000000000000000) /* 1/1 clock */
#define	SAFARI_CONFIG_ECLK_1_DIV	1	/* clock divisor: 1 */
#define	SAFARI_CONFIG_ECLK_2	INT64_C(0x0000000040000000) /* 1/2 clock */
#define	SAFARI_CONFIG_ECLK_2_DIV	2	/* clock divisor: 2 */
#define	SAFARI_CONFIG_ECLK_32	INT64_C(0x0000000080000000) /* 1/32 clock */
#define	SAFARI_CONFIG_ECLK_32_DIV	32	/* clock divisor: 32 */
#define	SAFARI_CONFIG_ECLK_MASK	(SAFARI_CONFIG_ECLK_32 | SAFARI_CONFIG_ECLK_2)
#define	ASI_MC_DECODE	0x72	/* Memory Address Decoding Registers */


/*
 * Defines for the different types of dcache_flush
 * it is stored in dflush_type
 */
#define	FLUSHALL_TYPE	0x0		/* blasts all cache lines */
#define	FLUSHMATCH_TYPE	0x1		/* flush entire cache but check each */
					/* each line for a match */
#define	FLUSHPAGE_TYPE	0x2		/* flush only one page and check */
					/* each line for a match */

/*
 * D-Cache Tag Data Register
 *
 * +----------+--------+----------+
 * | Reserved | DC_Tag | DC_Valid |
 * +----------+--------+----------+
 *  63	    31 30     1		 0
 *
 */
#define	ICACHE_FLUSHSZ	0x20	/* one line in i$ */
#define	CHEETAH_DC_VBIT_SHIFT	1
#define	CHEETAH_DC_VBIT_MASK	0x1

/*
 * Definitions of UltraSparc III cpu implementations as specified
 * in version register
 */
#define	CHEETAH_IMPL			0x14
#define	IS_CHEETAH(impl)		((impl) == CHEETAH_IMPL)
#define	CHEETAH_MAJOR_VERSION(rev)	(((rev) >> 4) & 0xf)
#define	CHEETAH_MINOR_VERSION(rev)	((rev) & 0xf)

/*
 * Cheetah includes the process info in its mask to make things
 * more difficult.  The process is the low bit of the major mask,
 * so to convert to the netlist major:
 * netlist_major = ((mask_major >> 1) + 1)
 */
#define	REMAP_CHEETAH_MASK(x)	(((((x) >> 1) + 0x10) & 0xf0) | ((x) & 0xf))

/*
 * Bits of Cheetah Asynchronous Fault Status Register
 *
 * +---+--+----+----+----+----+---+---+---+---+--+----
 * |rsv|ME|PRIV|PERR|IERR|ISAP|EMC|EMU|IVC|IVU|TO|BERR
 * +---+--+----+----+----+----+---+---+---+---+--+----
 * 63:54 53 52   51   50   49   48  47  46  45 44  43
 * +---+---+---+---+---+---+---+---+--+--+---+------+---+-------+
 * |UCC|UCU|CPC|CPU|WDC|WDU|EDC|EDU|UE|CE|rsv|M_SYND|rsv||E_SYND|
 * +---+---+---+---+---+---+---+---+--+--+---+------+---+-------+
 *   42  41  40  39  38  37  36  35 34 33 32:20 19:16 15:9 8:0
 *
 */
#define	C_AFSR_ME   INT64_C(0x0020000000000000)	/* errors > 1, same type!=CE */
#define	C_AFSR_PRIV INT64_C(0x0010000000000000)	/* priv code access error    */
#define	C_AFSR_PERR INT64_C(0x0008000000000000)	/* system interface protocol */
#define	C_AFSR_IERR INT64_C(0x0004000000000000)	/* internal system interface */
#define	C_AFSR_ISAP INT64_C(0x0002000000000000)	/* system request parity err */
#define	C_AFSR_EMC  INT64_C(0x0001000000000000)	/* mtag   with   CE   error  */
#define	C_AFSR_EMU  INT64_C(0x0000800000000000)	/* mtag   with   UE   error  */
#define	C_AFSR_IVC  INT64_C(0x0000400000000000)	/* intr vector with CE error */
#define	C_AFSR_IVU  INT64_C(0x0000200000000000)	/* intr vector with UE error */
#define	C_AFSR_TO   INT64_C(0x0000100000000000)	/* bus timeout from sys bus  */
#define	C_AFSR_BERR INT64_C(0x0000080000000000)	/* bus error from system bus */
#define	C_AFSR_UCC  INT64_C(0x0000040000000000)	/* E$ with software CE error */
#define	C_AFSR_UCU  INT64_C(0x0000020000000000)	/* E$ with software UE error */
#define	C_AFSR_CPC  INT64_C(0x0000010000000000) /* copyout  with  CE  error  */
#define	C_AFSR_CPU  INT64_C(0x0000008000000000) /* copyout  with  UE  error  */
#define	C_AFSR_WDC  INT64_C(0x0000004000000000) /* writeback ecache CE error */
#define	C_AFSR_WDU  INT64_C(0x0000002000000000) /* writeback ecache UE error */
#define	C_AFSR_EDC  INT64_C(0x0000001000000000) /* ecache  CE  ECC  error    */
#define	C_AFSR_EDU  INT64_C(0x0000000800000000) /* ecache  UE  ECC  error    */
#define	C_AFSR_UE   INT64_C(0x0000000400000000) /* uncorrectable ECC error   */
#define	C_AFSR_CE   INT64_C(0x0000000200000000) /* correctable   ECC error   */
#define	C_AFSR_M_SYND	INT64_C(0x00000000000f0000) /* mtag  ECC  syndrome   */
#define	C_AFSR_E_SYND	INT64_C(0x00000000000001ff) /* data  ECC  syndrome   */

/* bit shifts for selected errors */
#define	C_AFSR_EDU_SHIFT	35
#define	C_AFSR_WDU_SHIFT	37
#define	C_AFSR_WDC_SHIFT	38
#define	C_AFSR_UCU_SHIFT	41
#define	C_AFSR_UCC_SHIFT	42
#define	C_AFSR_IVU_SHIFT	45

/*
 * Overloaded AFSR fields. During error processing, some of the reserved fields
 * within the saved AFSR are overwritten with extra information.
 */
#define	C_AFSR_TTYPE_SHIFT	20
#define	C_AFSR_TL_SHIFT		29
#define	C_AFSR_UCC_ORPHANED	60
#define	C_AFSR_UCU_ORPHANED	61
#define	C_AFSR_GOT_WDU_SHIFT	62
#define	C_AFSR_PERST_SHIFT	63

/* AFSR bits handled by cpu_ce_error() */
#define	C_AFSR_CE_ECC	(C_AFSR_EMC | C_AFSR_CE | C_AFSR_IVU | C_AFSR_IVC | \
			C_AFSR_UCC | C_AFSR_EDU | C_AFSR_EDC | \
			C_AFSR_CPC | C_AFSR_CPU | C_AFSR_WDC | C_AFSR_WDU)

/* AFSR bits handled by cpu_ce_error() due to an ecache error */
#define	C_AFSR_ECACHE	(C_AFSR_UCC | C_AFSR_EDU | C_AFSR_EDC | \
			C_AFSR_CPU| C_AFSR_CPC | C_AFSR_WDU | C_AFSR_WDC)

/* deferred I/D error trap AFSR bits */
#define	C_AFSR_UE_ECC	(C_AFSR_EMU | C_AFSR_UE | C_AFSR_EDU | C_AFSR_UCU)

/* Fatal traps */
#define	C_AFSR_FATAL	(C_AFSR_PERR | C_AFSR_IERR | C_AFSR_ISAP)

/* timeout traps */
#define	C_AFSR_TO_BERR	(C_AFSR_TO | C_AFSR_BERR)

/* All valid AFSR bits */
#define	C_AFSR_MASK	(C_AFSR_CE_ECC | C_AFSR_UE_ECC | C_AFSR_TO_BERR | \
			C_AFSR_FATAL | C_AFSR_PRIV | C_AFSR_ME | \
			C_AFSR_M_SYND | C_AFSR_E_SYND)

#define	C_M_SYND_SHIFT	16
#define	GET_M_SYND(afsr)	(((afsr) & C_AFSR_M_SYND) >> C_M_SYND_SHIFT)
#define	GET_E_SYND(afsr)	((afsr) & C_AFSR_E_SYND)

/*
 * Bits of Cheetah Asynchronous Fault Address Register
 */
#define	C_AFAR_PA INT64_C(0x000007fffffffff0) /* PA<42:4> physical address */

/*
 * Bits of Cheetah External Cache Error Enable Register
 *
 * +-----+-----+-------+-----+-------+-------+--------+-------+------+
 * | rsv | FMT | FMECC | FMD | FDECC | UCEEN | ISAPEN | NCEEN | CEEN |
 * +-----+-----+-------+-----+-------+-------+--------+-------+------+
 *  63:19   18  17  14    13    12:4     3        2       1       0
 *
 */
#define	EN_REG_FMT	INT64_C(0x0000000000040000) /* force system mtag ECC */
#define	EN_REG_FMECC	INT64_C(0x000000000003C000) /* forced mtag ECC vector */
#define	EN_REG_FMD	INT64_C(0x0000000000002000) /* force system data ECC */
#define	EN_REG_FDECC	INT64_C(0x0000000000001ff0) /* forced data ECC vector */
#define	EN_REG_UCEEN	INT64_C(0x0000000000000008) /* enable UCC,UCU */
#define	EN_REG_ISAPEN	INT64_C(0x0000000000000004) /* enable ISAP */
#define	EN_REG_NCEEN INT64_C(0x0000000000000002) /* UE,EDU,WDU,BERR,IVU,EMU */
#define	EN_REG_CEEN INT64_C(0x0000000000000001) /* enable CE,EDC,WDC,IVC,EMC */
#define	EN_REG_DISABLE	INT64_C(0x0000000000000000) /* no errors enabled */
#define	EN_REG_ECC_DISABLE (EN_REG_UCEEN | EN_REG_ISAPEN)
#define	EN_REG_CE_DISABLE (EN_REG_UCEEN | EN_REG_ISAPEN | EN_REG_NCEEN)
#define	EN_REG_ENABLE \
	(EN_REG_UCEEN | EN_REG_ISAPEN | EN_REG_NCEEN | EN_REG_CEEN)

#endif /* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_CHEETAHREGS_H */
