/*
 * Copyright (c) 2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_SYS_SYSEVENT_EVENTDEFS_H
#define	_SYS_SYSEVENT_EVENTDEFS_H

#pragma ident	"@(#)eventdefs.h	1.1	00/06/09 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * eventdefs.h contains public definitions for sysevent types (classes
 * and subclasses).  All additions/removal/changes are subject
 * to PSARC approval.
 */

/* Sysevent Class definitions */
#define	EC_NONE	"EC_none"
#define	EC_PRIV	"EC_priv"
#define	EC_PLATFORM	"EC_platform"	/* events private to platform */
#define	EC_DR	"EC_dr"		/* Dynamic reconfiguration event class */
#define	EC_ENV	"EC_env"	/* Environmental monitor event class */
#define	EC_DOMAIN	"EC_domain"	/* Domain event class */
#define	EC_AP_DRIVER	"EC_ap_driver"	/* Alternate Pathing event class */

/*
 * EC_DR subclass definitions - supporting attributes (name/value pairs)
 * are found in sys/sysevent/dr.h
 */

/* Attachment point state change */
#define	ESC_DR_AP_STATE_CHANGE	"ESC_dr_ap_state_change"
#define	ESC_DR_REQ	"ESC_dr_req"	/* Request DR */

/*
 * EC_ENV subclass definitions - supporting attributes (name/value pairs)
 * are found in sys/sysevent/env.h
 */
#define	ESC_ENV_TEMP	"ESC_env_temp"	/* Temperature change event subclass */
#define	ESC_ENV_FAN	"ESC_env_fan"	/* Fan status change event subclass */
#define	ESC_ENV_POWER	"ESC_env_power"	/* Power supply change event subclass */

/*
 * EC_DOMAIN subclass definitions - supporting attributes (name/value pairs)
 * are found in sys/sysevent/domain.h
 */

/* Domain state change */
#define	ESC_DOMAIN_STATE_CHANGE	"ESC_domain_state_change"
/* Domain loghost name change */
#define	ESC_DOMAIN_LOGHOST_CHANGE "ESC_domain_loghost_change"

/*
 * EC_AP_DRIVER subclass defintions - supporting attributes (name/value pairs)
 * are found in sys/sysevent/ap_driver.h
 */

/* Alternate Pathing path switch */
#define	ESC_AP_DRIVER_PATHSWITCH	"ESC_ap_driver_pathswitch"
/* Alternate Pathing database commit */
#define	ESC_AP_DRIVER_COMMIT		"ESC_ap_driver_commit"
/* Alternate Pathing physical path status change */
#define	ESC_AP_DRIVER_PHYS_PATH_STATUS_CHANGE	\
	"ESC_ap_driver_phys_path_status_change"

#ifdef	__cplusplus
}
#endif

#endif /* _SYS_SYSEVENT_EVENTDEFS_H */
