/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.pm.client;

import com.sun.admin.pm.client.pmHelpContent;
import com.sun.admin.pm.client.pmHelpController;
import com.sun.admin.pm.client.pmHelpItem;
import com.sun.admin.pm.client.pmHelpLoc;
import com.sun.admin.pm.client.pmHelpRepository;
import com.sun.admin.pm.client.pmHelpSeeAlsoPanel;
import com.sun.admin.pm.client.pmHelpViewPanel;
import com.sun.admin.pm.client.pmUtility;
import com.sun.admin.pm.server.Debug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class pmHelpDetailPanel
extends JPanel {
    pmHelpController controller;
    pmHelpSeeAlsoPanel seeAlsoPanel;
    pmHelpViewPanel viewPanel;
    pmHelpLoc[] history;
    int historyIndex;
    int historyLast;
    static final int MAX_HISTORY_ITEMS = 101;

    public pmHelpDetailPanel(pmHelpController pmHelpController2) {
        this.controller = pmHelpController2;
        this.seeAlsoPanel = new pmHelpSeeAlsoPanel(this);
        this.viewPanel = new pmHelpViewPanel(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 6.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.viewPanel, gridBagConstraints);
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.seeAlsoPanel, gridBagConstraints);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.history = new pmHelpLoc[101];
        this.historyIndex = 0;
        this.historyLast = 0;
        this.controller.outerPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                Debug.info((String)"HELP:  Tab event!");
                if (!(jTabbedPane.getSelectedComponent() instanceof pmHelpDetailPanel)) {
                    Debug.info((String)"HELP:  Tab event: resetting default");
                    if (pmHelpDetailPanel.this.controller.frame.dismiss != null) {
                        pmHelpDetailPanel.this.controller.frame.dismiss.setAsDefaultButton();
                    }
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                Debug.info((String)"HELP:  detailPanel gained focus");
                if (pmHelpDetailPanel.this.controller.frame.dismiss != null) {
                    pmHelpDetailPanel.this.controller.frame.dismiss.setAsDefaultButton();
                }
            }
        });
    }

    private void loadEmptyItem(String string) {
        String string2 = new String(String.valueOf(pmUtility.getResource("Item.not.found:")) + string);
        this.viewPanel.setItem(string2, new pmHelpContent(pmUtility.getResource("No.information.available.")));
        this.seeAlsoPanel.setItems(null);
    }

    protected pmHelpItem loadItem(pmHelpItem pmHelpItem2) {
        return this.loadItem(pmHelpItem2, new Point(0, 0));
    }

    protected pmHelpItem loadItem(pmHelpItem pmHelpItem2, Point point) {
        Debug.message((String)("HELP:  View: loadItem " + pmHelpItem2.tag));
        this.seeAlsoPanel.setItems(pmHelpItem2.seealso);
        Debug.info((String)("loadItem: pos is " + point));
        this.viewPanel.setItem(pmHelpItem2.title, pmHelpItem2.content);
        this.viewPanel.setPos(point);
        return pmHelpItem2;
    }

    public pmHelpItem loadItemForTag(String string) {
        pmHelpItem pmHelpItem2;
        if (string == null || (pmHelpItem2 = pmHelpRepository.helpItemForTag(string)) == null) {
            Debug.warning((String)"HELP:  View: item not found");
            this.loadEmptyItem(string);
            return null;
        }
        Debug.info((String)("loadItem(before): index = " + this.historyIndex + ", last = " + this.historyLast));
        if (this.historyIndex != 0 && this.historyLast != 0) {
            this.history[this.historyIndex].pos = this.viewPanel.getPos();
        }
        this.loadItem(pmHelpItem2);
        Debug.info((String)("HELP:  loadItemForTag: index = " + this.historyIndex + " last = " + this.historyLast + "\n\thistory = " + this.history));
        if (this.historyIndex < this.history.length - 1) {
            this.history[++this.historyIndex] = new pmHelpLoc(pmHelpItem2);
        } else {
            this.history[this.historyIndex] = new pmHelpLoc(pmHelpItem2);
        }
        this.historyLast = this.historyIndex;
        this.viewPanel.setNavButtons(this.historyIndex, this.historyLast);
        Debug.info((String)("loadItem(after): index = " + this.historyIndex + ", last = " + this.historyLast));
        return pmHelpItem2;
    }

    public void showHistoryBackItem() {
        Debug.message((String)("HELP:  showHistoryBackItem: index = " + this.historyIndex + " last = " + this.historyLast + "\n\thistory = " + this.history));
        this.history[this.historyIndex].pos = this.viewPanel.getPos();
        Debug.info((String)("back: pos is " + this.history[this.historyIndex].pos));
        if (this.historyIndex > 1) {
            pmHelpLoc pmHelpLoc2 = this.history[--this.historyIndex];
            pmHelpItem pmHelpItem2 = pmHelpLoc2.item;
            Point point = pmHelpLoc2.pos;
            this.loadItem(pmHelpItem2, point);
        }
        this.viewPanel.setNavButtons(this.historyIndex, this.historyLast);
    }

    public void showHistoryForwardItem() {
        Debug.message((String)("HELP:  showHistoryForwardItem: index = " + this.historyIndex + " last = " + this.historyLast + "\n\thistory = " + this.history));
        this.history[this.historyIndex].pos = this.viewPanel.getPos();
        Debug.info((String)("HELP:  fwd: pos is " + this.history[this.historyIndex].pos));
        if (this.historyIndex < this.historyLast) {
            pmHelpLoc pmHelpLoc2 = this.history[++this.historyIndex];
            pmHelpItem pmHelpItem2 = pmHelpLoc2.item;
            Point point = pmHelpLoc2.pos;
            this.loadItem(pmHelpItem2, point);
        }
        this.viewPanel.setNavButtons(this.historyIndex, this.historyLast);
    }

    public void showItem(String string) {
        this.controller.showHelpItem(string);
    }
}

