/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mofc;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.compiler.mofc.I18N;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

class XmlWriter {
    private BufferedWriter xmlOut;
    private BufferedWriter bigxmlOut;
    private String fileName = "mof.xml";
    private String bigfileName = "bigmof.xml";
    private String className = "";
    private String startTag = "<?xml version=\"1.0\"?>";

    public XmlWriter() {
        I18N.setResourceName("com.sun.wbem.compiler.mofc.Compiler");
    }

    BufferedWriter getBigFile() {
        return this.bigxmlOut;
    }

    BufferedWriter getFile() {
        return this.xmlOut;
    }

    BufferedWriter openBigXmlFile() {
        try {
            BufferedWriter bufferedWriter;
            File file = new File(this.bigfileName);
            if (file.exists()) {
                file.delete();
            }
            this.bigxmlOut = bufferedWriter = new BufferedWriter(new FileWriter(this.bigfileName, true));
            this.writeBigStartTags(bufferedWriter);
        }
        catch (IOException iOException) {
            System.out.println(I18N.loadStringFormat("CANNOT_CREATE_FILE", this.fileName));
            System.exit(1);
        }
        return this.bigxmlOut;
    }

    BufferedWriter openXmlFile() {
        try {
            BufferedWriter bufferedWriter;
            File file = new File(this.fileName);
            if (file.exists()) {
                file.delete();
            }
            this.xmlOut = bufferedWriter = new BufferedWriter(new FileWriter(this.fileName, true));
            this.writeStartTags(bufferedWriter);
        }
        catch (IOException iOException) {
            System.out.println(I18N.loadStringFormat("CANNOT_CREATE_FILE", this.fileName));
            System.exit(1);
        }
        return this.xmlOut;
    }

    void writeAllClasses(CIMClass cIMClass, BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write("<CLASS NAME=\"");
            bufferedWriter.write(cIMClass.getName());
            if (cIMClass.getSuperClass().length() != 0) {
                bufferedWriter.write("\" SUPERCLASS=\"");
                bufferedWriter.write(cIMClass.getSuperClass());
            }
            if (cIMClass.isAssociation()) {
                bufferedWriter.write("\" ASSOCIATION=\"true");
            }
            bufferedWriter.write("\" />");
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            System.out.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeBigEndTags(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write("</VALUE.OBJECT>");
            bufferedWriter.newLine();
            bufferedWriter.write("</DECLGROUP>");
            bufferedWriter.newLine();
            bufferedWriter.write("</DECLARATION>");
            bufferedWriter.newLine();
            bufferedWriter.write("</CIM>");
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeBigStartTags(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write(this.startTag);
            bufferedWriter.newLine();
            bufferedWriter.write("<CIM CIMVERSION=\"2.0\" DTDVERSION=\"2.0\">");
            bufferedWriter.newLine();
            bufferedWriter.write("<DECLARATION>");
            bufferedWriter.newLine();
            bufferedWriter.write("<DECLGROUP>");
            bufferedWriter.newLine();
            bufferedWriter.write("<VALUE.OBJECT>");
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            System.out.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeBigXml(CIMClass cIMClass, BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write(cIMClass.toXml());
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            System.out.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeClass(CIMClass cIMClass) {
        try {
            this.className = String.valueOf(cIMClass.getName()) + ".xml";
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(String.valueOf(cIMClass.getName()) + ".xml", false));
            bufferedWriter.write(this.startTag);
            bufferedWriter.newLine();
            bufferedWriter.write("<CIM CIMVERSION=\"2.0\" DTDVERSION=\"2.0\">");
            bufferedWriter.newLine();
            bufferedWriter.write("   <DECLARATION>");
            bufferedWriter.newLine();
            bufferedWriter.write("      <DECLGROUP>");
            bufferedWriter.newLine();
            bufferedWriter.write("         <VALUE.OBJECT>");
            bufferedWriter.newLine();
            bufferedWriter.write(cIMClass.toXml());
            bufferedWriter.write("         </VALUE.OBJECT>");
            bufferedWriter.newLine();
            bufferedWriter.write("      </DECLGROUP>");
            bufferedWriter.newLine();
            bufferedWriter.write("   </DECLARATION>");
            bufferedWriter.newLine();
            bufferedWriter.write("</CIM>");
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(I18N.loadStringFormat("CANNOT_CREATE_FILE", this.className));
            System.exit(1);
        }
    }

    void writeEndTags(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write("</CLASSES>");
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeStartTags(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write(this.startTag);
            bufferedWriter.newLine();
            bufferedWriter.write("<CLASSES>");
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            System.out.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }
}

