/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mofc;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class I18N {
    private static String resourceBundleName = "";
    public static Locale locale = Locale.getDefault();

    public static String getResourceName() {
        return resourceBundleName;
    }

    public static boolean isStringAvailable(String string) {
        return I18N.isStringAvailable(string, resourceBundleName);
    }

    public static boolean isStringAvailable(String string, String string2) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(string2, locale);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                resourceBundle = ResourceBundle.getBundle(string2, Locale.ENGLISH);
            }
            catch (MissingResourceException missingResourceException2) {
                return false;
            }
        }
        if (resourceBundle == null) {
            return false;
        }
        try {
            resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
        return true;
    }

    public static String loadString(String string) {
        return I18N.loadString(string, resourceBundleName);
    }

    public static String loadString(String string, String string2) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(string2, locale);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                resourceBundle = ResourceBundle.getBundle(string2, Locale.ENGLISH);
            }
            catch (MissingResourceException missingResourceException2) {
                System.out.println("CRITICAL ERROR: Could not load resource bundle " + string2);
                System.exit(-1);
            }
        }
        if (resourceBundle == null) {
            System.out.println("CRITICAL ERROR: Could not load resource bundle " + string2);
            System.exit(-1);
            return null;
        }
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("CRITICAL ERROR: Could not load ID " + string + " resource bundle " + string2);
            System.exit(-1);
            return null;
        }
    }

    public static String loadStringFormat(String string, Object object) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        return I18N.loadStringFormat(string, vector);
    }

    public static String loadStringFormat(String string, Object object, Object object2) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        vector.addElement(object2);
        return I18N.loadStringFormat(string, vector);
    }

    public static String loadStringFormat(String string, Vector vector) {
        return I18N.loadStringFormat(string, vector, resourceBundleName);
    }

    public static String loadStringFormat(String string, Vector vector, String string2) {
        String string3 = I18N.loadString(string, string2);
        int n = vector.size();
        if (string3 != null) {
            Object[] objectArray = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = vector.elementAt(n2);
                ++n2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        return null;
    }

    public static String loadStringFormat(String string, Object[] objectArray) {
        return I18N.loadStringFormat(string, objectArray, resourceBundleName);
    }

    public static String loadStringFormat(String string, Object[] objectArray, String string2) {
        String string3 = I18N.loadString(string, string2);
        if (string3 != null) {
            return MessageFormat.format(string3, objectArray);
        }
        return null;
    }

    public static void setResourceName(String string) {
        resourceBundleName = string;
    }
}

