/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMQualifierType;
import com.sun.wbem.cim.CIMTransportException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.XmlNameSpace;
import com.sun.wbem.client.CIMClientAPI;
import com.sun.wbem.client.CIMListener;
import com.sun.wbem.client.CIMResponse;
import com.sun.wbem.client.Errors;
import com.sun.wbem.client.XmlMessage;
import com.sun.wbem.client.XmlResponseChecker;
import com.sun.wbem.client.XmlRpcClient;
import com.sun.wbem.client.http.HttpURLConnection;
import com.sun.wbem.security.ClientSecurityContext;
import com.sun.wbem.security.HttpClientSecurity;
import com.sun.wbem.security.SecurityToken;
import com.sun.xml.parser.Parser;
import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

class CIMClientXML
extends XmlRpcClient
implements CIMClientAPI {
    private CIMNameSpace nameSpace;
    private static String HTTPPORT = "80";
    private CIMListener clientListener;
    private SecurityToken st = null;
    private HttpURLConnection conn = null;
    private static int debug = 3;
    private static boolean retryPost = true;
    private static boolean useMPost = true;
    private static final String LOCALONLY = "LocalOnly";
    private static final String DEEPINHERITANCE = "DeepInheritance";
    private static final String INCLUDEQUALIFIERS = "IncludeQualifiers";
    private static final String INCLUDECLASSORIGIN = "IncludeClassOrigin";
    private static final String PROPERTYLIST = "PropertyList";
    Resolver resolver = new Resolver();
    private boolean sendDoctype = false;

    public CIMClientXML(String string, CIMNameSpace cIMNameSpace, CIMListener cIMListener, Integer n) throws CIMException {
        Object object;
        this.nameSpace = cIMNameSpace;
        this.clientListener = cIMListener;
        try {
            object = cIMNameSpace.getHostURL();
            if (object == null) {
                object = new URL("http://" + this.nameSpace.getHost() + ":" + HTTPPORT + "/CIMOM" + string);
            }
            this.setUrl((URL)object);
        }
        catch (MalformedURLException malformedURLException) {
            CIMTransportException cIMTransportException = new CIMTransportException("NO_CIMOM", "//" + this.nameSpace.getHost() + "/CIMOM" + string);
            throw cIMTransportException;
        }
        debug = n;
        this.setCheckTypes(System.getProperty("checktypes") != null ? "true".equalsIgnoreCase(System.getProperty("checktypes")) : false);
        this.sendDoctype = System.getProperty("setdoctype") != null ? "true".equalsIgnoreCase(System.getProperty("setdoctype")) : this.sendDoctype;
        object = new XmlNameSpace();
        this.resolver.registerCatalogEntry(((XmlNameSpace)object).getPublicId(), "com/sun/wbem/client/cim20.dtd", this.getClass().getClassLoader());
        this.customizeResolver((EntityResolver)this.resolver);
    }

    public Vector associatorNames(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, String string3, String string4, String string5) throws CIMException {
        try {
            return this.getFirstResponse("AssociatorNames", this.associatorNamesDo(string, cIMNameSpace, cIMObjectPath, string2, string3, string4, string5));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "associatorNames", exception);
        }
    }

    private XmlDocument associatorNamesDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, String string3, String string4, String string5) throws CIMException, MalformedURLException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.getXmlStringBuffer(cIMNameSpace, cIMObjectPath, xmlMessage);
        stringBuffer.append(String.valueOf(xmlMessage.iParamValue("ObjectName", cIMObjectPath)) + (string2 != null ? xmlMessage.iParamValue("AssocClass", new CIMObjectPath(string2)) : "") + (string3 != null ? xmlMessage.iParamValue("ResultClass", new CIMObjectPath(string3)) : "") + (string4 != null ? xmlMessage.iParamValue("Role", string4) : "") + (string5 != null ? xmlMessage.iParamValue("ResultRole", string5) : ""));
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "Associators");
    }

    public Vector associators(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        try {
            return this.getFirstResponse("Associators", this.associatorsDo(string, cIMNameSpace, cIMObjectPath, string2, string3, string4, string5, bl, bl2, stringArray));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "associators", exception);
        }
    }

    private XmlDocument associatorsDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, String[] stringArray) throws CIMException, MalformedURLException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.getXmlStringBuffer(cIMNameSpace, cIMObjectPath, xmlMessage);
        stringBuffer.append(String.valueOf(xmlMessage.iParamValue("ObjectName", cIMObjectPath)) + (string2 != null ? xmlMessage.iParamValue("AssocClass", new CIMObjectPath(string2)) : "") + (string3 != null ? xmlMessage.iParamValue("ResultClass", new CIMObjectPath(string3)) : "") + (string5 != null ? xmlMessage.iParamValue("ResultRole", string5) : "") + (string4 != null ? xmlMessage.iParamValue("Role", string4) : "") + (bl ? xmlMessage.iParamValue(INCLUDEQUALIFIERS, bl) : "") + (bl2 ? xmlMessage.iParamValue(INCLUDECLASSORIGIN, bl) : "") + (stringArray != null ? xmlMessage.iParamValue(PROPERTYLIST, stringArray) : ""));
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "Associators");
    }

    /*
     * Unable to fully structure code
     */
    XmlDocument call(XmlDocument var1_1) throws CIMException, IOException {
        block16: {
            var2_2 = this.getUrl();
            if (var2_2 == null) {
                throw new IllegalStateException("URL is not set");
            }
            this.conn = new HttpURLConnection(var2_2, CIMClientXML.useMPost);
            this.conn.setDoOutput(true);
            this.conn.setUseCaches(false);
            this.conn.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
            this.conn.setRequestProperty("Accept", "text/xml, application/xml");
            this.conn.encapsulate(var1_1);
            if (CIMClientXML.debug == 1 || CIMClientXML.debug == 3) {
                this.conn.setDebug(true);
            }
            var3_3 = new OutputStreamWriter(this.conn.getOutputStream(), "UTF8");
            var1_1.write((Writer)var3_3);
            var3_3.flush();
            var3_3.close();
            if (this.getCheckTypes()) {
                var4_4 = new ValidatingParser();
                var4_4.setErrorHandler((ErrorHandler)Errors.instance);
            } else {
                var4_4 = new Parser();
                var4_4.setFastStandalone(true);
            }
            var5_5 = new XmlDocumentBuilder();
            var4_4.setDocumentHandler((DocumentHandler)var5_5);
            if (this.resolver == null) {
                this.resolver = new Resolver();
            }
            var4_4.setEntityResolver((EntityResolver)this.resolver);
            try {
                block17: {
                    var6_6 = Resolver.createInputSource((String)this.conn.getContentType(), (InputStream)this.conn.getInputStream(), (boolean)this.getCheckTypes(), (String)var2_2.getProtocol());
                    if (CIMClientXML.debug == 1 || CIMClientXML.debug == 3) {
                        this.dumpRequest(var1_1);
                    }
                    if (this.conn.getResponseCode() >= 400) {
                        throw new IOException();
                    }
                    try {
                        var4_4.parse(var6_6);
                        break block16;
                    }
                    catch (SAXException var7_7) {
                        if (CIMClientXML.debug <= 0) break block17;
                        var8_9 = new StringBuffer();
                        var9_10 = var6_6.getCharacterStream();
                        var10_11 = 0;
                        ** while (var10_11 >= 0)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var8_9.append((char)var10_11);
                        var10_11 = var9_10.read();
                        continue;
                    }
lbl46:
                    // 1 sources

                    System.out.println(var8_9.toString());
                    System.out.println(var7_7.getMessage());
                    if (CIMClientXML.debug >= 2) {
                        this.dumpResponse(null);
                    }
                    break block16;
                }
                throw new CIMException("XMLERROR", (Object)var7_7);
            }
            catch (IOException var7_8) {
                if (CIMClientXML.debug >= 2) {
                    this.dumpResponse(null);
                }
                if (this.conn.getResponseCode() == 401) {
                    throw new CIMException("CIM_ERR_ACCESS_DENIED");
                }
                if (CIMClientXML.retryPost && CIMClientXML.useMPost) {
                    CIMClientXML.useMPost = false;
                    return this.call(var1_1);
                }
                throw new CIMException("XMLERROR", (Object)var7_8);
            }
        }
        return var5_5.getDocument();
    }

    public synchronized void close(String string) throws CIMException {
        this.conn.disconnect();
    }

    public synchronized void createClass(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            this.getFirstResponse("CreateClass", this.createClassDo(string, cIMNameSpace, cIMObjectPath, cIMClass));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "createClass", exception);
        }
    }

    private XmlDocument createClassDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        XmlMessage xmlMessage = new XmlMessage();
        xmlMessage.setIncludeQualifiers(true);
        StringBuffer stringBuffer = this.getXmlStringBuffer(cIMNameSpace, cIMObjectPath, xmlMessage);
        stringBuffer.append(xmlMessage.iParamValue(cIMClass, "CreateClass"));
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "CreateClass");
    }

    public synchronized CIMObjectPath createInstance(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            Vector vector = this.getFirstResponse("CreateInstance", this.createInstanceDo(string, cIMNameSpace, cIMObjectPath, cIMInstance));
            return (CIMObjectPath)vector.firstElement();
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "createInstance", exception);
        }
    }

    private XmlDocument createInstanceDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.getXmlStringBuffer(cIMNameSpace, cIMObjectPath, xmlMessage);
        stringBuffer.append(xmlMessage.iParamValue(cIMInstance));
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "CreateInstance");
    }

    public synchronized void createNameSpace(String string, CIMNameSpace cIMNameSpace, CIMNameSpace cIMNameSpace2) {
    }

    public synchronized void createQualifierType(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, CIMQualifierType cIMQualifierType) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED", "createQualifierType");
    }

    public synchronized void deleteClass(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            XmlDocument xmlDocument = this.deleteClassDo(string, cIMNameSpace, cIMObjectPath);
            this.getFirstResponse("DeleteClass", xmlDocument);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CIMException("XMLERROR", "deleteClass", exception);
        }
    }

    private XmlDocument deleteClassDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) throws CIMException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.xmlAppendObjectPath(cIMNameSpace, cIMObjectPath, xmlMessage);
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "DeleteClass");
    }

    public synchronized void deleteInstance(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            XmlDocument xmlDocument = this.deleteInstanceDo(string, cIMNameSpace, cIMObjectPath);
            this.getFirstResponse("DeleteInstance", xmlDocument);
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "deleteInstance", exception);
        }
    }

    private XmlDocument deleteInstanceDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) throws CIMException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.xmlAppendObjectPath(cIMNameSpace, cIMObjectPath, xmlMessage);
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "DeleteInstance");
    }

    public synchronized void deleteNameSpace(String string, CIMNameSpace cIMNameSpace, CIMNameSpace cIMNameSpace2) {
    }

    private XmlDocument deleteQualifierDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) throws CIMException, MalformedURLException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.xmlAppendObjectPath(cIMNameSpace, cIMObjectPath, xmlMessage);
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "DeleteQualifier");
    }

    public synchronized void deleteQualifierType(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            XmlDocument xmlDocument = this.deleteQualifierDo(string, cIMNameSpace, cIMObjectPath);
            this.getFirstResponse("DeleteQualifier", xmlDocument);
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "deleteQualifierType", exception);
        }
    }

    private void dumpRequest(XmlDocument xmlDocument) throws IOException {
        System.out.println("****************************************");
        System.out.println(this.conn.getRequestHeaders());
        if (xmlDocument != null) {
            xmlDocument.write((OutputStream)System.out);
        }
        System.out.println("=-=-=-=-=-=-=-=-=-=-=-= END OF REQUEST  =-=-=-=-=-=-=-=-=-=-=-=");
    }

    private void dumpResponse(XmlDocument xmlDocument) throws IOException {
        String string = null;
        System.out.println("++++++++++++++++++++++++++++++++++++++++");
        System.out.println(this.conn.getHeaderField(0));
        int n = 1;
        while ((string = this.conn.getHeaderFieldKey(n)) != null) {
            System.out.println(String.valueOf(string) + ": " + this.conn.getHeaderField(string));
            ++n;
        }
        System.out.println("\n");
        if (xmlDocument != null) {
            xmlDocument.write((OutputStream)System.out);
        }
        System.out.println("=-=-=-=-=-=-=-=-=-=-=-= END OF RESPONSE =-=-=-=-=-=-=-=-=-=-=-=");
    }

    public synchronized Vector enumClass(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        try {
            XmlDocument xmlDocument = this.enumerateClassNamesDo(string, cIMNameSpace, cIMObjectPath, bl);
            return this.getFirstResponse("EnumerateClassNames", xmlDocument);
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "enumClass", exception);
        }
    }

    public synchronized Vector enumClass(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl, boolean bl2) throws CIMException {
        try {
            XmlDocument xmlDocument = this.enumerateClassesDo(string, cIMNameSpace, cIMObjectPath, bl, bl2, true, false);
            return this.getFirstResponse("EnumerateClasses", xmlDocument);
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "enumClass", exception);
        }
    }

    public synchronized Vector enumInstances(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        try {
            return this.getFirstResponse("EnumerateInstanceNames", this.enumerateInstanceNamesDo(string, cIMNameSpace, cIMObjectPath, bl));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "enumInstances", exception);
        }
    }

    public synchronized Vector enumInstances(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl, boolean bl2) throws CIMException {
        try {
            return this.getFirstResponse("EnumerateInstances", this.enumerateInstancesDo(string, cIMNameSpace, cIMObjectPath, bl, bl2, false, false, null));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "enumInstances", exception);
        }
    }

    public synchronized Vector enumNameSpace(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        try {
            Vector vector = this.getFirstResponse("EnumerateInstanceNames", this.enumerateInstanceNamesDo(string, cIMNameSpace, cIMObjectPath, bl));
            Vector<CIMObjectPath> vector2 = new Vector<CIMObjectPath>();
            int n = 0;
            while (n < vector.size()) {
                Vector vector3 = ((CIMObjectPath)vector.elementAt(n)).getKeys();
                int n2 = 0;
                while (n2 < vector3.size()) {
                    CIMProperty cIMProperty = (CIMProperty)vector3.elementAt(n2);
                    if ("NameSpace".equals(cIMProperty.getName())) {
                        vector2.addElement(new CIMObjectPath("", cIMProperty.getValue().getValue().toString()));
                    }
                    ++n2;
                }
                ++n;
            }
            return vector2;
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "enumNameSpace", exception);
        }
    }

    public synchronized Vector enumQualifierTypes(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) throws CIMException {
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        try {
            Enumeration enumeration = this.getFirstResponse("EnumerateQualifiers", this.enumerateQualifiersDo(string, cIMNameSpace, cIMObjectPath)).elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(new CIMObjectPath(((CIMQualifierType)enumeration.nextElement()).getName()));
            }
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "enumQualifierTypes", exception);
        }
        return vector;
    }

    public synchronized Vector enumerateClassNames(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        try {
            XmlDocument xmlDocument = this.enumerateClassNamesDo(string, cIMNameSpace, cIMObjectPath, bl);
            return this.getFirstResponse("EnumerateClassNames", xmlDocument);
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "enumerateClassNames", exception);
        }
    }

    private XmlDocument enumerateClassNamesDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.xmlAppendObjectPath(cIMNameSpace, cIMObjectPath, xmlMessage);
        if (bl) {
            stringBuffer.append(xmlMessage.iParamValue(DEEPINHERITANCE, true));
        }
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "EnumerateClassNames");
    }

    public synchronized Vector enumerateClasses(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws CIMException {
        try {
            XmlDocument xmlDocument = this.enumerateClassesDo(string, cIMNameSpace, cIMObjectPath, bl, bl2, bl3, bl4);
            return this.getFirstResponse("EnumerateClasses", xmlDocument);
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "enumerateClasses", exception);
        }
    }

    private XmlDocument enumerateClassesDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws CIMException, MalformedURLException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.xmlAppendObjectPath(cIMNameSpace, cIMObjectPath, xmlMessage);
        if (!bl2) {
            this.xmlAppendBooleanParamValue(stringBuffer, xmlMessage, LOCALONLY, false);
        }
        if (bl) {
            this.xmlAppendBooleanParamValue(stringBuffer, xmlMessage, DEEPINHERITANCE, true);
        }
        if (!bl3) {
            this.xmlAppendBooleanParamValue(stringBuffer, xmlMessage, INCLUDEQUALIFIERS, false);
        }
        if (bl4) {
            this.xmlAppendBooleanParamValue(stringBuffer, xmlMessage, INCLUDECLASSORIGIN, true);
        }
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "EnumerateClasses");
    }

    public Vector enumerateInstanceNames(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            return this.getFirstResponse("EnumerateInstanceNames", this.enumerateInstanceNamesDo(string, cIMNameSpace, cIMObjectPath, true));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "enumerateInstanceNames", exception);
        }
    }

    private XmlDocument enumerateInstanceNamesDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.xmlAppendObjectPath(cIMNameSpace, cIMObjectPath, xmlMessage);
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "EnumerateInstanceNames");
    }

    public Vector enumerateInstances(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, boolean bl4, String[] stringArray) throws CIMException {
        try {
            return this.getFirstResponse("EnumerateInstances", this.enumerateInstancesDo(string, cIMNameSpace, cIMObjectPath, bl, bl2, bl3, bl4, stringArray));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "enumerateInstances", exception);
        }
    }

    private XmlDocument enumerateInstancesDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, boolean bl4, String[] stringArray) throws CIMException, MalformedURLException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.xmlAppendObjectPath(cIMNameSpace, cIMObjectPath, xmlMessage);
        if (!bl2) {
            this.xmlAppendBooleanParamValue(stringBuffer, xmlMessage, LOCALONLY, false);
        }
        if (!bl) {
            this.xmlAppendBooleanParamValue(stringBuffer, xmlMessage, DEEPINHERITANCE, false);
        }
        if (bl3) {
            this.xmlAppendBooleanParamValue(stringBuffer, xmlMessage, INCLUDEQUALIFIERS, true);
        }
        if (bl4) {
            this.xmlAppendBooleanParamValue(stringBuffer, xmlMessage, INCLUDECLASSORIGIN, true);
        }
        this.xmlAppendStringsParamValue(stringBuffer, xmlMessage, PROPERTYLIST, stringArray);
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "EnumerateInstances");
    }

    private XmlDocument enumerateQualifiersDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) throws CIMException, MalformedURLException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.getXmlStringBuffer(cIMNameSpace, cIMObjectPath, xmlMessage);
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "EnumerateQualifiers");
    }

    public synchronized Vector execQuery(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, int n) throws CIMException {
        try {
            return this.getFirstResponse("ExecQuery", this.execQueryDo(string, cIMNameSpace, cIMObjectPath, string2, n));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "execQuery", exception);
        }
    }

    private XmlDocument execQueryDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, int n) throws CIMException, MalformedURLException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.getXmlStringBuffer(cIMNameSpace, cIMObjectPath, xmlMessage);
        stringBuffer.append(String.valueOf(xmlMessage.iParamValue("QueryLanguage", Integer.toString(n))) + xmlMessage.iParamValue("Query", string2));
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "ExecQuery");
    }

    private CIMObjectPath fixAbsObjectPath(CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) {
        String string = String.valueOf(cIMNameSpace.getNameSpace()) + "\\" + cIMObjectPath.getNameSpace();
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), (Vector)cIMObjectPath.getKeys().clone());
        cIMObjectPath2.setHost(cIMObjectPath.getHost());
        cIMObjectPath2.setNameSpace(string);
        return cIMObjectPath2;
    }

    public synchronized CIMClass getClass(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        try {
            Vector vector = this.getFirstResponse("GetClass", this.getClassDo(string, cIMNameSpace, cIMObjectPath, bl, true, false, null));
            return (CIMClass)vector.firstElement();
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CIMException("XMLERROR", "getClass", exception);
        }
    }

    public synchronized CIMClass getClass(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray) throws CIMException {
        try {
            Vector vector = this.getFirstResponse("GetClass", this.getClassDo(string, cIMNameSpace, cIMObjectPath, bl, bl2, bl3, stringArray));
            return (CIMClass)vector.firstElement();
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "getClass", exception);
        }
    }

    private XmlDocument getClassDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray) throws CIMException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.xmlAppendObjectPath(cIMNameSpace, cIMObjectPath, xmlMessage);
        if (!bl) {
            this.xmlAppendBooleanParamValue(stringBuffer, xmlMessage, LOCALONLY, false);
        }
        if (!bl2) {
            this.xmlAppendBooleanParamValue(stringBuffer, xmlMessage, INCLUDEQUALIFIERS, false);
        }
        if (bl3) {
            this.xmlAppendBooleanParamValue(stringBuffer, xmlMessage, INCLUDECLASSORIGIN, true);
        }
        this.xmlAppendStringsParamValue(stringBuffer, xmlMessage, PROPERTYLIST, stringArray);
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "GetClass");
    }

    private Vector getFirstResponse(String string, XmlDocument xmlDocument) throws MalformedURLException, CIMException, IOException {
        if (xmlDocument == null) {
            throw new CIMException("XMLERROR", "getFirstResponse");
        }
        XmlNameSpace xmlNameSpace = new XmlNameSpace();
        if (this.sendDoctype) {
            xmlDocument.setDoctype(xmlNameSpace.getPublicId(), xmlNameSpace.getSystemId().toString(), null);
        }
        XmlDocument xmlDocument2 = this.call(xmlDocument);
        if (debug >= 2) {
            this.dumpResponse(xmlDocument2);
        }
        XmlResponseChecker xmlResponseChecker = new XmlResponseChecker();
        xmlResponseChecker.checkResponse(xmlDocument, xmlDocument2);
        CIMResponse cIMResponse = new CIMResponse();
        Vector vector = cIMResponse.getResponse(xmlDocument2);
        Hashtable hashtable = (Hashtable)vector.firstElement();
        return (Vector)hashtable.get(string);
    }

    public synchronized CIMInstance getInstance(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        try {
            Vector vector = this.getFirstResponse("GetInstance", this.getInstanceDo(string, cIMNameSpace, cIMObjectPath, bl, false, false, null));
            return (CIMInstance)vector.firstElement();
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "getInstance", exception);
        }
    }

    public synchronized CIMInstance getInstance(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray) throws CIMException {
        try {
            Vector vector = this.getFirstResponse("GetInstance", this.getInstanceDo(string, cIMNameSpace, cIMObjectPath, bl, bl2, bl3, stringArray));
            return (CIMInstance)vector.firstElement();
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "getInstance", exception);
        }
    }

    private XmlDocument getInstanceDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray) throws CIMException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.xmlAppendObjectPath(cIMNameSpace, cIMObjectPath, xmlMessage);
        if (!bl) {
            this.xmlAppendBooleanParamValue(stringBuffer, xmlMessage, LOCALONLY, false);
        }
        if (bl2) {
            this.xmlAppendBooleanParamValue(stringBuffer, xmlMessage, INCLUDEQUALIFIERS, true);
        }
        if (bl3) {
            this.xmlAppendBooleanParamValue(stringBuffer, xmlMessage, INCLUDECLASSORIGIN, true);
        }
        this.xmlAppendStringsParamValue(stringBuffer, xmlMessage, PROPERTYLIST, stringArray);
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "GetInstance");
    }

    public synchronized CIMValue getProperty(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        try {
            Vector vector = this.getFirstResponse("GetProperty", this.getPropertyDo(string, cIMNameSpace, cIMObjectPath, string2));
            return (CIMValue)vector.firstElement();
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "getProperty", exception);
        }
    }

    private XmlDocument getPropertyDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2) throws CIMException, MalformedURLException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.getXmlStringBuffer(cIMNameSpace, cIMObjectPath, xmlMessage);
        stringBuffer.append(xmlMessage.iParamValue(cIMObjectPath));
        stringBuffer.append(xmlMessage.iParamValue("PropertyName", string2));
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "GetProperty");
    }

    private XmlDocument getQualifierDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) throws CIMException, MalformedURLException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.getXmlStringBuffer(cIMNameSpace, cIMObjectPath, xmlMessage);
        stringBuffer.append(xmlMessage.iParamValue("QualifierName", cIMObjectPath.getObjectName()));
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "GetQualifier");
    }

    public synchronized CIMQualifierType getQualifierType(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            Vector vector = this.getFirstResponse("GetQualifier", this.getQualifierDo(string, cIMNameSpace, cIMObjectPath));
            return (CIMQualifierType)vector.firstElement();
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "getQualifierType", exception);
        }
    }

    boolean getUseMPost() {
        return useMPost;
    }

    private StringBuffer getXmlStringBuffer(CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, XmlMessage xmlMessage) {
        CIMObjectPath cIMObjectPath2 = this.fixAbsObjectPath(cIMNameSpace, cIMObjectPath);
        return new StringBuffer(xmlMessage.localNameSpacePath(cIMObjectPath2));
    }

    public synchronized void initSecurityContext(String string, ClientSecurityContext clientSecurityContext) throws CIMException {
        HttpClientSecurity httpClientSecurity = null;
        try {
            httpClientSecurity = (HttpClientSecurity)clientSecurityContext;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", "Bad credential");
        }
        String string2 = new String(httpClientSecurity.getUserName());
        String string3 = httpClientSecurity.getUserPassword();
        Authenticator.setDefault(new HttpAuthenticator(string2, string3));
    }

    public synchronized CIMValue invokeMethod(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, Vector vector, Vector vector2) throws CIMException {
        try {
            Vector vector3 = this.getFirstResponse(string2, this.invokeMethodDo(string, cIMNameSpace, cIMObjectPath, string2, vector));
            int n = 1;
            while (n < vector3.size()) {
                vector2.addElement(vector3.elementAt(n));
                ++n;
            }
            return (CIMValue)vector3.firstElement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CIMException("XMLERROR", "invokeMethod", exception);
        }
    }

    private XmlDocument invokeMethodDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, Vector vector) throws CIMException {
        XmlMessage xmlMessage = new XmlMessage();
        CIMObjectPath cIMObjectPath2 = this.fixAbsObjectPath(cIMNameSpace, cIMObjectPath);
        StringBuffer stringBuffer = new StringBuffer(xmlMessage.localObjectPath(cIMObjectPath2));
        if (vector != null && vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                CIMValue cIMValue = (CIMValue)vector.elementAt(n);
                CIMProperty cIMProperty = new CIMProperty(xmlMessage.getCIMType(cIMValue.getType()), cIMValue);
                stringBuffer.append(xmlMessage.paramValue(cIMProperty));
                ++n;
            }
        }
        stringBuffer = new StringBuffer(xmlMessage.root(xmlMessage.message(xmlMessage.request(xmlMessage.xcall(string2, stringBuffer.toString())))));
        try {
            return xmlMessage.pcdata2Xml(stringBuffer.toString());
        }
        catch (IOException iOException) {
            throw new CIMException("XMLERROR", (Object)iOException);
        }
        catch (SAXException sAXException) {
            throw new CIMException("XMLERROR", (Object)sAXException);
        }
    }

    private XmlDocument modifyClassDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.getXmlStringBuffer(cIMNameSpace, cIMObjectPath, xmlMessage);
        stringBuffer.append(xmlMessage.iParamValue(cIMClass, "ModifyClass"));
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "ModifyClass");
    }

    private XmlDocument modifyInstanceDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.getXmlStringBuffer(cIMNameSpace, cIMObjectPath, xmlMessage);
        stringBuffer.append(xmlMessage.iParamValue(cIMObjectPath, cIMInstance));
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "ModifyInstance");
    }

    public Vector referenceNames(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, String string3) throws CIMException {
        try {
            return this.getFirstResponse("ReferenceNames", this.referenceNamesDo(string, cIMNameSpace, cIMObjectPath, string2, string3));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "referenceNames", exception);
        }
    }

    private XmlDocument referenceNamesDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, String string3) throws CIMException, MalformedURLException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.getXmlStringBuffer(cIMNameSpace, cIMObjectPath, xmlMessage);
        stringBuffer.append(String.valueOf(xmlMessage.iParamValue("ObjectName", cIMObjectPath)) + (string2 != null ? xmlMessage.iParamValue("ResultClass", new CIMObjectPath(string2)) : "") + (string3 != null ? xmlMessage.iParamValue("Role", string3) : ""));
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "ReferenceNames");
    }

    public Vector references(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        try {
            return this.getFirstResponse("References", this.referencesDo(string, cIMNameSpace, cIMObjectPath, string2, string3, bl, bl2, stringArray));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "references", exception);
        }
    }

    private XmlDocument referencesDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws CIMException, MalformedURLException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.getXmlStringBuffer(cIMNameSpace, cIMObjectPath, xmlMessage);
        stringBuffer.append(String.valueOf(xmlMessage.iParamValue("ObjectName", cIMObjectPath)) + (string2 != null ? xmlMessage.iParamValue("ResultClass", new CIMObjectPath(string2)) : "") + (string3 != null ? xmlMessage.iParamValue("Role", string3) : "") + (bl ? xmlMessage.iParamValue(INCLUDEQUALIFIERS, bl) : "") + (bl2 ? xmlMessage.iParamValue(INCLUDECLASSORIGIN, bl) : "") + (stringArray != null ? xmlMessage.iParamValue(PROPERTYLIST, stringArray) : ""));
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "References");
    }

    public synchronized void setClass(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            this.getFirstResponse("ModifyClass", this.modifyClassDo(string, cIMNameSpace, cIMObjectPath, cIMClass));
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "setClass", exception);
        }
    }

    public synchronized void setInstance(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            this.getFirstResponse("ModifyInstance", this.modifyInstanceDo(string, cIMNameSpace, cIMObjectPath, cIMInstance));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "setInstance", exception);
        }
    }

    public synchronized void setProperty(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, CIMValue cIMValue) throws CIMException {
        try {
            this.getFirstResponse("SetProperty", this.setPropertyDo(string, cIMNameSpace, cIMObjectPath, string2, cIMValue));
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "setProperty", exception);
        }
    }

    private XmlDocument setPropertyDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, String string2, CIMValue cIMValue) throws CIMException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.getXmlStringBuffer(cIMNameSpace, cIMObjectPath, xmlMessage);
        stringBuffer.append(xmlMessage.iParamValue(cIMObjectPath));
        stringBuffer.append(xmlMessage.iParamValue("PropertyName", string2));
        stringBuffer.append(xmlMessage.iParamValue(cIMValue));
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "SetProperty");
    }

    private XmlDocument setQualifierDo(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, CIMQualifierType cIMQualifierType) throws CIMException, MalformedURLException {
        XmlMessage xmlMessage = new XmlMessage();
        StringBuffer stringBuffer = this.getXmlStringBuffer(cIMNameSpace, cIMObjectPath, xmlMessage);
        stringBuffer.append(xmlMessage.iParamValue(cIMQualifierType));
        return this.xmlMsg2xmlDoc(xmlMessage, stringBuffer, "SetQualifier");
    }

    public synchronized void setQualifierType(String string, CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, CIMQualifierType cIMQualifierType) throws CIMException {
        try {
            this.getFirstResponse("SetQualifier", this.setQualifierDo(string, cIMNameSpace, cIMObjectPath, cIMQualifierType));
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", "setQualifierType", exception);
        }
    }

    void setUseMPost(boolean bl) {
        useMPost = bl;
        retryPost = false;
    }

    private void xmlAppendBooleanParamValue(StringBuffer stringBuffer, XmlMessage xmlMessage, String string, boolean bl) {
        stringBuffer.append(xmlMessage.iParamValue(string, bl));
    }

    private StringBuffer xmlAppendObjectPath(CIMNameSpace cIMNameSpace, CIMObjectPath cIMObjectPath, XmlMessage xmlMessage) {
        StringBuffer stringBuffer = this.getXmlStringBuffer(cIMNameSpace, cIMObjectPath, xmlMessage);
        stringBuffer.append(xmlMessage.iParamValue(cIMObjectPath));
        return stringBuffer;
    }

    private void xmlAppendStringsParamValue(StringBuffer stringBuffer, XmlMessage xmlMessage, String string, String[] stringArray) {
        if (stringArray != null) {
            stringBuffer.append(xmlMessage.iParamValue(string, stringArray));
        }
    }

    private XmlDocument xmlMsg2xmlDoc(XmlMessage xmlMessage, StringBuffer stringBuffer, String string) throws CIMException {
        StringBuffer stringBuffer2 = new StringBuffer(xmlMessage.root(xmlMessage.message(xmlMessage.request(xmlMessage.call(string, stringBuffer.toString())))));
        try {
            return xmlMessage.pcdata2Xml(stringBuffer2.toString());
        }
        catch (IOException iOException) {
            throw new CIMException("XMLERROR", (Object)iOException);
        }
        catch (SAXException sAXException) {
            throw new CIMException("XMLERROR", (Object)sAXException);
        }
    }

    private static class HttpAuthenticator
    extends Authenticator {
        private String username;
        private char[] password;

        HttpAuthenticator(String string, String string2) {
            this.username = string;
            this.password = string2.toCharArray();
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

