/*
 * Decompiled with CFR 0.152.
 */
package com.sun.audiocontrol.SDtAudioControl;

import com.sun.audiocontrol.SDtAudioControl.CheckableItem;
import com.sun.audiocontrol.SDtAudioControl.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class CheckList
extends JList {
    public CheckList(CheckableItem[] items) {
        this._init(items);
    }

    private void _init(CheckableItem[] items) {
        this.setListData(items);
        this.setCellRenderer(new CheckListRenderer());
        this.setSelectionMode(0);
        this.setBorder(new EmptyBorder(0, 4, 0, 0));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Debug.println("CheckList mouseClicked event");
                CheckList list = (CheckList)e.getSource();
                int index = list.locationToIndex(e.getPoint());
                CheckableItem item = (CheckableItem)list.getModel().getElementAt(index);
                item.setSelected(item.isEnabled() ? item.isSelected() ^ true : true);
                Rectangle rect = list.getCellBounds(index, index);
                list.repaint(rect);
            }
        });
    }

    class CheckListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        public CheckListRenderer() {
            this.setBackground(UIManager.getColor("List.textBackground"));
            this.setForeground(UIManager.getColor("List.textForeground"));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            Dimension mydim = new Dimension();
            mydim = this.getPreferredSize();
            mydim.height = 17;
            this.setPreferredSize(mydim);
            this.setEnabled(((CheckableItem)value).isEnabled());
            this.setSelected(((CheckableItem)value).isSelected());
            this.setFont(list.getFont());
            this.setText(value.toString());
            return this;
        }
    }
}

