/*
 * Decompiled with CFR 0.152.
 */
package com.sun.audiocontrol.SDtAudioControl;

import com.sun.audiocontrol.SDtAudioControl.AudioSlider;
import com.sun.audiocontrol.SDtAudioControl.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class AudioSliderPanel
extends JPanel {
    AudioSlider slider;
    JLabel valueLabel;
    JProgressBar meter;

    public AudioSliderPanel(String title, int min, int max, int tick, int val) {
        this._init(title, min, max, tick, val);
    }

    private void _init(String title, int min, int max, int tick, int val) {
        Font bold10 = new Font("dialog.bold", 0, 10);
        Font bold12 = new Font("dialog.bold", 0, 12);
        Font plain10 = new Font("Dialog", 0, 10);
        Font plain12 = new Font("Dialog", 0, 12);
        JLabel panelTitle = new JLabel(title);
        panelTitle.setFont(bold12);
        FontMetrics panelTitleFM = ((Component)this).getFontMetrics(panelTitle.getFont());
        int panelTitleSW = panelTitleFM.stringWidth(panelTitle.getText());
        Insets panelTitleInsets = panelTitle.getInsets();
        int panelTitleWidth = panelTitleInsets.right + panelTitleSW + panelTitleInsets.left;
        JPanel innerPanel = new JPanel();
        this.slider = new AudioSlider(1, min, max, val);
        this.valueLabel = new JLabel();
        this.setLayout(new BoxLayout(this, 1));
        innerPanel.setLayout(new BoxLayout(innerPanel, 0));
        Debug.setBorder(this, Color.red);
        Debug.setBorder(panelTitle, Color.blue);
        Debug.setBorder(innerPanel, Color.red);
        Debug.setBorder(this.slider, Color.blue);
        Debug.setBorder(this.valueLabel, Color.blue);
        panelTitle.setLabelFor(this.slider);
        panelTitle.setHorizontalAlignment(0);
        panelTitle.setAlignmentX(0.5f);
        panelTitle.setForeground(Color.black);
        innerPanel.setAlignmentX(0.5f);
        this.valueLabel.setFont(plain12);
        FontMetrics valueLabelFM = ((Component)this).getFontMetrics(this.valueLabel.getFont());
        int valueLabelSW = valueLabelFM.stringWidth("100");
        int valueLabelFH = valueLabelFM.getHeight();
        Insets valueLabelInsets = this.valueLabel.getInsets();
        Dimension valueLabelSize = new Dimension(valueLabelInsets.left + valueLabelSW + valueLabelInsets.right, valueLabelInsets.top + valueLabelFH + valueLabelInsets.bottom);
        this.valueLabel.setMinimumSize(valueLabelSize);
        this.valueLabel.setPreferredSize(this.valueLabel.getMinimumSize());
        this.valueLabel.setMaximumSize(this.valueLabel.getMinimumSize());
        this.valueLabel.setForeground(Color.black);
        this.slider.setMajorTickSpacing(tick);
        this.slider.setPaintTicks(true);
        Dimension sliderSize = new Dimension(35, 125);
        this.slider.setMinimumSize(sliderSize);
        this.slider.setPreferredSize(sliderSize);
        this.slider.setMaximumSize(sliderSize);
        this.slider.setValueLabel(this.valueLabel);
        this.add(panelTitle);
        int isize = sliderSize.width + valueLabelSize.width;
        innerPanel.add(Box.createHorizontalStrut(isize > panelTitleWidth ? panelTitleWidth / 2 : isize / 2));
        innerPanel.add(this.slider);
        innerPanel.add(this.valueLabel);
        this.add(innerPanel);
    }

    public AudioSlider getSlider() {
        return this.slider;
    }

    public JLabel getValueLabel() {
        return this.slider.getValueLabel();
    }
}

