/*
 * Decompiled with CFR 0.152.
 */
package opencard.tests;

import java.io.PrintStream;
import opencard.core.service.CardServiceException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.OpenCardPropertyLoadingException;
import opencard.tests.UseCase;

public class StartOpenCard
extends UseCase {
    private boolean d_finish = false;
    int d_loop = 1;

    static {
        UseCase.d_name = "start OCF";
        UseCase.d_description = "startup and initialize the OpenCard Framework";
    }

    public StartOpenCard(PrintStream printStream, int n) {
        super(printStream);
        this.d_loop = n;
    }

    public void execute() {
        PrintStream printStream = this.getPrintStream();
        int n = 0;
        while (n < this.d_loop) {
            printStream.println("loop: " + n + " th run");
            try {
                SmartCard.start();
                if (SmartCard.isStarted()) {
                    printStream.println("configuration was done.");
                }
                printStream.println("OpenCard is " + (SmartCard.isStarted() ? "" : "NOT") + " started!");
                printStream.println("try again anyway");
                SmartCard.start();
                SmartCard.shutdown();
            }
            catch (OpenCardPropertyLoadingException openCardPropertyLoadingException) {
                printStream.println("OpenCardPropertyLoadingException: ");
                printStream.println(openCardPropertyLoadingException.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                printStream.println("OpenCardClassNotFoundException: ");
                printStream.println(classNotFoundException.getMessage());
            }
            catch (CardServiceException cardServiceException) {
                printStream.println("OpenCardLibraryLoadingException: ");
                printStream.println(cardServiceException.getMessage());
            }
            catch (CardTerminalException cardTerminalException) {
                printStream.println("OpenCardInitializationException: ");
                printStream.println(cardTerminalException.getMessage());
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        PrintStream printStream = System.out;
        int n = 1;
        if (stringArray.length >= 1) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals("-loop") && n2 + 1 < stringArray.length) {
                    printStream.println("loop: " + stringArray[n2 + 1]);
                    try {
                        n = Integer.parseInt(stringArray[n2 + 1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        printStream.println("argument " + stringArray[n2 + 1] + " is no parsable integer");
                    }
                }
                ++n2;
            }
        }
        StartOpenCard startOpenCard = new StartOpenCard(printStream, n);
        UseCase.runUseCase(startOpenCard);
    }
}

