/*
 * Decompiled with CFR 0.152.
 */
package opencard.tests;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import opencard.core.service.CardServiceException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.Slot;
import opencard.core.util.OpenCardPropertyLoadingException;
import opencard.tests.UseCase;

public class GetTerminalInfos
extends UseCase {
    static {
        UseCase.d_name = "get terminal information";
        UseCase.d_description = "get information about the terminals installed and their slots";
    }

    public GetTerminalInfos(PrintStream printStream) {
        super(printStream);
    }

    public void execute() {
        PrintStream printStream = this.getPrintStream();
        try {
            SmartCard.start();
            CardTerminalRegistry cardTerminalRegistry = CardTerminalRegistry.getRegistry();
            Enumeration enumeration = cardTerminalRegistry.getCardTerminals();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                CardTerminal cardTerminal = (CardTerminal)enumeration.nextElement();
                this.printTerminalInfos(cardTerminal, printStream);
                ++n;
            }
            printStream.println("there " + (n > 1 ? "are" : "is") + " " + n + " terminal" + (n > 1 ? "s" : "") + " installed!");
            SmartCard.shutdown();
        }
        catch (OpenCardPropertyLoadingException openCardPropertyLoadingException) {
            printStream.println("OpenCardPropertyLoadingException: ");
            printStream.println(openCardPropertyLoadingException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            printStream.println("OpenCardClassNotFoundException: ");
            printStream.println(classNotFoundException.getMessage());
        }
        catch (CardTerminalException cardTerminalException) {
            printStream.println("CardTerminalException: ");
            printStream.println(cardTerminalException.getMessage());
        }
        catch (CardServiceException cardServiceException) {
            printStream.println("CardServiceException: ");
            printStream.println(cardServiceException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        PrintStream printStream = System.out;
        GetTerminalInfos getTerminalInfos = new GetTerminalInfos(printStream);
        UseCase.runUseCase(getTerminalInfos);
    }

    public void printSlotInfos(Slot slot, PrintStream printStream) {
        try {
            printStream.println("Slot info: " + slot);
            printStream.println("slot ID: " + slot.getSlotID());
            printStream.println("card present: " + (slot.isCardPresent() ? "yes" : "no"));
        }
        catch (CardTerminalException cardTerminalException) {
            printStream.println("CardTerminalException: ");
            printStream.println(cardTerminalException.getMessage());
        }
    }

    public void printTerminalInfos(CardTerminal cardTerminal, PrintStream printStream) {
        printStream.println("Address: " + cardTerminal.getAddress() + "\n" + "Name:    " + cardTerminal.getName() + "\n" + "Type:    " + cardTerminal.getType() + "\n");
        printStream.println("terminal.features (): ");
        Properties properties = cardTerminal.features();
        if (properties != null) {
            properties.list(printStream);
        }
        Slot[] slotArray = cardTerminal.slots();
        printStream.println("\nslot infos: ");
        printStream.println("there " + (slotArray.length > 1 ? "are" : "is") + " " + slotArray.length + " slot" + (slotArray.length > 1 ? "s" : "") + " present in this terminal!");
        int n = 0;
        while (n < slotArray.length) {
            printStream.println("slot channel available: " + (cardTerminal.isSlotChannelAvailable(n) ? "yes" : "no"));
            this.printSlotInfos(slotArray[n], printStream);
            ++n;
        }
    }
}

