/*
 * Decompiled with CFR 0.152.
 */
package opencard.tests;

import java.io.PrintStream;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.tests.UseCase;

public class GetSmartCard
extends UseCase
implements CTListener {
    private static Object monitor;
    private int d_loop = 1;
    private int d_index = 1;

    static {
        UseCase.d_name = "get a smart card object";
        UseCase.d_description = "get a smart card object after a 'cardInserted' event";
    }

    public GetSmartCard(PrintStream printStream, int n) {
        super(printStream);
        monitor = "Synchronization Monitor";
        this.d_loop = n;
    }

    public void cardInserted(CardTerminalEvent cardTerminalEvent) {
        PrintStream printStream = this.getPrintStream();
        printStream.println("card inserted");
        try {
            SmartCard smartCard = SmartCard.getSmartCard(cardTerminalEvent);
            if (smartCard != null) {
                printStream.println(" got a SmartCard " + smartCard + smartCard.getCardID());
            } else {
                printStream.println(" did NOT get a SmartCard");
            }
            if (this.d_index == this.d_loop) {
                Object object = monitor;
                synchronized (object) {
                    monitor.notify();
                }
            }
            ++this.d_index;
        }
        catch (CardTerminalException cardTerminalException) {
            cardTerminalException.printStackTrace(printStream);
        }
    }

    public void cardRemoved(CardTerminalEvent cardTerminalEvent) {
        this.getPrintStream().println("card removed");
    }

    public void execute() {
        PrintStream printStream = this.getPrintStream();
        try {
            SmartCard.start();
            CardTerminalRegistry.getRegistry().addCTListener(this);
            Object object = monitor;
            synchronized (object) {
                try {
                    monitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    printStream.println("waiting was interrupted for some reason");
                }
            }
            SmartCard.shutdown();
        }
        catch (Exception exception) {
            exception.printStackTrace(printStream);
        }
    }

    public static void main(String[] stringArray) {
        PrintStream printStream = System.out;
        int n = 1;
        if (stringArray.length >= 1) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals("-loop") && n2 + 1 < stringArray.length) {
                    printStream.println("loop: " + stringArray[n2 + 1]);
                    try {
                        n = Integer.parseInt(stringArray[n2 + 1]);
                        if (n <= 0) {
                            printStream.println("sorry, you cannot loop a negative or zero number of times!");
                            printStream.println("we set this to 1 as default");
                            n = 1;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        printStream.println("argument " + stringArray[n2 + 1] + " is no parsable integer");
                    }
                }
                ++n2;
            }
        }
        GetSmartCard getSmartCard = new GetSmartCard(printStream, n);
        UseCase.runUseCase(getSmartCard);
    }
}

