/*
 * Decompiled with CFR 0.152.
 */
package opencard.tests;

import java.io.PrintStream;
import opencard.core.service.CardRequest;
import opencard.core.service.CardServiceException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.OpenCardPropertyLoadingException;
import opencard.tests.UseCase;

public class GetAnyCard
extends UseCase {
    static {
        UseCase.d_name = "get any card";
        UseCase.d_description = "wait until a card is being inserted into one of the slots of one of the terminals";
    }

    public GetAnyCard(PrintStream printStream) {
        super(printStream);
    }

    public void execute() {
        try {
            SmartCard.start();
            CardRequest cardRequest = new CardRequest();
            cardRequest.setWaitBehavior(1);
            SmartCard smartCard = SmartCard.waitForCard(cardRequest);
            if (smartCard != null) {
                this.d_ps.println("got a SmartCard object!");
            } else {
                this.d_ps.println("did not get a SmartCard object!");
            }
            SmartCard.shutdown();
        }
        catch (OpenCardPropertyLoadingException openCardPropertyLoadingException) {
            this.d_ps.println("OpenCardPropertyLoadingException: ");
            this.d_ps.println(openCardPropertyLoadingException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.d_ps.println("ClassNotFoundException: ");
            this.d_ps.println(classNotFoundException.getMessage());
        }
        catch (CardServiceException cardServiceException) {
            this.d_ps.println("CardterminalException: ");
            this.d_ps.println(cardServiceException.getMessage());
        }
        catch (CardTerminalException cardTerminalException) {
            this.d_ps.println("CardServieException: ");
            this.d_ps.println(cardTerminalException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        PrintStream printStream = System.out;
        GetAnyCard getAnyCard = new GetAnyCard(printStream);
        UseCase.runUseCase(getAnyCard);
    }
}

