/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import java.util.Enumeration;
import java.util.Hashtable;
import opencard.core.OpenCardRuntimeException;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.CardIDFilter;
import opencard.core.service.CardRequest;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceHashtable;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.PrimaryCardServiceFactory;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.Slot;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.Tracer;

public final class CardServiceRegistry
implements CTListener {
    private Tracer itracer = new Tracer((Object)this, class$opencard$core$service$CardServiceRegistry != null ? class$opencard$core$service$CardServiceRegistry : (class$opencard$core$service$CardServiceRegistry = CardServiceRegistry.class$("opencard.core.service.CardServiceRegistry")));
    private static Tracer ctracer = new Tracer(class$opencard$core$service$CardServiceRegistry != null ? class$opencard$core$service$CardServiceRegistry : (class$opencard$core$service$CardServiceRegistry = CardServiceRegistry.class$("opencard.core.service.CardServiceRegistry")));
    private static final CardServiceRegistry registry = new CardServiceRegistry();
    private CardServiceHashtable factories = new CardServiceHashtable();
    private Hashtable sc2scheduler = new Hashtable();
    private Hashtable scheduler2sc = new Hashtable();
    private Hashtable aliveSlots = new Hashtable();
    private int waitingForCard = 0;
    private boolean eventRcvd = false;
    private Object waitForCardMonitor = "waitForCardMonitor";
    private Object getSmartCardMonitor = "getSmartCardMonitor";
    private CardTerminalEvent currentCTEvent = null;
    static /* synthetic */ Class class$opencard$core$service$CardServiceRegistry;

    private CardServiceRegistry() {
        ctracer.debug("<init>", "instantiating");
        CardTerminalRegistry.getRegistry().addCTListener(this);
        try {
            this.scanCardTerminals();
        }
        catch (CardTerminalException cardTerminalException) {
            ctracer.error("<init>", cardTerminalException.toString());
        }
    }

    public void add(CardServiceFactory cardServiceFactory) {
        this.itracer.debug("add", "(" + cardServiceFactory + ")");
        if (!this.factories.containsKey(cardServiceFactory)) {
            CardServiceHashtable cardServiceHashtable = this.factories;
            synchronized (cardServiceHashtable) {
                this.factories.put(cardServiceFactory, cardServiceFactory);
            }
            this.itracer.info("add", "added " + (cardServiceFactory instanceof PrimaryCardServiceFactory ? "primary" : "secondary") + " factory " + cardServiceFactory);
        }
    }

    public void addToEnd(CardServiceFactory cardServiceFactory) {
        this.itracer.debug("addToEnd", "(" + cardServiceFactory + ")");
        this.factories.putAtEnd(cardServiceFactory, cardServiceFactory);
        this.itracer.info("addToEnd", "added " + (cardServiceFactory instanceof PrimaryCardServiceFactory ? "primary" : "secondary") + " factory " + cardServiceFactory);
    }

    private CardServiceScheduler allocateCardServiceScheduler(Slot slot, SlotChannel slotChannel) throws CardTerminalException {
        Object object;
        CardServiceScheduler cardServiceScheduler = null;
        if (slotChannel == null) {
            slotChannel = slot.getCardTerminal().openSlotChannel(slot);
            object = this.aliveSlots;
            synchronized (object) {
                this.aliveSlots.put(slot, slotChannel);
            }
        }
        if ((cardServiceScheduler = (CardServiceScheduler)this.sc2scheduler.get(slotChannel)) == null) {
            this.itracer.debug("allocateCardServiceScheduler", "instantiating CardServiceScheduler");
            cardServiceScheduler = new CardServiceScheduler(slotChannel);
            object = this.sc2scheduler;
            synchronized (object) {
                this.sc2scheduler.put(slotChannel, cardServiceScheduler);
                this.scheduler2sc.put(cardServiceScheduler, slotChannel);
            }
            object = this.factories.elements();
            while (object.hasMoreElements()) {
                CardServiceFactory cardServiceFactory = (CardServiceFactory)object.nextElement();
                if (!(cardServiceFactory instanceof PrimaryCardServiceFactory)) continue;
                this.itracer.debug("allocateCardServiceScheduler", "setting up card via PrimaryCardServiceFactory" + cardServiceFactory);
                ((PrimaryCardServiceFactory)((Object)cardServiceFactory)).setupSmartCard(slotChannel);
                break;
            }
        }
        return cardServiceScheduler;
    }

    public void cardInserted(CardTerminalEvent cardTerminalEvent) {
        Object object = this.waitForCardMonitor;
        synchronized (object) {
            this.itracer.debug("cardInserted", "ctEvent " + cardTerminalEvent);
            Slot slot = cardTerminalEvent.getSlot();
            Hashtable hashtable = this.aliveSlots;
            synchronized (hashtable) {
                this.aliveSlots.put(slot, slot);
            }
            this.eventRcvd = true;
            if (this.waitingForCard > 0) {
                this.itracer.debug("cardInserted", "notifying waiting for Cards");
                this.currentCTEvent = cardTerminalEvent;
                this.waitForCardMonitor.notifyAll();
            }
        }
    }

    public void cardRemoved(CardTerminalEvent cardTerminalEvent) {
        Object object = this.waitForCardMonitor;
        synchronized (object) {
            this.itracer.debug("cardRemoved", "(" + cardTerminalEvent + ")");
            CardTerminal cardTerminal = (CardTerminal)cardTerminalEvent.getSource();
            Slot slot = cardTerminalEvent.getSlot();
            Object v = this.aliveSlots.get(slot);
            if (v != null && v instanceof SlotChannel) {
                SlotChannel slotChannel = (SlotChannel)v;
                CardServiceScheduler cardServiceScheduler = (CardServiceScheduler)this.sc2scheduler.get(slotChannel);
                this.dropChannelAndScheduler(slotChannel, cardServiceScheduler);
            } else {
                this.aliveSlots.remove(slot);
            }
            this.eventRcvd = false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private boolean doWait(CardRequest cardRequest) {
        boolean bl = false;
        ++this.waitingForCard;
        this.itracer.debug("doWait", "waiting for cardInserted() event");
        try {
            try {
                if (cardRequest != null) {
                    if (cardRequest.isTimeoutSet()) {
                        this.waitForCardMonitor.wait(cardRequest.getTimeout() * 1000);
                    } else {
                        this.waitForCardMonitor.wait();
                    }
                } else {
                    this.waitForCardMonitor.wait(1000L);
                }
                bl = true;
            }
            catch (InterruptedException interruptedException) {
                this.itracer.error("doWait", interruptedException.toString());
            }
            Object var4_4 = null;
            --this.waitingForCard;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            --this.waitingForCard;
            throw throwable;
        }
        return bl;
    }

    private void dropChannelAndScheduler(SlotChannel slotChannel, CardServiceScheduler cardServiceScheduler) {
        Object object = this.sc2scheduler;
        synchronized (object) {
            if (slotChannel != null) {
                this.itracer.debug("dropChannelAndScheduler", "removing from cache " + slotChannel);
                this.sc2scheduler.remove(slotChannel);
            }
            if (cardServiceScheduler != null) {
                this.itracer.debug("dropChannelAndScheduler", "removing from cache " + cardServiceScheduler);
                this.scheduler2sc.remove(cardServiceScheduler);
            }
        }
        if (slotChannel != null) {
            object = slotChannel.getSlot();
            boolean bl = true;
            try {
                bl = ((Slot)object).isCardPresent();
            }
            catch (CardTerminalException cardTerminalException) {
                this.itracer.error("dropChannelAndScheduler", cardTerminalException.toString());
                bl = false;
            }
            if (!bl) {
                this.itracer.debug("dropChannelAndScheduler", "dropping Slot " + object);
                this.aliveSlots.remove(object);
            } else {
                this.itracer.debug("dropChannelAndScheduler", "dropping SlotChannel only " + slotChannel);
                this.aliveSlots.put(object, object);
            }
        }
    }

    public CardServiceFactory find(CardID cardID) {
        Enumeration enumeration = this.factories.elements();
        while (enumeration.hasMoreElements()) {
            CardServiceFactory cardServiceFactory = (CardServiceFactory)enumeration.nextElement();
            if (!cardServiceFactory.knows(cardID)) continue;
            return cardServiceFactory;
        }
        return null;
    }

    private Slot findAliveSlot(CardRequest cardRequest, CardID cardID) throws CardTerminalException {
        Slot slot = null;
        this.itracer.debug("waitForCard", "checking previously unused Slots");
        Hashtable hashtable = this.aliveSlots;
        synchronized (hashtable) {
            Enumeration enumeration = this.aliveSlots.elements();
            while (enumeration.hasMoreElements()) {
                CardTerminal cardTerminal;
                Object v = enumeration.nextElement();
                if (v instanceof SlotChannel) continue;
                slot = (Slot)v;
                cardID = slot.getCardID();
                if (this.isCardRequestSatisfied(cardRequest, cardID, cardTerminal = slot.getCardTerminal())) break;
                this.itracer.debug("waitForCard", "slot " + slot + " does not satisfy req");
                slot = null;
            }
        }
        return slot;
    }

    private SlotChannel findSlotChannel(CardRequest cardRequest, CardID cardID) throws CardTerminalException {
        SlotChannel slotChannel = null;
        this.itracer.debug("waitForCard", "checking previously allocated SlotChannel");
        Enumeration enumeration = null;
        Hashtable hashtable = this.sc2scheduler;
        synchronized (hashtable) {
            enumeration = this.sc2scheduler.keys();
            while (enumeration.hasMoreElements()) {
                CardTerminal cardTerminal;
                slotChannel = (SlotChannel)enumeration.nextElement();
                cardID = slotChannel.getCardID();
                if (!this.isCardRequestSatisfied(cardRequest, cardID, cardTerminal = slotChannel.getCardTerminal())) {
                    slotChannel = null;
                    cardID = null;
                    continue;
                }
                this.itracer.debug("waitForCard", "using previously allocated SlotChannel" + slotChannel);
                break;
            }
        }
        return slotChannel;
    }

    protected Class getCardServiceClassFor(Class clazz, CardID cardID) {
        this.itracer.debug("getCardServiceClass", "for " + clazz + " and " + cardID);
        Enumeration enumeration = this.factories.elements();
        while (enumeration.hasMoreElements()) {
            CardServiceFactory cardServiceFactory = (CardServiceFactory)enumeration.nextElement();
            this.itracer.debug("getCardServiceClass", "checking " + cardServiceFactory);
            if (!cardServiceFactory.knows(cardID)) continue;
            Class clazz2 = cardServiceFactory.getCardServiceClassFor(clazz, cardID);
            this.itracer.debug("getCardServiceInstance", "factory " + cardServiceFactory + " produced " + clazz2);
            if (clazz2 == null) continue;
            return clazz2;
        }
        this.itracer.info("getCardServiceClass", "no CardService for " + clazz);
        return null;
    }

    public final Enumeration getCardServiceFactories() {
        return this.factories.elements();
    }

    protected CardService getCardServiceInstance(Class clazz, CardID cardID, CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws ClassNotFoundException {
        this.itracer.debug("getCardServiceInstance", "for " + clazz + " from " + smartCard);
        Enumeration enumeration = this.factories.elements();
        while (enumeration.hasMoreElements()) {
            CardServiceFactory cardServiceFactory = (CardServiceFactory)enumeration.nextElement();
            this.itracer.debug("getCardServiceInstance", "checking " + cardServiceFactory);
            if (!cardServiceFactory.knows(cardID)) continue;
            try {
                CardService cardService = cardServiceFactory.getCardServiceInstance(clazz, cardID, cardServiceScheduler, smartCard, bl);
                this.itracer.debug("getCardServiceInstance", "factory " + cardServiceFactory + " produced " + cardService);
                if (cardService == null) continue;
                return cardService;
            }
            catch (CardServiceException cardServiceException) {
                this.itracer.info("getCardServiceInstance", "factory " + cardServiceFactory + " failed: " + cardServiceException);
            }
        }
        this.itracer.info("getCardServiceInstance", "no CardService for " + clazz + " found");
        throw new ClassNotFoundException("CardService implementing " + clazz.toString());
    }

    public static CardServiceRegistry getRegistry() {
        return registry;
    }

    protected SmartCard getSmartCard(CardTerminalEvent cardTerminalEvent) throws CardTerminalException {
        return this.getSmartCard(cardTerminalEvent, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SmartCard getSmartCard(CardTerminalEvent cardTerminalEvent, CardRequest cardRequest) throws CardTerminalException {
        CardServiceScheduler cardServiceScheduler = null;
        CardID cardID = null;
        Slot slot = null;
        SlotChannel slotChannel = null;
        this.itracer.debug("getSmartCard", "CTEvent " + cardTerminalEvent);
        Object object = this.waitForCardMonitor;
        synchronized (object) {
            if (!this.eventRcvd && !this.doWait(cardRequest)) {
                return null;
            }
            if (!this.eventRcvd) {
                this.itracer.debug("getSmartCard", "timed out");
                return null;
            }
        }
        object = this.getSmartCardMonitor;
        synchronized (object) {
            CardTerminal cardTerminal = (CardTerminal)cardTerminalEvent.getSource();
            slot = cardTerminalEvent.getSlot();
            cardID = slot.getCardID();
            if (cardRequest != null && !this.isCardRequestSatisfied(cardRequest, cardID, cardTerminal)) {
                this.itracer.info("getSmartCard", "CardRequest " + cardRequest + " cannot be satisfied with " + cardID);
                return null;
            }
            Object v = this.aliveSlots.get(slot);
            if (v != null && v instanceof SlotChannel) {
                this.itracer.debug("getSmartCard", "secondary getSmartCard(); don't need to open SlotChannel again");
                slotChannel = (SlotChannel)v;
            }
            cardServiceScheduler = this.allocateCardServiceScheduler(slot, slotChannel);
        }
        this.itracer.debug("getSmartCard", "using CardServiceScheduler " + cardServiceScheduler);
        return cardServiceScheduler.createSmartCard(cardID);
    }

    private boolean isCardRequestSatisfied(CardRequest cardRequest, CardID cardID, CardTerminal cardTerminal) {
        CardIDFilter cardIDFilter = cardRequest.getFilter();
        if (cardIDFilter != null && !cardIDFilter.isCandidate(cardID)) {
            this.itracer.info("isCardRequestSatisfied", "filtered out by " + cardIDFilter);
            return false;
        }
        if (cardRequest.getCardTerminal() != null && cardRequest.getCardTerminal() != cardTerminal) {
            this.itracer.info("isCardRequestSatisfied", "requested terminal " + cardRequest.getCardTerminal() + " does not match receiving terminal  " + cardTerminal);
            return false;
        }
        if (cardRequest.getCardServiceClass() != null && this.getCardServiceClassFor(cardRequest.getCardServiceClass(), cardID) == null) {
            this.itracer.info("isCardRequestSatisfied", "requested CardService class " + cardRequest.getCardServiceClass() + " not supported for  " + cardID);
            return false;
        }
        return true;
    }

    protected void releaseScheduler(CardServiceScheduler cardServiceScheduler) {
        this.itracer.debug("releaseScheduler", "releasing scheduler " + cardServiceScheduler);
        SlotChannel slotChannel = null;
        Hashtable hashtable = this.sc2scheduler;
        synchronized (hashtable) {
            if (this.scheduler2sc.containsKey(cardServiceScheduler)) {
                slotChannel = (SlotChannel)this.scheduler2sc.get(cardServiceScheduler);
                this.itracer.debug("releaseScheduler", "channel " + slotChannel);
            }
        }
        this.dropChannelAndScheduler(slotChannel, cardServiceScheduler);
    }

    public void remove(CardServiceFactory cardServiceFactory) {
        this.itracer.debug("remove", "(" + cardServiceFactory + ")");
        if (this.factories.containsKey(cardServiceFactory)) {
            CardServiceHashtable cardServiceHashtable = this.factories;
            synchronized (cardServiceHashtable) {
                this.factories.remove(cardServiceFactory);
            }
            this.itracer.info("remove", "removed " + cardServiceFactory);
        }
    }

    private void scanCardTerminals() throws CardTerminalException {
        Enumeration enumeration = CardTerminalRegistry.getRegistry().getCardTerminals();
        while (enumeration.hasMoreElements()) {
            CardTerminal cardTerminal = (CardTerminal)enumeration.nextElement();
            Enumeration enumeration2 = cardTerminal.enumerateSlots();
            this.itracer.debug("scanCardTerminals", "checking " + cardTerminal);
            while (enumeration2.hasMoreElements()) {
                Slot slot = (Slot)enumeration2.nextElement();
                if (!slot.isCardPresent()) continue;
                this.itracer.info("scanCardTerminals", "slot " + slot + " has card inserted");
                Hashtable hashtable = this.aliveSlots;
                synchronized (hashtable) {
                    this.aliveSlots.put(slot, slot);
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\n");
        Enumeration enumeration = this.factories.elements();
        while (enumeration.hasMoreElements()) {
            CardServiceFactory cardServiceFactory = (CardServiceFactory)enumeration.nextElement();
            stringBuffer.append("++ registered factory ").append(cardServiceFactory).append("\n");
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SmartCard waitForCard(CardRequest cardRequest) throws CardTerminalException {
        CardServiceScheduler cardServiceScheduler = null;
        CardID cardID = null;
        Slot slot = null;
        SlotChannel slotChannel = null;
        Object object = this.waitForCardMonitor;
        synchronized (object) {
            this.itracer.debug("waitForCard", "req " + cardRequest);
            if (cardRequest.getWaitBehavior() == 1) {
                slotChannel = this.findSlotChannel(cardRequest, cardID);
                if (slotChannel == null) {
                    slot = this.findAliveSlot(cardRequest, cardID);
                    if (slot != null) {
                        cardID = slot.getCardID();
                    }
                } else {
                    cardID = slotChannel.getCardID();
                }
            }
            if (slotChannel == null && slot == null) {
                CardTerminalEvent cardTerminalEvent = this.currentCTEvent;
                if (!this.doWait(cardRequest)) {
                    return null;
                }
                this.itracer.debug("waitForCard", "stopped waiting");
                if (cardTerminalEvent == this.currentCTEvent) {
                    this.itracer.info("waitForCard", "timed out for " + cardRequest);
                    return null;
                }
                this.itracer.debug("waitForCard", "ctEvent is " + this.currentCTEvent);
                cardID = this.currentCTEvent.getSlot().getCardID();
                CardTerminal cardTerminal = (CardTerminal)this.currentCTEvent.getSource();
                if (!this.isCardRequestSatisfied(cardRequest, cardID, cardTerminal)) {
                    this.itracer.info("waitForCard", "CardRequest " + cardRequest + " cannot be satisfied with " + cardID);
                    return null;
                }
                slot = this.currentCTEvent.getSlot();
                if (slot == null) {
                    throw new OpenCardRuntimeException("CardTerminalEvent lacked Slot");
                }
                slotChannel = null;
                Object v = this.aliveSlots.get(slot);
                if (v != null && v instanceof SlotChannel) {
                    this.itracer.debug("waitForCard", "secondary waitForCard(); don't need to open SlotChannel again");
                    slotChannel = (SlotChannel)v;
                }
            }
            cardServiceScheduler = this.allocateCardServiceScheduler(slot, slotChannel);
        }
        this.itracer.debug("waitForCard", "using CardServiceScheduler " + cardServiceScheduler);
        return cardServiceScheduler.createSmartCard(cardID);
    }
}

