/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.payflex;

import com.sun.opencard.service.common.OCFCardException;
import com.sun.opencard.service.common.PinCardService;
import com.sun.opencard.service.common.ServiceUtil;
import com.sun.opencard.service.payflex.PayFlexConstants;
import opencard.core.OpenCardException;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.terminal.ISOCommandAPDU;

public class PayFlexPinCardService
extends PinCardService {
    int apdu_status;
    boolean isValidated = false;

    private byte[] changeKey(byte by, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[21];
        byte[] byArray4 = new byte[16];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray.length, byArray2.length);
        int n = 0;
        while (n < 8) {
            System.out.println("oldPin : oldPin[" + n + "] =" + byArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < 8) {
            System.out.println("newPin : newPin[" + n2 + "] =" + byArray2[n2]);
            ++n2;
        }
        byArray3[0] = 0;
        byArray3[1] = 36;
        byArray3[2] = 0;
        byArray3[3] = by;
        byArray3[4] = 16;
        System.arraycopy(byArray, 0, byArray3, 5, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, 5 + byArray.length, byArray2.length);
        return byArray3;
    }

    public void changePin(byte[] byArray, byte[] byArray2) throws OpenCardException, OCFCardException {
        this.changeUserPin(byArray, byArray2);
    }

    public void changeUserPin(byte[] byArray, byte[] byArray2) throws OpenCardException, OCFCardException {
        byte[] byArray3 = null;
        Object var5_4 = null;
        try {
            this.setupPinService();
            byte[] byArray4 = ServiceUtil.paddingFF(byArray, 8);
            byte[] byArray5 = ServiceUtil.paddingFF(byArray2, 8);
            ResponseAPDU responseAPDU = this.sendAPDU(new CommandAPDU(this.selectRoot()));
            responseAPDU = this.sendAPDU(new CommandAPDU(this.selectDedicatedFile()));
            byArray3 = this.changeKey((byte)16, byArray4, byArray5);
            responseAPDU = this.sendAPDU(new CommandAPDU(byArray3));
        }
        finally {
            Object var7_8 = null;
            this.releaseCardChannel();
        }
    }

    public void clearPin() throws OpenCardException, OCFCardException {
    }

    public void deletePin() throws OpenCardException, OCFCardException {
        throw new OCFCardException(0, "service not implemented for MicroPayFlex");
    }

    protected void initialize(CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        super.initialize(cardServiceScheduler, smartCard, bl);
    }

    public boolean isLocked() {
        return false;
    }

    public void lock() {
    }

    private byte[] selectDedicatedFile() {
        byte[] byArray = new byte[]{0, -92, 0, 0, 2, 95, 0};
        return byArray;
    }

    private byte[] selectRoot() {
        byte[] byArray = new byte[]{0, -92, 0, 0, 2, 63, 0};
        return byArray;
    }

    private ResponseAPDU sendAPDU(CommandAPDU commandAPDU) throws OpenCardException {
        ResponseAPDU responseAPDU = this.getCardChannel().sendCommandAPDU(commandAPDU);
        this.apdu_status = responseAPDU.sw();
        OCFCardException.checkStatus(responseAPDU.sw());
        return responseAPDU;
    }

    private ResponseAPDU sendAPDU(ISOCommandAPDU iSOCommandAPDU) throws OpenCardException, OCFCardException {
        ResponseAPDU responseAPDU = this.getCardChannel().sendCommandAPDU(iSOCommandAPDU);
        if (responseAPDU.sw1() == -97) {
            byte[] byArray = new byte[5];
            byArray[1] = -64;
            byArray[4] = responseAPDU.sw2();
            byte[] byArray2 = byArray;
            responseAPDU = this.getCardChannel().sendCommandAPDU(new CommandAPDU(byArray2));
        }
        this.apdu_status = responseAPDU.sw();
        OCFCardException.checkStatus(responseAPDU.sw());
        return responseAPDU;
    }

    public void setPin(byte[] byArray) throws OpenCardException, OCFCardException {
    }

    private void setupPinService() throws OpenCardException, OCFCardException {
        this.allocateCardChannel();
        CardChannel cardChannel = this.getCardChannel();
        if (cardChannel.getState() == PayFlexConstants.payflexAccessAID) {
            return;
        }
        cardChannel.setState(PayFlexConstants.payflexAccessAID);
    }

    public boolean validateAndUnlock(byte[] byArray) throws OpenCardException, OCFCardException {
        this.isValidated = this.validateUserPin(byArray);
        return this.isValidated;
    }

    public boolean validatePin(byte[] byArray) throws OpenCardException, OCFCardException {
        try {
            this.isValidated = this.validateUserPin(byArray);
        }
        catch (Exception exception) {
            System.out.println("Invalid Pin");
        }
        return this.isValidated;
    }

    private boolean validateUserPin(byte[] byArray) throws OpenCardException, OCFCardException {
        byte[] byArray2 = null;
        try {
            this.setupPinService();
            if (byArray.length > 8) {
                throw new OCFCardException(-28410, "invalid parameter length");
            }
            byte[] byArray3 = ServiceUtil.paddingFF(byArray, 8);
            ResponseAPDU responseAPDU = this.sendAPDU(new CommandAPDU(this.selectRoot()));
            responseAPDU = this.sendAPDU(new CommandAPDU(this.selectDedicatedFile()));
            byArray2 = this.verifyKeyAPDU((byte)16, byArray3);
            responseAPDU = this.sendAPDU(new CommandAPDU(byArray2));
            boolean bl = responseAPDU.sw1() == -112 && responseAPDU.sw2() == 0;
            Object var6_6 = null;
            this.releaseCardChannel();
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.releaseCardChannel();
            throw throwable;
        }
    }

    private byte[] verifyKeyAPDU(byte by, byte[] byArray) {
        byte[] byArray2 = new byte[5 + byArray.length];
        byArray2[0] = 0;
        byArray2[1] = 32;
        byArray2[2] = 0;
        byArray2[3] = by;
        byArray2[4] = 8;
        System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
        return byArray2;
    }
}

