/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.payflex;

import com.sun.ami.crypto.AMI_Crypto;
import com.sun.opencard.service.common.ChallengeResponseCardService;
import com.sun.opencard.service.common.OCFCardException;
import com.sun.opencard.service.common.OCFCode;
import com.sun.opencard.service.payflex.PayFlexConstants;
import com.sun.opencard.utils.OCFUtils;
import java.security.SecureRandom;
import opencard.core.OpenCardException;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public class PayFlexChallengeResponseCardService
extends ChallengeResponseCardService {
    int apdu_status;
    protected OCFCode ocf_codes;

    public boolean challenge(String string, String string2) throws OpenCardException, OCFCardException {
        byte[] byArray = new byte[8];
        SecureRandom secureRandom = null;
        System.out.println("Generate Random Number");
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        secureRandom.nextBytes(byArray);
        int n = 6;
        byte[] byArray2 = new byte[8];
        try {
            this.setupChallengeResponse();
            System.out.println("About to call Internal Authenticate");
            ResponseAPDU responseAPDU = this.sendAPDU(new CommandAPDU(this.internalAuthenticate(byArray)));
            responseAPDU = this.sendAPDU(new CommandAPDU(this.getInternalAuthenticateResponse()));
            if (responseAPDU.data() != null) {
                int n2 = 0;
                while (n2 < n) {
                    byArray2[n2] = responseAPDU.data()[n2];
                    ++n2;
                }
                byArray2[6] = 0;
                byArray2[7] = 0;
                PayFlexChallengeResponseCardService.printhex(byArray2);
                System.out.println("\n");
            }
            byte[] byArray3 = this.getKey(string, string2);
            byte[] byArray4 = this.getIV(string2);
            AMI_Crypto aMI_Crypto = new AMI_Crypto();
            aMI_Crypto.ami_init();
            aMI_Crypto.ami_des3des_encrypt("DES", byArray, byArray.length, 2, byArray3, byArray4);
            byte[] byArray5 = new byte[8];
            byArray5 = aMI_Crypto.getOutputData();
            aMI_Crypto.ami_end();
            System.out.println("tmp2..encrypted by host");
            PayFlexChallengeResponseCardService.printhex(byArray5);
            System.out.println("\n");
            int n3 = 0;
            while (n3 < n) {
                if (byArray2[n3] != byArray5[n3]) {
                    System.out.println("Challenge Failed!");
                    return false;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    protected byte[] getIV(String string) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = 0;
            ++n;
        }
        return byArray;
    }

    private byte[] getInternalAuthenticateResponse() {
        byte[] byArray = new byte[]{0, -64, 0, 0, 6};
        return byArray;
    }

    protected byte[] getKey(String string, String string2) {
        byte[] byArray = new byte[8];
        try {
            String string3 = OCFUtils.getProperty("ocf.server.keys.chkey." + string + "." + string2, null);
            if (string3.length() != 16) {
                return null;
            }
            char[] cArray = string3.toCharArray();
            int n = 0;
            while (n < byArray.length) {
                short s = cArray[2 * n] > '@' ? (short)(cArray[2 * n] - 55) : (short)(cArray[2 * n] - 48);
                short s2 = cArray[2 * n + 1] > '@' ? (short)(cArray[2 * n + 1] - 55) : (short)(cArray[2 * n + 1] - 48);
                byArray[n] = (byte)(s * 16 + s2);
                ++n;
            }
            return byArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return byArray;
        }
    }

    protected void initialize(CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        super.initialize(cardServiceScheduler, smartCard, bl);
    }

    private byte[] internalAuthenticate(byte[] byArray) {
        byte[] byArray2 = new byte[13];
        byArray2[0] = 0;
        byArray2[1] = -120;
        byArray2[2] = 0;
        byArray2[3] = 0;
        byArray2[4] = 8;
        System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
        int n = 0;
        while (n < byArray2.length) {
            System.out.println("internalAuthenticate apdu[" + n + "] = " + byArray2[n]);
            ++n;
        }
        return byArray2;
    }

    public static void printhex(byte[] byArray) {
        if (byArray.length % 8 != 0) {
            System.out.print("array not multiple of 8 bytes\n");
            return;
        }
        int n = 0;
        while (n < byArray.length / 8) {
            int n2 = 0;
            while (n2 < 8) {
                byte by = (byte)((byArray[n * 8 + n2] & 0xF0) >>> 4);
                byte by2 = (byte)(byArray[n * 8 + n2] & 0xF);
                System.out.print("0x");
                char c = by < 10 ? (char)(48 + by) : (char)(65 + by - 10);
                System.out.print(c);
                c = by2 < 10 ? (char)(48 + by2) : (char)(65 + by2 - 10);
                System.out.print(c);
                System.out.print(" ");
                ++n2;
            }
            System.out.println();
            ++n;
        }
    }

    private ResponseAPDU sendAPDU(CommandAPDU commandAPDU) throws OpenCardException {
        ResponseAPDU responseAPDU = this.getCardChannel().sendCommandAPDU(commandAPDU);
        this.apdu_status = responseAPDU.sw();
        OCFCardException.checkStatus(responseAPDU.sw());
        return responseAPDU;
    }

    private void setupChallengeResponse() throws CardServiceException, CardTerminalException {
        this.allocateCardChannel();
        CardChannel cardChannel = this.getCardChannel();
        if (cardChannel.getState() == PayFlexConstants.payflexAccessAID) {
            return;
        }
        cardChannel.setState(PayFlexConstants.payflexAccessAID);
    }
}

