/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.ocf;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.server.OCFCardHandle;
import com.sun.opencard.server.OCFClientHandle;
import com.sun.opencard.server.OCFServer;
import com.sun.opencard.service.common.ServiceUtil;
import com.sun.opencard.service.ocf.CTListeningService;
import com.sun.opencard.utils.OCFUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.terminal.Slot;

class OCF_CTListener
implements CTListener {
    private Hashtable svcs = new Hashtable();
    private long waitid = 0L;

    OCF_CTListener() {
    }

    long addWaitingService(CTListeningService cTListeningService) {
        Hashtable hashtable = this.svcs;
        synchronized (hashtable) {
            ++this.waitid;
            this.svcs.put(new Long(this.waitid), cTListeningService);
            long l = this.waitid;
            Object var5_4 = null;
            return l;
        }
    }

    public void cardInserted(CardTerminalEvent cardTerminalEvent) {
        try {
            OCF_CTListener.debug("cardInserted", "");
            Slot slot = cardTerminalEvent.getSlot();
            String string = slot.getCardTerminal().getName();
            String string2 = this.getATRPropName(string);
            String string3 = ServiceUtil.toHexString(slot.getCardID().getATR());
            OCF_CTListener.debug("cardInserted", "setting propName = [" + string2 + "] " + "propValue = [" + string3 + "]");
            OCFUtils.setProperty(string2, string3);
            CardServiceFactory cardServiceFactory = CardServiceRegistry.getRegistry().find(slot.getCardID());
            String string4 = cardServiceFactory.getName();
            long l = OCFServer.createCardHandle(cardTerminalEvent, string4, string);
            OCF_CTListener.debug("cardInserted", String.valueOf(string4) + " inserted in " + string + ", handle=" + l);
            Hashtable hashtable = this.svcs;
            synchronized (hashtable) {
                Enumeration enumeration = this.svcs.elements();
                while (enumeration.hasMoreElements()) {
                    CTListeningService cTListeningService = (CTListeningService)enumeration.nextElement();
                    cTListeningService.cardInserted(l, string4, string, cardServiceFactory);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void cardRemoved(CardTerminalEvent cardTerminalEvent) {
        try {
            OCF_CTListener.debug("cardRemoved", "");
            Slot slot = cardTerminalEvent.getSlot();
            String string = slot.getCardTerminal().getName();
            String string2 = this.getATRPropName(string);
            OCF_CTListener.debug("cardRemoved", "removing propName = [" + string2 + "]");
            OCFUtils.deleteProperty(string2);
            OCFCardHandle oCFCardHandle = OCFServer.removeHandle(slot.getSlotID(), string);
            Hashtable hashtable = this.svcs;
            synchronized (hashtable) {
                OCF_CTListener.debug("cardRemoved", "signaling " + this.svcs.size() + " threads");
                Enumeration enumeration = this.svcs.elements();
                while (enumeration.hasMoreElements()) {
                    ((CTListeningService)enumeration.nextElement()).cardRemoved(oCFCardHandle);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void debug(String string, String string2) {
        try {
            OCFDebug.debugln("OCFListener : <" + string + "> " + string2);
        }
        catch (Exception exception) {}
    }

    void deregister(OCFClientHandle oCFClientHandle) throws Exception {
        OCF_CTListener.debug("deregister", "waking up all waiting threads");
        long l = oCFClientHandle.getValue();
        Hashtable hashtable = this.svcs;
        synchronized (hashtable) {
            Enumeration enumeration = this.svcs.elements();
            while (enumeration.hasMoreElements()) {
                ((CTListeningService)enumeration.nextElement()).deregister(l);
            }
        }
    }

    private String getATRPropName(String string) {
        return String.valueOf(OCFConstants.OCF_SERVER_PROPERTY_PREFIX) + string + ".0.ATR";
    }

    void removeWaitingService(long l) {
        Hashtable hashtable = this.svcs;
        synchronized (hashtable) {
            if (this.svcs.remove(new Long(l)) == null) {
                OCF_CTListener.debug("removeWaitingService", "remove failed");
            }
        }
    }
}

