/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.common;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFReturnValues;
import com.sun.opencard.service.common.OCFCardException;
import com.sun.opencard.service.common.OCFCardService;
import com.sun.opencard.service.common.OCFCode;
import com.sun.opencard.service.common.ServiceUtil;
import com.sun.opencard.service.common.UserInfo;
import opencard.core.OpenCardException;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.terminal.ISOCommandAPDU;

public class UserInfoCardService
extends OCFCardService {
    int apdu_status;
    protected UserInfo userInfo = new UserInfo();
    protected String userName;
    protected String userPass;
    protected String uid;
    protected String appType;
    protected OCFCode ocf_codes;

    public void deleteUserInfo(byte[] byArray, String string) throws OpenCardException {
        try {
            this.setupUserInfo();
            byte[] byArray2 = ServiceUtil.paddingZero(string.getBytes(), this.ocf_codes.APPTYPE_LENGTH_Byte());
            byte[] byArray3 = ServiceUtil.paddingZero(byArray, this.ocf_codes.USER_PIN_LENGTH_Byte());
            byte[] byArray4 = ServiceUtil.arrayJoin(byArray3, byArray2);
            ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.ClassByte(), 78, -1, 0, byArray4);
            ResponseAPDU responseAPDU = this.sendAPDU(iSOCommandAPDU);
        }
        finally {
            Object var5_8 = null;
            this.releaseCardChannel();
        }
    }

    public UserInfo getUserInfo(String string) throws OpenCardException, OCFCardException {
        this.userInfo.setName(this.getUserName(string));
        this.userInfo.setAppType(string);
        return this.userInfo;
    }

    public String getUserName(String string) throws OpenCardException {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        try {
            try {
                this.setupUserInfo();
                byte[] byArray = ServiceUtil.paddingZero(string.getBytes(), this.ocf_codes.USERNAME_LENGTH_Byte());
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = (byte)byArray.length;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                ResponseAPDU responseAPDU = this.sendAPDU(new ISOCommandAPDU((int)this.ocf_codes.ClassByte(), (int)this.ocf_codes.GET_USERNAME_Byte(), 0, 0, byArray2, (int)this.ocf_codes.USERNAME_LENGTH_Byte()));
                String string2 = new String(responseAPDU.data()).trim();
                this.userInfo.setName(string2);
                String string3 = string2;
                Object var6_10 = null;
                this.releaseCardChannel();
                return string3;
            }
            catch (Exception exception) {
                oCFReturnValues.setMessage(exception.getMessage());
                oCFReturnValues.setStatus(OCFConstants.OCF_EXCEPTION);
                String string4 = oCFReturnValues.getReturnValues();
                Object var6_11 = null;
                this.releaseCardChannel();
                return string4;
            }
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            this.releaseCardChannel();
            throw throwable;
        }
    }

    public String getUserPassword(byte[] byArray, String string) throws OpenCardException, OCFCardException {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        try {
            try {
                String string2;
                this.setupUserInfo();
                byte[] byArray2 = ServiceUtil.paddingZero(byArray, this.ocf_codes.USER_PIN_LENGTH_Byte());
                byte[] byArray3 = ServiceUtil.paddingZero(string.getBytes(), this.ocf_codes.APPTYPE_LENGTH_Byte());
                byte[] byArray4 = ServiceUtil.arrayJoin(byArray2, byArray3);
                ResponseAPDU responseAPDU = this.sendAPDU(new ISOCommandAPDU((int)this.ocf_codes.ClassByte(), (int)this.ocf_codes.GET_USERPASS_Byte(), 0, 0, byArray4, (int)this.ocf_codes.USERPASS_LENGTH_Byte()));
                String string3 = string2 = new String(responseAPDU.data()).trim();
                Object var7_12 = null;
                this.releaseCardChannel();
                return string3;
            }
            catch (Exception exception) {
                oCFReturnValues.setMessage(exception.getMessage());
                oCFReturnValues.setStatus(OCFConstants.OCF_EXCEPTION);
                String string4 = oCFReturnValues.getReturnValues();
                Object var7_13 = null;
                this.releaseCardChannel();
                return string4;
            }
        }
        catch (Throwable throwable) {
            Object var7_14 = null;
            this.releaseCardChannel();
            throw throwable;
        }
    }

    private String getUserUID(String string) throws OpenCardException {
        return "";
    }

    protected void initialize(CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        super.initialize(cardServiceScheduler, smartCard, bl);
    }

    protected ResponseAPDU sendAPDU(ISOCommandAPDU iSOCommandAPDU) throws OpenCardException {
        ResponseAPDU responseAPDU = this.getCardChannel().sendCommandAPDU(iSOCommandAPDU);
        this.apdu_status = responseAPDU.sw();
        OCFCardException.checkStatus(responseAPDU.sw());
        return responseAPDU;
    }

    public void setAppType(byte[] byArray, String string) throws OpenCardException {
        try {
            this.setupUserInfo();
            byte[] byArray2 = ServiceUtil.paddingZero(string.getBytes(), this.ocf_codes.APPTYPE_LENGTH_Byte());
            byte[] byArray3 = ServiceUtil.paddingZero(byArray, this.ocf_codes.USER_PIN_LENGTH_Byte());
            byte[] byArray4 = ServiceUtil.arrayJoin(byArray3, byArray2);
            ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.ClassByte(), 78, 0, 0, byArray4);
            ResponseAPDU responseAPDU = this.sendAPDU(iSOCommandAPDU);
        }
        finally {
            Object var5_8 = null;
            this.releaseCardChannel();
        }
    }

    public void setUserInfo(byte[] byArray, UserInfo userInfo) throws OpenCardException {
        byte[] byArray2 = ServiceUtil.paddingZero(byArray, this.ocf_codes.USER_PIN_LENGTH_Byte());
        this.setAppType(byArray2, userInfo.getAppType());
        this.setUserName(byArray2, userInfo.getName(), userInfo.getAppType());
        this.setUserUID(byArray2, userInfo.getUID(), userInfo.getAppType());
    }

    public void setUserName(byte[] byArray, String string, String string2) throws OpenCardException {
        try {
            this.setupUserInfo();
            byte[] byArray2 = ServiceUtil.paddingZero(byArray, this.ocf_codes.USER_PIN_LENGTH_Byte());
            byte[] byArray3 = ServiceUtil.paddingZero(string.getBytes(), this.ocf_codes.USERNAME_LENGTH_Byte());
            byte[] byArray4 = ServiceUtil.paddingZero(string2.getBytes(), this.ocf_codes.APPTYPE_LENGTH_Byte());
            byte[] byArray5 = ServiceUtil.arrayJoin(byArray2, byArray3);
            byte[] byArray6 = ServiceUtil.arrayJoin(byArray5, byArray4);
            ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.ClassByte(), (int)this.ocf_codes.SET_USERNAME_Byte(), 0, 0, byArray6, (int)this.ocf_codes.USERNAME_LENGTH_Byte());
            ResponseAPDU responseAPDU = this.sendAPDU(iSOCommandAPDU);
        }
        finally {
            Object var6_11 = null;
            this.releaseCardChannel();
        }
    }

    public void setUserPassword(byte[] byArray, String string, String string2) throws OpenCardException {
        try {
            this.setupUserInfo();
            byte[] byArray2 = ServiceUtil.paddingZero(byArray, this.ocf_codes.USER_PIN_LENGTH_Byte());
            byte[] byArray3 = ServiceUtil.paddingZero(string.getBytes(), this.ocf_codes.USERPASS_LENGTH_Byte());
            byte[] byArray4 = ServiceUtil.paddingZero(string2.getBytes(), this.ocf_codes.APPTYPE_LENGTH_Byte());
            byte[] byArray5 = ServiceUtil.arrayJoin(byArray2, byArray3);
            byte[] byArray6 = ServiceUtil.arrayJoin(byArray5, byArray4);
            ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.ClassByte(), (int)this.ocf_codes.SET_USERPASS_Byte(), 0, 0, byArray6);
            ResponseAPDU responseAPDU = this.sendAPDU(iSOCommandAPDU);
        }
        finally {
            Object var6_11 = null;
            this.releaseCardChannel();
        }
    }

    private void setUserUID(byte[] byArray, String string, String string2) throws OpenCardException {
        try {
            this.setupUserInfo();
            System.out.println("new key=" + string);
            byte[] byArray2 = ServiceUtil.parseHexString(string);
            System.out.println("uidBytes=" + byArray2.length);
            byte[] byArray3 = ServiceUtil.paddingZero(byArray2, this.ocf_codes.USERUID_LENGTH_Byte());
            byte[] byArray4 = ServiceUtil.paddingZero(string2.getBytes(), this.ocf_codes.APPTYPE_LENGTH_Byte());
            byte[] byArray5 = ServiceUtil.arrayJoin(byArray, byArray3);
            byte[] byArray6 = ServiceUtil.arrayJoin(byArray5, byArray4);
            ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.ClassByte(), (int)this.ocf_codes.SET_USERUID_Byte(), 0, 0, byArray6);
            ResponseAPDU responseAPDU = this.sendAPDU(iSOCommandAPDU);
        }
        finally {
            Object var6_11 = null;
            this.releaseCardChannel();
        }
    }

    private void setupUserInfo() throws CardServiceException, CardTerminalException {
        this.allocateCardChannel();
        CardChannel cardChannel = this.getCardChannel();
        if (cardChannel.getState() == this.ocf_codes.AIDBytes()) {
            return;
        }
        ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_CLAByte(), (int)this.ocf_codes.Select_INSByte(), 4, 0, this.ocf_codes.AIDBytes());
        try {
            this.sendAPDU(iSOCommandAPDU);
        }
        catch (OpenCardException openCardException) {
            openCardException.printStackTrace();
        }
        cardChannel.setState(this.ocf_codes.AIDBytes());
    }
}

