/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.common;

import com.sun.ami.crypto.AMI_Crypto;
import com.sun.opencard.service.common.OCFCardException;
import com.sun.opencard.service.common.OCFCardService;
import com.sun.opencard.service.common.OCFCode;
import com.sun.opencard.service.common.ServiceUtil;
import com.sun.opencard.utils.OCFUtils;
import java.security.SecureRandom;
import opencard.core.OpenCardException;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.terminal.ISOCommandAPDU;

public class ChallengeResponseCardService
extends OCFCardService {
    protected OCFCode ocf_codes;

    public boolean challenge(String string, String string2) throws OpenCardException, OCFCardException {
        byte[] byArray = new byte[8];
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        secureRandom.nextBytes(byArray);
        int n = 6;
        byte[] byArray2 = new byte[8];
        try {
            this.setupChallengeResponse();
            byte[] byArray3 = ServiceUtil.paddingZero(string.getBytes(), this.ocf_codes.APPTYPE_LENGTH_Byte());
            byte[] byArray4 = ServiceUtil.arrayJoin(byArray3, byArray);
            ResponseAPDU responseAPDU = this.sendAPDU(new ISOCommandAPDU((int)this.ocf_codes.UserClassByte(), (int)this.ocf_codes.CHALLENGE_RESPONSE_Byte(), 0, 0, byArray4, n));
            if (responseAPDU.data() != null) {
                int n2 = 0;
                while (n2 < n) {
                    byArray2[n2] = responseAPDU.data()[n2];
                    ++n2;
                }
                byArray2[6] = 0;
                byArray2[7] = 0;
            }
            byte[] byArray5 = this.getKey(string, string2);
            ServiceUtil.printhex(byArray5);
            byte[] byArray6 = this.getIV(string2);
            AMI_Crypto aMI_Crypto = new AMI_Crypto();
            aMI_Crypto.ami_init();
            aMI_Crypto.ami_des3des_encrypt("DES", byArray, byArray.length, 2, byArray5, byArray6);
            byte[] byArray7 = new byte[8];
            byArray7 = aMI_Crypto.getOutputData();
            aMI_Crypto.ami_end();
            int n3 = 0;
            while (n3 < n) {
                if (byArray2[n3] != byArray7[n3]) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    protected byte[] getIV(String string) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = 0;
            ++n;
        }
        return byArray;
    }

    protected byte[] getKey(String string, String string2) {
        byte[] byArray = new byte[8];
        try {
            String string3 = OCFUtils.getProperty("ocf.server.keys.chkey." + string + "." + string2, null);
            if (string3.length() != 16) {
                return null;
            }
            char[] cArray = string3.toCharArray();
            int n = 0;
            while (n < byArray.length) {
                short s = cArray[2 * n] > '@' ? (short)(cArray[2 * n] - 55) : (short)(cArray[2 * n] - 48);
                short s2 = cArray[2 * n + 1] > '@' ? (short)(cArray[2 * n + 1] - 55) : (short)(cArray[2 * n + 1] - 48);
                byArray[n] = (byte)(s * 16 + s2);
                ++n;
            }
            return byArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return byArray;
        }
    }

    protected void initialize(CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        super.initialize(cardServiceScheduler, smartCard, bl);
    }

    private ResponseAPDU sendAPDU(ISOCommandAPDU iSOCommandAPDU) throws OpenCardException {
        ResponseAPDU responseAPDU = this.getCardChannel().sendCommandAPDU(iSOCommandAPDU);
        OCFCardException.checkStatus(responseAPDU.sw());
        return responseAPDU;
    }

    private void setupChallengeResponse() throws CardServiceException, CardTerminalException {
        this.allocateCardChannel();
        CardChannel cardChannel = this.getCardChannel();
        if (cardChannel.getState() == this.ocf_codes.AIDBytes()) {
            return;
        }
        ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_CLAByte(), (int)this.ocf_codes.Select_INSByte(), 4, 0, this.ocf_codes.AIDBytes());
        try {
            this.sendAPDU(iSOCommandAPDU);
        }
        catch (OpenCardException openCardException) {
            openCardException.printStackTrace();
        }
        cardChannel.setState(this.ocf_codes.AIDBytes());
    }
}

