/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.auth;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.common.OCFReturnValues;
import com.sun.opencard.server.OCFCardHandle;
import com.sun.opencard.server.OCFClientHandle;
import com.sun.opencard.service.auth.OCFAuth;
import com.sun.opencard.service.auth.OCFAuthenticate;
import com.sun.opencard.service.auth.OCFPinAuthData;
import com.sun.opencard.service.common.PinCardService;
import com.sun.opencard.utils.OCFUtils;
import opencard.core.service.SmartCard;

public class OCFPinAuth
extends OCFAuth {
    private final int ENTER_PIN = 0;

    public String authenticate(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle, String string, String string2, int n) throws Exception {
        OCFDebug.debugln("In OCFPinAuth::authenticate");
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCFAUTH_SUCCESS, null);
        OCFAuthenticate oCFAuthenticate = this.getAuth(oCFClientHandle);
        OCFPinAuthData oCFPinAuthData = (OCFPinAuthData)oCFAuthenticate.getAuthData("PIN");
        if (oCFPinAuthData == null) {
            oCFPinAuthData = new OCFPinAuthData(string, string2, 0);
            oCFAuthenticate.setAuthData("PIN", oCFPinAuthData);
            oCFReturnValues.setStatus(OCFConstants.OCFAUTH_OP);
            oCFReturnValues.addReturnParam("tag", OCFConstants.OCFAUTH_ENTER_PIN);
            oCFAuthenticate.setRetStatus(2);
            this.setAuth(oCFClientHandle, oCFAuthenticate);
            return oCFReturnValues.getReturnValues();
        }
        OCFDebug.debugln("OCFAuthenticationService::status = " + oCFPinAuthData.getState());
        switch (oCFPinAuthData.getState()) {
            case 0: {
                oCFPinAuthData.setPin(string);
                Class clazz = OCFUtils.getClass("PinCardService", "cardservicelocations");
                SmartCard smartCard = oCFCardHandle.getSmartCard();
                if (smartCard == null) {
                    oCFReturnValues.setStatus(OCFConstants.OCF_NOCARD);
                    oCFPinAuthData.setState(1);
                    oCFAuthenticate.setRetStatus(1);
                    break;
                }
                PinCardService pinCardService = (PinCardService)OCFUtils.getCardService(smartCard, clazz, oCFCardHandle);
                if (pinCardService == null) {
                    oCFReturnValues.setStatus(OCFConstants.OCF_SERVICE_NOT_SUPPORTED);
                    oCFPinAuthData.setState(1);
                    oCFAuthenticate.setRetStatus(1);
                    smartCard.close();
                    break;
                }
                if (!pinCardService.validateAndUnlock(string.getBytes())) {
                    oCFReturnValues.setStatus(OCFConstants.OCFAUTH_INVALID_PIN);
                    oCFPinAuthData.setState(1);
                    oCFAuthenticate.setRetStatus(1);
                } else {
                    oCFPinAuthData.setState(0);
                    oCFAuthenticate.setRetStatus(0);
                    oCFCardHandle.setPin(string);
                }
                smartCard.close();
                break;
            }
            default: {
                oCFPinAuthData.setState(0);
                oCFReturnValues.setStatus(OCFConstants.OCFAUTH_OP);
                oCFReturnValues.addReturnParam("tag", OCFConstants.OCFAUTH_ENTER_PIN);
                oCFAuthenticate.setRetStatus(2);
                return oCFReturnValues.getReturnValues();
            }
        }
        if (oCFAuthenticate.getRetStatus() == 1) {
            return oCFReturnValues.getReturnValues();
        }
        oCFAuthenticate.setAuthData("PIN", oCFPinAuthData);
        this.setAuth(oCFClientHandle, oCFAuthenticate);
        return oCFReturnValues.getReturnValues();
    }
}

