/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.server;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.common.OCFException;
import com.sun.opencard.server.OCFCardHandle;
import com.sun.opencard.server.OCFClientHandle;
import com.sun.opencard.server.OCFPair;
import com.sun.opencard.service.unknowncard.UnknownCardServiceFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalRegistry;

public class OCFServer {
    private static long curInstance = 1L;
    private static long curClientHandle = 1L;
    private static long curCardHandle = 1L;
    private static Hashtable lockedCards = new Hashtable();
    private static Hashtable clientHandles = new Hashtable();
    private static Hashtable cardHandles = new Hashtable();
    private static Vector pairs = new Vector();
    private static Hashtable removedHandles = new Hashtable();
    private static Hashtable cardsRegistered = new Hashtable();
    private static Hashtable terminalsRegistered = new Hashtable();
    private static float OCF_version = 1.0f;

    public static void addPair(OCFPair oCFPair) {
        pairs.addElement(oCFPair);
    }

    public static boolean checkVersion(float f) {
        return f <= OCF_version;
    }

    public static synchronized long createCardHandle(CardTerminalEvent cardTerminalEvent, String string, String string2) throws Exception {
        if (string == null || string2 == null) {
            return 0L;
        }
        if (string.equals(OCFConstants.OCF_WaitForCardSpec_AnyCard) || string2.equals(OCFConstants.OCF_WaitForCardSpec_AnyReader)) {
            return 0L;
        }
        OCFServer.debug("createCardHandle", "");
        OCFCardHandle oCFCardHandle = new OCFCardHandle(0, (Long)cardsRegistered.get(string), (Long)terminalsRegistered.get(string2), curCardHandle, cardTerminalEvent, string, string2);
        cardHandles.put(new Long(curCardHandle), oCFCardHandle);
        return curCardHandle++;
    }

    public static synchronized long createClientHandle(String string) {
        OCFClientHandle oCFClientHandle = new OCFClientHandle(string, curClientHandle);
        clientHandles.put(new Long(curClientHandle), oCFClientHandle);
        return curClientHandle++;
    }

    private static void debug(String string, String string2) {
        try {
            OCFDebug.debugln("OCFServer : <" + string + "> " + string2);
        }
        catch (Exception exception) {}
    }

    public static OCFCardHandle getAlreadyRemovedHandle(int n, String string) throws Exception {
        Enumeration enumeration = removedHandles.keys();
        while (enumeration.hasMoreElements()) {
            OCFServer.debug("getAlreadyRemovedHandle", "checking available handle for " + n + " " + string);
            OCFCardHandle oCFCardHandle = (OCFCardHandle)enumeration.nextElement();
            if (!oCFCardHandle.matchesSlotAndReader(n, string)) continue;
            return oCFCardHandle;
        }
        return null;
    }

    public static OCFCardHandle getCardHandle(long l) {
        return (OCFCardHandle)cardHandles.get(new Long(l));
    }

    public static long getCardHandle(String string, String string2) {
        OCFServer.debug("getCardHandle", "");
        if (string == null || string2 == null) {
            return 0L;
        }
        long l = (Long)cardsRegistered.get(string);
        long l2 = (Long)terminalsRegistered.get(string2);
        Enumeration enumeration = cardHandles.keys();
        while (enumeration.hasMoreElements()) {
            Long l3 = (Long)enumeration.nextElement();
            OCFCardHandle oCFCardHandle = (OCFCardHandle)cardHandles.get(l3);
            if (!oCFCardHandle.matches(l, l2)) continue;
            return l3;
        }
        return 0L;
    }

    public static String getCardName(OCFCardHandle oCFCardHandle) {
        return oCFCardHandle.getCardName();
    }

    public static OCFClientHandle getClientHandle(long l) {
        return (OCFClientHandle)clientHandles.get(new Long(l));
    }

    public static OCFCardHandle getHandle(String string, String string2) throws Exception {
        Enumeration enumeration = cardHandles.elements();
        while (enumeration.hasMoreElements()) {
            OCFServer.debug("getHandle", "checking available handle for " + string + " " + string2);
            OCFCardHandle oCFCardHandle = (OCFCardHandle)enumeration.nextElement();
            if (!oCFCardHandle.matches((Long)cardsRegistered.get(string), (Long)terminalsRegistered.get(string2))) continue;
            return oCFCardHandle;
        }
        return null;
    }

    public static OCFPair getPair(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle) {
        int n = 0;
        while (n < pairs.size()) {
            OCFPair oCFPair = (OCFPair)pairs.elementAt(n);
            if (oCFPair.getClientHandle().equals(oCFClientHandle) && oCFPair.getCardHandle().equals(oCFCardHandle)) {
                return oCFPair;
            }
            ++n;
        }
        return null;
    }

    public static String getReaderName(OCFCardHandle oCFCardHandle) {
        return oCFCardHandle.getReaderName();
    }

    public static void initializeOCF() throws Exception {
        try {
            long l = 0L;
            OCFServer.debug("initializeOCF", "");
            SmartCard.start();
            CardServiceRegistry cardServiceRegistry = CardServiceRegistry.getRegistry();
            cardServiceRegistry.addToEnd(new UnknownCardServiceFactory());
            Enumeration enumeration = cardServiceRegistry.getCardServiceFactories();
            while (enumeration.hasMoreElements()) {
                cardsRegistered.put(((CardServiceFactory)enumeration.nextElement()).getName(), new Long(l++));
            }
            CardTerminalRegistry cardTerminalRegistry = CardTerminalRegistry.getRegistry();
            Enumeration enumeration2 = null;
            try {
                enumeration2 = cardTerminalRegistry.getCardTerminals();
            }
            catch (Exception exception) {
                OCFDebug.debugln(exception.toString());
                OCFDebug.debugln(exception.getMessage());
                exception.printStackTrace();
            }
            l = 0L;
            if (enumeration2 != null) {
                while (enumeration2.hasMoreElements()) {
                    terminalsRegistered.put(((CardTerminal)enumeration2.nextElement()).getName(), new Long(l++));
                }
            }
            OCFServer.debug("initializeOCF", "complete Cards Configured = " + cardsRegistered.size() + " Terms Configured = " + terminalsRegistered.size());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean isLocked(OCFCardHandle oCFCardHandle) {
        return lockedCards.get(oCFCardHandle) != null;
    }

    public static boolean isLockedByOther(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle) {
        OCFClientHandle oCFClientHandle2 = (OCFClientHandle)lockedCards.get(oCFCardHandle);
        if (oCFClientHandle2 == null) {
            return false;
        }
        return !oCFClientHandle.equals(oCFClientHandle2);
    }

    public static boolean isSupportedCard(String string) {
        return cardsRegistered.containsKey(string);
    }

    public static boolean isSupportedReader(String string) {
        return terminalsRegistered.containsKey(string);
    }

    public static Enumeration listSupportedCards() {
        return cardsRegistered.keys();
    }

    public static Enumeration listSupportedReaders() {
        return terminalsRegistered.keys();
    }

    public static synchronized void lock(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle) throws OCFException {
        if (OCFServer.isLocked(oCFCardHandle)) {
            throw new OCFException("Card is already locked.");
        }
        lockedCards.put(oCFCardHandle, oCFClientHandle);
    }

    public static boolean noCardsConfig() {
        return cardsRegistered.size() == 0;
    }

    public static boolean noReadersConfig() {
        return terminalsRegistered.size() == 0;
    }

    public static synchronized void removeClientHandle(OCFClientHandle oCFClientHandle) throws Exception {
        if (lockedCards.contains(oCFClientHandle)) {
            OCFServer.debug("removeClientHandle", "Unlocking cards locked by appln");
            Enumeration enumeration = lockedCards.keys();
            while (enumeration.hasMoreElements()) {
                OCFCardHandle oCFCardHandle = (OCFCardHandle)enumeration.nextElement();
                if (!oCFClientHandle.equals(lockedCards.get(oCFCardHandle))) continue;
                lockedCards.remove(oCFCardHandle);
            }
        }
        clientHandles.remove(new Long(oCFClientHandle.getValue()));
    }

    public static OCFCardHandle removeHandle(int n, String string) throws Exception {
        Enumeration enumeration = cardHandles.elements();
        while (enumeration.hasMoreElements()) {
            OCFServer.debug("removeHandle", "checking available handle for " + n + " " + string);
            OCFCardHandle oCFCardHandle = (OCFCardHandle)enumeration.nextElement();
            if (!oCFCardHandle.matchesSlotAndReader(n, string)) continue;
            cardHandles.remove(new Long(oCFCardHandle.getInstance()));
            removedHandles.put(oCFCardHandle, new Integer(1));
            return oCFCardHandle;
        }
        return OCFServer.getAlreadyRemovedHandle(n, string);
    }

    public static void removePair(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle) {
        int n = 0;
        while (n < pairs.size()) {
            OCFPair oCFPair = (OCFPair)pairs.elementAt(n);
            if (oCFPair.getClientHandle().equals(oCFClientHandle) && oCFPair.getCardHandle().equals(oCFCardHandle)) {
                pairs.remove(n);
            }
            ++n;
        }
    }

    public static void shutdownOCF() throws Exception {
        SmartCard.shutdown();
    }

    public static synchronized void unlock(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle) throws OCFException {
        if (OCFServer.isLockedByOther(oCFClientHandle, oCFCardHandle)) {
            throw new OCFException("Card locked by other application.");
        }
        lockedCards.remove(oCFCardHandle);
    }
}

