/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.server;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.common.OCFGlobals;
import com.sun.opencard.common.OCFParameters;
import com.sun.opencard.common.OCFReturnValues;
import com.sun.opencard.opt.security.CertificateAlias;
import com.sun.opencard.opt.security.PrivateKeyAlias;
import com.sun.opencard.server.OCFCardHandle;
import com.sun.opencard.server.OCFClientHandle;
import com.sun.opencard.server.OCFServer;
import com.sun.opencard.service.auth.OCFAuthenticationService;
import com.sun.opencard.service.ocf.OCFService;
import com.sun.opencard.utils.OCFUtils;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import opencard.core.service.CardService;
import opencard.core.service.SmartCard;

public class OCFDispatcher {
    private final String VALIDATE_AND_UNLOCK = "validateAndUnlock";
    private final String LOCK = "lock";
    private final String ISLOCKED = "isLocked";
    private final String AUTHORIZE_METHOD_NAME = "authorize";
    private String _status = null;

    private String checks(Vector vector) {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        try {
            OCFClientHandle oCFClientHandle = OCFServer.getClientHandle(Long.parseLong(new String((byte[])((OCFParameters)vector.elementAt(0)).getValue())));
            if (oCFClientHandle == null) {
                oCFReturnValues.setStatus(OCFConstants.OCF_INVALID_CLIENT);
                return oCFReturnValues.getReturnValues();
            }
            OCFCardHandle oCFCardHandle = OCFServer.getCardHandle(Long.parseLong(new String((byte[])((OCFParameters)vector.elementAt(1)).getValue())));
            if (oCFCardHandle == null) {
                oCFReturnValues.setStatus(OCFConstants.OCF_INVALID_CARD);
                return oCFReturnValues.getReturnValues();
            }
            OCFService oCFService = new OCFService();
            if (oCFService.isValidCard(oCFClientHandle, oCFCardHandle).indexOf(OCFConstants.OCF_SUCCESS) == -1) {
                oCFReturnValues.setStatus(OCFConstants.OCF_NOT_VALID_CARD);
                return oCFReturnValues.getReturnValues();
            }
            if (OCFServer.isLockedByOther(oCFClientHandle, oCFCardHandle)) {
                oCFReturnValues.setStatus(OCFConstants.OCF_CARD_LOCKED);
                return oCFReturnValues.getReturnValues();
            }
        }
        catch (Exception exception) {
            oCFReturnValues.setStatus(OCFConstants.OCF_EXCEPTION);
            oCFReturnValues.setMessage(exception.getMessage());
            return oCFReturnValues.getReturnValues();
        }
        return oCFReturnValues.getReturnValues();
    }

    private Object[] createArgs(Class[] classArray, Vector vector) throws Exception {
        Object[] objectArray = new Object[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            Class clazz = classArray[n];
            byte[] byArray = new byte[1];
            Object object = ((OCFParameters)vector.elementAt(n)).getValue();
            if (object == null) {
                objectArray[n] = null;
            } else {
                if (byArray.getClass().isAssignableFrom(object.getClass())) {
                    object = new String((byte[])object);
                }
                if (clazz.getName().equals("java.lang.Integer") || clazz.getName().equals("int")) {
                    objectArray[n] = Integer.valueOf((String)object);
                } else if (clazz.getName().equals("java.lang.Long") || clazz.getName().equals("long")) {
                    objectArray[n] = Long.valueOf((String)object);
                } else if (clazz.getName().equals("java.lang.Float") || clazz.getName().equals("float")) {
                    objectArray[n] = Float.valueOf((String)object);
                } else if (clazz.getName().equals("java.lang.String")) {
                    objectArray[n] = ((String)object).equals("null") ? null : (String)object;
                } else if (clazz.getName().equals("java.lang.Boolean") || clazz.getName().equals("boolean")) {
                    objectArray[n] = Boolean.valueOf((String)object);
                } else if (clazz.getName().equals("com.sun.opencard.server.OCFClientHandle")) {
                    objectArray[n] = OCFServer.getClientHandle(Long.parseLong((String)object));
                    if (objectArray[n] == null) {
                        this._status = OCFConstants.OCF_INVALID_CLIENT;
                    }
                } else if (clazz.getName().equals("com.sun.opencard.server.OCFCardHandle")) {
                    objectArray[n] = OCFServer.getCardHandle(Long.parseLong((String)object));
                    if (objectArray[n] == null) {
                        this._status = OCFConstants.OCF_INVALID_CARD;
                    }
                } else if (clazz.getName().equals("opencard.core.service.CardService")) {
                    objectArray[n] = (CardService)object;
                } else if (clazz.getName().equals("[B")) {
                    objectArray[n] = ((String)object).getBytes();
                } else if (clazz.getName().equals("opencard.opt.security.PrivateKeyRef")) {
                    objectArray[n] = new PrivateKeyAlias((String)object);
                } else if (clazz.getName().equals("com.sun.opencard.opt.security.CertificateRef")) {
                    objectArray[n] = new CertificateAlias((String)object);
                } else if (clazz.getName().equals("java.util.Hashtable")) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes());
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    objectArray[n] = objectInputStream.readObject();
                }
            }
            ++n;
        }
        return objectArray;
    }

    public String dispatchAuthenticateService(String string, String string2, String string3, Vector vector) {
        Object var5_5 = null;
        Object var6_6 = null;
        OCFGlobals.storeCurrentUID(string3);
        String string4 = this.checks(vector);
        if (string4.indexOf(OCFConstants.OCF_SUCCESS) == -1) {
            return string4;
        }
        OCFAuthenticationService oCFAuthenticationService = new OCFAuthenticationService();
        return this.invokeMethod(oCFAuthenticationService.getClass(), oCFAuthenticationService, string, string2, vector);
    }

    public String dispatchCardService(String string, String string2, String string3, Vector vector) {
        SmartCard smartCard = null;
        String string4 = this.checks(vector);
        if (string4.indexOf(OCFConstants.OCF_SUCCESS) == -1) {
            return string4;
        }
        OCFGlobals.storeCurrentUID(string3);
        try {
            OCFClientHandle oCFClientHandle = OCFServer.getClientHandle(Long.parseLong(new String((byte[])((OCFParameters)vector.elementAt(0)).getValue())));
            OCFCardHandle oCFCardHandle = OCFServer.getCardHandle(Long.parseLong(new String((byte[])((OCFParameters)vector.elementAt(1)).getValue())));
            Class clazz = OCFUtils.getClass("INT_" + string, "cardservicelocations");
            Object t = clazz.newInstance();
            Class clazz2 = OCFUtils.getClass(string, "cardservicelocations");
            smartCard = oCFCardHandle.getSmartCard();
            if (smartCard == null) {
                OCFDebug.debugln("OCFDispatcher: card is NULL");
                OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_NOCARD, null);
                return oCFReturnValues.getReturnValues();
            }
            CardService cardService = OCFUtils.getCardService(smartCard, clazz2, oCFCardHandle);
            if (cardService == null) {
                OCFDebug.debugln("OCFDispatcher: cardService is NULL");
                OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SERVICE_NOT_SUPPORTED, null);
                return oCFReturnValues.getReturnValues();
            }
            vector.removeElementAt(0);
            vector.removeElementAt(0);
            vector.insertElementAt(new OCFParameters("Object", cardService, false), 0);
            String string5 = oCFCardHandle.getPin();
            if (string5 == null) {
                string5 = new String("");
            }
            vector.insertElementAt(new OCFParameters("String", string5, false), 1);
            if (!string3.equals("-1") && !this.isAuthorized(clazz, t, cardService, oCFCardHandle)) {
                OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_UNAUTHORIZED_ACCESS, null);
                return oCFReturnValues.getReturnValues();
            }
            string4 = this.invokeMethod(clazz, t, string, string2, vector);
            string4 = this.doPinProcessing(string2, string4, oCFCardHandle, vector);
            smartCard.close();
            OCFDebug.debugln("OCFDispatcher returning:: " + string4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                if (smartCard != null) {
                    smartCard.close();
                }
            }
            catch (Exception exception2) {
                OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_EXCEPTION, exception2.getMessage());
                return oCFReturnValues.getReturnValues();
            }
            OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_EXCEPTION, exception.getMessage());
            return oCFReturnValues.getReturnValues();
        }
        return string4;
    }

    public String dispatchOCFService(String string, String string2, String string3, Vector vector) {
        OCFService oCFService = new OCFService();
        OCFGlobals.storeCurrentUID(string3);
        return this.invokeMethod(oCFService.getClass(), oCFService, string, string2, vector);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String doPinProcessing(String string, String string2, OCFCardHandle oCFCardHandle, Vector vector) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        OCFDebug.debugln("doPinProcessing : method : " + string);
        if (string.equals("validateAndUnlock")) {
            if (string2.indexOf(OCFConstants.OCF_SUCCESS) == -1) return string2;
            OCFDebug.debugln("doPinProcessing setting Pin : " + new String((byte[])((OCFParameters)vector.elementAt(2)).getValue()));
            oCFCardHandle.setPin(new String((byte[])((OCFParameters)vector.elementAt(2)).getValue()));
            if (OCFGlobals.getCurrentUID() == null || OCFGlobals.getCurrentUID().equals(OCFConstants.ROOT_USER)) return oCFReturnValues.getReturnValues();
            oCFCardHandle.setUID(OCFGlobals.getCurrentUID());
            return oCFReturnValues.getReturnValues();
        } else if (string.equals("lock")) {
            if (oCFCardHandle.getPin() == null) {
                oCFReturnValues.setStatus(OCFConstants.OCF_CARD_LOCKED);
                return oCFReturnValues.getReturnValues();
            } else {
                oCFCardHandle.setPin(null);
                oCFCardHandle.setUID(null);
            }
            return oCFReturnValues.getReturnValues();
        } else {
            if (!string.equals("isLocked")) return string2;
            if (oCFCardHandle.getPin() == null) {
                oCFReturnValues.setStatus(OCFConstants.OCF_CARD_LOCKED);
                return oCFReturnValues.getReturnValues();
            } else {
                oCFReturnValues.setStatus(OCFConstants.OCF_CARD_UNLOCKED);
            }
        }
        return oCFReturnValues.getReturnValues();
    }

    protected String invokeMethod(Class clazz, Object object, String string, String string2, Vector vector) {
        Object[] objectArray;
        String string3 = null;
        Method[] methodArray = clazz.getMethods();
        this._status = null;
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equals(string2)) {
                objectArray = null;
                try {
                    objectArray = this.createArgs(methodArray[n].getParameterTypes(), vector);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_PARAMETER_ERROR, null);
                    return oCFReturnValues.getReturnValues();
                }
                if (this._status != null) {
                    OCFReturnValues oCFReturnValues = new OCFReturnValues(this._status, null);
                    return oCFReturnValues.getReturnValues();
                }
                try {
                    string3 = (String)methodArray[n].invoke(object, objectArray);
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_EXCEPTION, invocationTargetException.getTargetException().toString());
                    return oCFReturnValues.getReturnValues();
                }
                catch (IllegalAccessException illegalAccessException) {
                    OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_EXCEPTION, illegalAccessException.getMessage());
                    return oCFReturnValues.getReturnValues();
                }
            }
            ++n;
        }
        if (n == methodArray.length) {
            objectArray = new OCFReturnValues(OCFConstants.OCF_EXCEPTION, "No such Method Found :: " + string2);
            return objectArray.getReturnValues();
        }
        return string3;
    }

    private boolean isAuthorized(Class clazz, Object object, CardService cardService, OCFCardHandle oCFCardHandle) throws Exception {
        OCFDebug.debugln("In isAuthorized");
        Object[] objectArray = new Object[4];
        Boolean bl = new Boolean("false");
        objectArray[0] = cardService;
        objectArray[1] = oCFCardHandle.getUID();
        objectArray[2] = OCFGlobals.getCurrentUID();
        objectArray[3] = "authorize";
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equals("authorize")) {
                bl = (Boolean)methodArray[n].invoke(object, objectArray);
                break;
            }
            ++n;
        }
        if (n == methodArray.length) {
            bl = new Boolean("true");
        }
        return bl;
    }
}

