/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.http;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFParameters;
import com.sun.opencard.common.OCFReturnValues;
import com.sun.opencard.http.Handler;
import com.sun.opencard.http.Request;
import com.sun.opencard.http.Server;
import com.sun.opencard.server.OCFDispatcher;
import com.sun.opencard.server.OCFServer;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class OpenCardHandler
implements Handler {
    private Server server;
    private String propsPrefix;
    private String UrlPrefix;
    private static final String PREFIX = "prefix";
    private static OCFDispatcher dispatch = null;
    private static final String DEFAULT_PROP_FILE_LOADER = "com.sun.opencard.utils.OCFPropertyFileLoader";
    private static boolean init = false;

    public OpenCardHandler() {
        this(DEFAULT_PROP_FILE_LOADER);
    }

    public OpenCardHandler(String string) {
        OCFServer oCFServer = new OCFServer();
        System.setProperty("OpenCard.loaderClassName", string);
    }

    public boolean init(Server server, String string) {
        this.server = server;
        this.propsPrefix = string;
        this.UrlPrefix = server.props.getProperty(String.valueOf(this.propsPrefix) + PREFIX, "/");
        return true;
    }

    public static String ocfResponse(String string, String string2, String string3) throws IOException {
        Object object;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = "<html><title>Solaris Smart Card Project</title>\n";
        if (string2 == null || string2.equals("") || string2.equals("/")) {
            string7 = String.valueOf(string7) + "<body>OCF</body>\n";
            return string7;
        }
        int n = string2.indexOf(47, 1);
        string4 = string2.substring(1, n);
        int n2 = string2.indexOf(47, n + 1);
        if (n2 < 0) {
            string7 = String.valueOf(string7) + "<body>No Card Service Provided</body>\n";
            return string7;
        }
        string5 = string2.substring(n + 1, n2);
        if (n2 >= string2.length()) {
            string7 = String.valueOf(string7) + "<body>No Card Method Provided</body>\n";
            return string7;
        }
        string6 = string2.substring(n2 + 1);
        Vector<OCFParameters> vector = new Vector<OCFParameters>();
        if (string3 != null) {
            object = new StringTokenizer(string3, "&");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string8 = ((StringTokenizer)object).nextToken();
                int n3 = string8.indexOf(61);
                if (n3 == -1) break;
                String string9 = string8.substring(0, n3);
                String string10 = string8.substring(n3 + 1);
                string10 = string10.trim();
                OCFParameters oCFParameters = new OCFParameters(string9, string10, true);
                vector.addElement(oCFParameters);
            }
        }
        string7 = String.valueOf(string7) + "<head>" + string4 + "/" + string5 + "/" + string6 + "</head>\n";
        object = OpenCardHandler.startOCFServer();
        if (((String)object).indexOf(OCFConstants.OCF_SUCCESS) == -1) {
            string7 = String.valueOf(string7) + "<body>" + (String)object + "</body>\n";
            return string7;
        }
        if (string4.equals("OCF")) {
            string7 = String.valueOf(string7) + "<body>" + dispatch.dispatchOCFService(string5, string6, string, vector) + "</body>\n";
        } else if (string4.equals("CardService")) {
            string7 = String.valueOf(string7) + "<body>" + dispatch.dispatchCardService(string5, string6, string, vector) + "</body>\n";
        } else if (string4.equals("Authenticate")) {
            string7 = String.valueOf(string7) + "<body>" + dispatch.dispatchAuthenticateService(string5, string6, string, vector) + "</body>\n";
        }
        return string7;
    }

    public boolean respond(Request request) throws IOException {
        String string = new String(request.url);
        String string2 = new String(request.query);
        String string3 = OpenCardHandler.ocfResponse(OCFConstants.NO_UID_AVAILABLE, string, string2);
        request.sendResponse(string3);
        return true;
    }

    public static String respond(String string, String string2) throws IOException {
        int n = string2.indexOf(63);
        int n2 = string2.indexOf(47);
        int n3 = string2.indexOf("HTTP");
        String string3 = string2.substring(n2, n);
        String string4 = string2.substring(n + 1, n3);
        return OpenCardHandler.ocfResponse(string, string3, string4);
    }

    public static String startOCFServer() {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        if (!init) {
            OCFServer oCFServer = new OCFServer();
            try {
                OCFServer.initializeOCF();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                oCFReturnValues.setStatus(OCFConstants.OCF_EXCEPTION);
                oCFReturnValues.setMessage(exception.getMessage());
                return oCFReturnValues.getReturnValues();
            }
            dispatch = new OCFDispatcher();
            init = true;
        }
        return oCFReturnValues.getReturnValues();
    }
}

