/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.common;

import com.sun.opencard.utils.OCFUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class OCFDebug {
    private static String OCFDEBUG = "ocf.server.debugging";
    private static String OCFDEBUG_FILE = "ocf.server.debugging.filename";
    private static boolean _isOn = false;
    private static boolean _initialised = false;
    private static PrintStream _os = null;

    public static void debug(String string) throws Exception {
        if (!_initialised) {
            OCFDebug.init();
        }
        if (_isOn) {
            _os.print(string);
        }
    }

    public static void debugArray(Object[] objectArray) throws Exception {
        if (!_initialised) {
            OCFDebug.init();
        }
        if (_isOn) {
            int n = 0;
            while (n < objectArray.length) {
                _os.print(String.valueOf(String.valueOf(objectArray[n])) + " ");
                ++n;
            }
            _os.println("");
        }
    }

    public static void debugArrayln(Object[] objectArray) throws Exception {
        if (!_initialised) {
            OCFDebug.init();
        }
        if (_isOn) {
            int n = 0;
            while (n < objectArray.length) {
                _os.println("Array [" + n + "] : " + objectArray[n]);
                ++n;
            }
        }
    }

    public static void debugln(String string) throws Exception {
        if (!_initialised) {
            OCFDebug.init();
        }
        if (_isOn) {
            _os.println(string);
        }
    }

    protected static void init() throws Exception {
        if (!OCFUtils.getProperty(OCFDEBUG, "0").equals("0")) {
            _isOn = true;
        }
        if (_isOn) {
            _os = OCFDebug.openStream(OCFDEBUG_FILE, System.out);
        }
        _initialised = true;
    }

    protected static PrintStream openStream(String string, Object object) throws Exception {
        String string2 = null;
        PrintStream printStream = null;
        string2 = OCFUtils.getProperty(string, null);
        if (string2 == null) {
            if (object instanceof String) {
                File file = new File((String)object);
                if (file.exists() && !file.canWrite()) {
                    System.out.println("Cannot access debug log file: '" + (String)object + "'.  Using /dev/null");
                    printStream = new PrintStream(new FileOutputStream("/dev/null", true));
                    return printStream;
                }
                printStream = new PrintStream(new FileOutputStream((String)object, true));
            } else {
                printStream = new PrintStream((OutputStream)object);
            }
        } else {
            File file = new File(string2);
            if (file.exists() && !file.canWrite()) {
                System.out.println("Cannot access debug log file: '" + string2 + "'.  Using /dev/null");
                printStream = new PrintStream(new FileOutputStream("/dev/null", true));
                return printStream;
            }
            printStream = new PrintStream(new FileOutputStream(string2, true));
        }
        return printStream;
    }
}

