/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.fsmgr.common;

import com.sun.wbem.solarisprovider.fsmgr.common.FsMgrAccessListOption;
import com.sun.wbem.solarisprovider.fsmgr.common.FsMgrBooleanOption;
import com.sun.wbem.solarisprovider.fsmgr.common.FsMgrIntegerOption;
import com.sun.wbem.solarisprovider.fsmgr.share.FsMgrShareData;

public class FsMgrSecurityOption
implements Cloneable {
    private static final String EMPTY_STRING = new String("");
    private static final String SEC = new String("sec");
    private static final String EQUALS = new String("=");
    private static final String COMMA = new String(",");
    private boolean enabled;
    private String optionName;
    private FsMgrBooleanOption rw = null;
    private FsMgrBooleanOption ro = null;
    private FsMgrAccessListOption rwList = null;
    private FsMgrAccessListOption roList = null;
    private FsMgrAccessListOption rootList = null;
    private FsMgrIntegerOption window = null;
    public static final String RW = FsMgrShareData.RW;
    public static final String RO = FsMgrShareData.RO;
    public static final String ROLIST = FsMgrShareData.ROLIST;
    public static final String RWLIST = FsMgrShareData.RWLIST;
    public static final String ROOT = FsMgrShareData.ROOT;
    public static final String ROOTLIST = FsMgrShareData.ROOT;
    public static final String WINDOW = FsMgrShareData.WINDOW;
    private static final boolean RW_DEFAULT = true;
    private static final boolean RO_DEFAULT = false;
    private static final int WINDOW_DEFAULT = 30000;
    private String accessListKing = null;

    public FsMgrSecurityOption(String string) {
        this.optionName = string;
    }

    public Object clone() {
        try {
            FsMgrSecurityOption fsMgrSecurityOption = (FsMgrSecurityOption)super.clone();
            if (this.rw != null) {
                fsMgrSecurityOption.rw = (FsMgrBooleanOption)this.rw.clone();
            }
            if (this.ro != null) {
                fsMgrSecurityOption.ro = (FsMgrBooleanOption)this.ro.clone();
            }
            if (this.rwList != null) {
                fsMgrSecurityOption.rwList = (FsMgrAccessListOption)this.rwList.clone();
            }
            if (this.roList != null) {
                fsMgrSecurityOption.roList = (FsMgrAccessListOption)this.roList.clone();
            }
            if (this.rootList != null) {
                fsMgrSecurityOption.rootList = (FsMgrAccessListOption)this.rootList.clone();
            }
            if (this.window != null) {
                fsMgrSecurityOption.window = (FsMgrIntegerOption)this.window.clone();
            }
            return fsMgrSecurityOption;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }

    public boolean equalAttributes(FsMgrBooleanOption fsMgrBooleanOption, FsMgrBooleanOption fsMgrBooleanOption2, boolean bl) {
        if (fsMgrBooleanOption == null && fsMgrBooleanOption2 == null) {
            return true;
        }
        if (fsMgrBooleanOption == null || fsMgrBooleanOption2 == null) {
            if (fsMgrBooleanOption == null) {
                fsMgrBooleanOption = new FsMgrBooleanOption(fsMgrBooleanOption2.getOptionName(), bl);
            } else {
                fsMgrBooleanOption2 = new FsMgrBooleanOption(fsMgrBooleanOption.getOptionName(), bl);
            }
        }
        return this.equalAttributes(fsMgrBooleanOption, fsMgrBooleanOption2);
    }

    public boolean equalAttributes(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof String) {
            if (object2 instanceof String) {
                String string = (String)object;
                String string2 = (String)object2;
                return string.equals(string2);
            }
            return false;
        }
        if (object instanceof FsMgrBooleanOption) {
            if (object instanceof FsMgrBooleanOption) {
                FsMgrBooleanOption fsMgrBooleanOption = (FsMgrBooleanOption)object;
                FsMgrBooleanOption fsMgrBooleanOption2 = (FsMgrBooleanOption)object2;
                return fsMgrBooleanOption.equals(fsMgrBooleanOption2);
            }
            return false;
        }
        if (object instanceof FsMgrAccessListOption) {
            if (object instanceof FsMgrAccessListOption) {
                FsMgrAccessListOption fsMgrAccessListOption = (FsMgrAccessListOption)object;
                FsMgrAccessListOption fsMgrAccessListOption2 = (FsMgrAccessListOption)object2;
                return fsMgrAccessListOption.equals(fsMgrAccessListOption2);
            }
            return false;
        }
        if (object instanceof FsMgrIntegerOption) {
            if (object instanceof FsMgrIntegerOption) {
                FsMgrIntegerOption fsMgrIntegerOption = (FsMgrIntegerOption)object;
                FsMgrIntegerOption fsMgrIntegerOption2 = (FsMgrIntegerOption)object2;
                return fsMgrIntegerOption.equals(fsMgrIntegerOption2);
            }
            return false;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof FsMgrSecurityOption)) {
            return false;
        }
        FsMgrSecurityOption fsMgrSecurityOption = (FsMgrSecurityOption)object;
        String string = fsMgrSecurityOption.getOptionName();
        if (!this.equalAttributes(string, this.optionName)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption = (FsMgrBooleanOption)fsMgrSecurityOption.getOption(RW);
        if (!this.equalAttributes(fsMgrBooleanOption, this.rw, true)) {
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption2 = (FsMgrBooleanOption)fsMgrSecurityOption.getOption(RO);
        if (!this.equalAttributes(fsMgrBooleanOption2, this.ro, false)) {
            return false;
        }
        FsMgrAccessListOption fsMgrAccessListOption = (FsMgrAccessListOption)fsMgrSecurityOption.getOption(RWLIST);
        if (!this.equalAttributes(fsMgrAccessListOption, this.rwList)) {
            return false;
        }
        FsMgrAccessListOption fsMgrAccessListOption2 = (FsMgrAccessListOption)fsMgrSecurityOption.getOption(ROLIST);
        if (!this.equalAttributes(fsMgrAccessListOption2, this.roList)) {
            return false;
        }
        FsMgrAccessListOption fsMgrAccessListOption3 = (FsMgrAccessListOption)fsMgrSecurityOption.getOption(ROOTLIST);
        if (!this.equalAttributes(fsMgrAccessListOption3, this.rootList)) {
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption = (FsMgrIntegerOption)fsMgrSecurityOption.getOption(WINDOW);
        return this.equalAttributes(fsMgrIntegerOption, this.window);
    }

    public String getAccessListKing() {
        return this.accessListKing;
    }

    public Object getOption(String string) {
        Cloneable cloneable = null;
        if (string == RW) {
            cloneable = this.rw;
        } else if (string == RO) {
            cloneable = this.ro;
        } else if (string == RWLIST) {
            cloneable = this.rwList;
        } else if (string == ROLIST) {
            cloneable = this.roList;
        } else if (string == ROOTLIST) {
            cloneable = this.rootList;
        } else if (string == WINDOW) {
            cloneable = this.window;
        }
        return cloneable;
    }

    public String getOptionName() {
        return this.optionName;
    }

    private FsMgrBooleanOption getRo() {
        return this.ro;
    }

    private FsMgrAccessListOption getRoList() {
        return this.roList;
    }

    private FsMgrAccessListOption getRootList() {
        return this.rootList;
    }

    private FsMgrBooleanOption getRw() {
        return this.rw;
    }

    private FsMgrAccessListOption getRwList() {
        return this.rwList;
    }

    private FsMgrIntegerOption getWindow() {
        return this.window;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isGloballyRo() {
        boolean bl = this.ro != null && this.ro.getValue() ? true : (this.rw != null && this.rw.getValue() ? false : (this.rwList != null || this.roList != null ? false : false));
        return bl;
    }

    public boolean isGloballyRw() {
        boolean bl = this.rw != null && this.rw.getValue() ? true : (this.ro != null && this.ro.getValue() ? false : this.rwList == null && this.roList == null);
        return bl;
    }

    public boolean isRo() {
        boolean bl = this.rwList != null || this.roList != null ? false : (this.rw != null && this.rw.getValue() ? false : this.ro != null && this.ro.getValue());
        return bl;
    }

    public boolean isRw() {
        boolean bl = this.rwList != null || this.roList != null ? false : (this.ro != null && this.ro.getValue() ? false : (this.rw != null && this.rw.getValue() ? true : true));
        return bl;
    }

    public void setAccessListKing(String string) {
        if (!string.equals(ROLIST) && !string.equals(RWLIST)) {
            return;
        }
        this.accessListKing = string;
    }

    public void setOption(String string, FsMgrAccessListOption fsMgrAccessListOption) {
        if (string.equals(RW) || string.equals(RWLIST)) {
            this.rwList = fsMgrAccessListOption;
        } else if (string.equals(RO) || string.equals(ROLIST)) {
            this.roList = fsMgrAccessListOption;
        } else if (string.equals(ROOT) || string.equals(ROOTLIST)) {
            this.rootList = fsMgrAccessListOption;
        }
    }

    public void setOption(String string, String string2) {
        if (string.equals(RW)) {
            if (this.rwList == null) {
                this.rwList = new FsMgrAccessListOption(RW);
                if (this.getAccessListKing() == null) {
                    this.setAccessListKing(RWLIST);
                }
            }
            this.rwList.addToList(string2);
        } else if (string.equals(RO)) {
            if (this.roList == null) {
                this.roList = new FsMgrAccessListOption(RO);
                if (this.getAccessListKing() == null) {
                    this.setAccessListKing(ROLIST);
                }
            }
            this.roList.addToList(string2);
        } else if (string.equals(ROOT)) {
            if (this.rootList == null) {
                this.rootList = new FsMgrAccessListOption(ROOT);
            }
            this.rootList.addToList(string2);
        } else if (string.equals(WINDOW)) {
            if (this.window == null) {
                this.window = new FsMgrIntegerOption(WINDOW, string2);
            } else {
                this.window.setValue(string2);
            }
        }
    }

    public void setOption(String string, boolean bl) {
        if (string.equals(RW)) {
            if (this.rw == null) {
                this.rw = new FsMgrBooleanOption(RW, bl);
            } else {
                this.rw.setValue(bl);
            }
        } else if (string.equals(RO)) {
            if (this.ro == null) {
                this.ro = new FsMgrBooleanOption(RO, bl);
            } else {
                this.ro.setValue(bl);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        String string = null;
        stringBuffer.append(SEC);
        stringBuffer.append(EQUALS);
        stringBuffer.append(this.optionName);
        stringBuffer.append(COMMA);
        if (this.rw != null && this.rw.getValue()) {
            stringBuffer.append(this.rw.toString());
            stringBuffer.append(COMMA);
        }
        if (this.ro != null && this.ro.getValue()) {
            stringBuffer.append(this.ro.toString());
            stringBuffer.append(COMMA);
        }
        if (this.accessListKing == null || this.accessListKing.equals(RWLIST)) {
            if (this.rwList != null && (string = this.rwList.toString()).length() != 0) {
                stringBuffer.append(string);
                stringBuffer.append(COMMA);
            }
            if (this.roList != null && (string = this.roList.toString()).length() != 0) {
                stringBuffer.append(string);
                stringBuffer.append(COMMA);
            }
        } else {
            if (this.roList != null && (string = this.roList.toString()).length() != 0) {
                stringBuffer.append(string);
                stringBuffer.append(COMMA);
            }
            if (this.rwList != null && (string = this.rwList.toString()).length() != 0) {
                stringBuffer.append(string);
                stringBuffer.append(COMMA);
            }
        }
        if (this.rootList != null && (string = this.rootList.toString()).length() != 0) {
            stringBuffer.append(string);
            stringBuffer.append(COMMA);
        }
        if (this.window != null && (string = this.window.toString()).length() != 0) {
            stringBuffer.append(this.window.toString());
            stringBuffer.append(COMMA);
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public void verify() {
        boolean bl = this.rw != null && this.rw.getValue() && this.rwList != null;
        boolean bl2 = this.ro != null && this.ro.getValue() && this.roList != null;
    }
}

