/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.gui.supplemental.plugins.terminal;

import com.sun.smartcard.gui.client.plugin.PluginButton;
import com.sun.smartcard.gui.client.plugin.PluginCheckBox;
import com.sun.smartcard.gui.client.plugin.PluginComboBox;
import com.sun.smartcard.gui.client.plugin.PluginPassword;
import com.sun.smartcard.gui.client.plugin.PluginSlider;
import com.sun.smartcard.gui.client.plugin.PluginTab;
import com.sun.smartcard.gui.client.plugin.PluginTextField;
import com.sun.smartcard.gui.client.plugin.ScTerminalPropertyFormatException;
import com.sun.smartcard.gui.client.plugin.SmartCardPlugin;
import com.sun.smartcard.gui.client.plugin.TerminalPluginGuiCtx;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class SCMI2cTerminalPlugin
implements SmartCardPlugin {
    private PluginTextField tfFactory;
    private String tfFactoryDefault;
    private PluginTextField tfName;
    private String tfnameDefault;
    private PluginTextField tfModel;
    private String tfModelDefault;
    private boolean modelMutable;
    private PluginTextField tfPort;
    private PluginComboBox cbPort;
    private String tfPortDefault;
    private boolean portTypeInternal;
    private boolean anyPortOK;
    private String internalDevDirectory = "/dev";
    private TerminalPluginGuiCtx pgc;
    private boolean unsavedChanges = false;
    private boolean active = false;
    private boolean activeDefault = false;
    private boolean addNewTerminal = false;
    private boolean singleListOnly = true;
    private boolean debug = System.getProperty("debug") != null;
    private Properties defaultTerminalProperties;

    public SCMI2cTerminalPlugin(Properties p) {
        this(p, null);
    }

    public SCMI2cTerminalPlugin(Properties p, TerminalPluginGuiCtx guicontext) {
        this.pgc = guicontext;
        this.pgc.setCallback((SmartCardPlugin)this);
        this.defaultTerminalProperties = p;
        if (this.debug) {
            System.out.println("\n======= SCMI2cTerminalPlugin =========");
        }
        Properties cfgProps = this.pgc.getCfg();
        if (this.debug) {
            System.out.println("cfgProps: [" + ((Hashtable)cfgProps).toString() + "]");
        }
        if (this.debug) {
            if (p != null) {
                System.out.println("SCMI2cTerminalPlugin: properties exist: [" + ((Hashtable)p).toString() + "]");
            } else {
                System.out.println("SCMI2cTerminalPlugin:  no properties passed");
            }
        }
        if (p != null && p.getProperty("active") != null || cfgProps.getProperty("active") != null) {
            this.activeDefault = true;
            this.active = true;
        }
        if (p != null) {
            this.setDefaultsFromProperties(p);
        } else {
            this.setDefaultsFromProperties(cfgProps);
            this.addNewTerminal = true;
        }
        if (this.debug) {
            System.out.println("\nSCMI2cTerminalPlugin:  addNewTerminal = [" + this.addNewTerminal + "] " + " active = [" + this.active + "] " + " activeDefault = [" + this.activeDefault + "]");
        }
        this.portTypeInternal = false;
        if (cfgProps.getProperty("porttype", "any").equals("internal")) {
            this.portTypeInternal = true;
            this.internalDevDirectory = cfgProps.getProperty("internaldevdirectory", this.internalDevDirectory);
        }
        this.modelMutable = cfgProps.getProperty("modelmutable", "false").equals("false") ^ true;
        this.anyPortOK = cfgProps.getProperty("anyportok", "true").equals("true");
        PluginTab tab1 = this.pgc.addTab("Basic Configuration");
        this.tfName = tab1.addTextField("Unique Card Terminal Name");
        this.tfName.setText(this.tfnameDefault);
        this.tfModel = tab1.addTextField("Model Name");
        this.tfModel.setText(this.tfModelDefault);
        this.tfModel.setEditable(this.modelMutable);
        if (this.portTypeInternal) {
            Enumeration internalDevs = this.getInternalDeviceNames(this.internalDevDirectory);
            if (internalDevs != null) {
                this.cbPort = tab1.addComboBox("Device Port", this.anyPortOK);
                while (internalDevs.hasMoreElements()) {
                    this.cbPort.addEntry((String)internalDevs.nextElement());
                }
                this.cbPort.setSelectedItem((Object)this.tfPortDefault);
            } else {
                this.portTypeInternal = false;
            }
        }
        if (!this.portTypeInternal) {
            this.tfPort = tab1.addTextField("Device Port");
            this.tfPort.setText(this.tfPortDefault);
        }
        PluginTab tab2 = this.pgc.addTab("Advanced Configuration");
        this.tfFactory = tab2.addTextField("Card Terminal Factory");
        this.tfFactory.setText(this.tfFactoryDefault);
    }

    public void activeState(boolean state) {
    }

    public void buttonAction(PluginButton b) {
    }

    public boolean cancelOperation() {
        if (this.debug) {
            System.out.println("SCMI2cTerminalPlugin.cancelOperation");
        }
        this.checkUnsavedChanges();
        if (this.unsavedChanges) {
            String ync = this.pgc.popupQuestion("Unsaved Changes", "You have unsaved changes - do you want to cancel?");
            if (this.debug) {
                System.out.println("SCMI2cTerminalPlugin.cancelOperation: ync = [" + ync + "]");
            }
            if (!ync.equals("YES")) {
                return false;
            }
        }
        return true;
    }

    public void checkBoxAction(PluginCheckBox cb) {
    }

    public boolean checkTerminalName(String terminalName) {
        this.pgc.enableBusyCursor();
        boolean onActiveList = this.pgc.activeTerminalExists(terminalName);
        boolean onInactiveList = this.pgc.inactiveTerminalExists(terminalName);
        boolean nameChanged = terminalName.equals(this.tfnameDefault) ^ true;
        this.pgc.disableBusyCursor();
        boolean dupOnActive = false;
        boolean dupOnInactive = false;
        if (this.addNewTerminal || nameChanged) {
            if (onActiveList) {
                dupOnActive = true;
            }
            if (onInactiveList) {
                dupOnInactive = true;
            }
        } else if (this.active != this.activeDefault) {
            if (this.active && onActiveList) {
                dupOnActive = true;
            }
            if (!this.active && onInactiveList) {
                dupOnInactive = true;
            }
        }
        if (dupOnActive || dupOnInactive) {
            String conflictList = dupOnActive ? "ACTIVE" : "INACTIVE";
            this.pgc.popupError("Duplicate Name", "This terminal name: [" + terminalName + "] already exists on the " + conflictList + " list");
            return false;
        }
        return true;
    }

    public boolean checkTerminalPort(String terminalName) {
        this.pgc.enableBusyCursor();
        boolean onActiveList = this.pgc.activeTerminalExists(this.tfnameDefault);
        this.pgc.disableBusyCursor();
        if (terminalName != this.tfnameDefault && onActiveList) {
            this.pgc.popupError("Duplicate Port", "This terminal port: [/dev/scmi2c0] already exists on the  ACTIVE list");
            return false;
        }
        return true;
    }

    public void checkUnsavedChanges() {
        String terminalFactory = this.tfFactory.getText();
        String terminalName = this.tfName.getText();
        String terminalModel = this.tfModel.getText();
        String terminalPort = this.portTypeInternal ? this.cbPort.getSelectedEntry() : this.tfPort.getText();
        Properties ap = new Properties();
        ap.setProperty("factory", terminalFactory);
        ap.setProperty("name", terminalName);
        ap.setProperty("model", terminalModel);
        ap.setProperty("port", terminalPort);
        this.checkUnsavedChanges(ap);
    }

    public void checkUnsavedChanges(Properties ap) {
        String terminalFactory = ap.getProperty("factory");
        String terminalName = ap.getProperty("name");
        String terminalModel = ap.getProperty("model");
        String terminalPort = ap.getProperty("port");
        this.unsavedChanges = !terminalFactory.equals(this.tfFactoryDefault) || !terminalName.equals(this.tfnameDefault) || !terminalModel.equals(this.tfModelDefault) || !terminalPort.equals(this.tfPortDefault);
        if (this.active != this.activeDefault) {
            this.unsavedChanges = true;
        }
        if (this.addNewTerminal) {
            this.unsavedChanges = true;
        }
        if (this.debug) {
            System.out.println("SCMI2cTerminalPlugin.checkUnsavedChanges: unsavedChanges = " + this.unsavedChanges);
        }
    }

    public void comboAction(PluginComboBox cb) {
    }

    private Enumeration getInternalDeviceNames(String devDir) {
        File devDirFile = new File(devDir);
        File[] devFiles = devDirFile.listFiles();
        if (devFiles == null) {
            return null;
        }
        Vector<String> devNames = new Vector<String>();
        int fn = 0;
        while (fn < devFiles.length) {
            if (this.debug) {
                System.out.println("getPath(): [" + devFiles[fn].getPath() + "] \n" + " isFile(): [" + devFiles[fn].isFile() + "]");
            }
            if (!devFiles[fn].isFile() && !devFiles[fn].isDirectory() && !devFiles[fn].isHidden() && devFiles[fn].getName().equals("scmi2c0")) {
                devNames.add(devFiles[fn].getPath());
            }
            ++fn;
        }
        if (devNames.isEmpty()) {
            return null;
        }
        return devNames.elements();
    }

    public Properties okButtonPushed(boolean activeState) {
        this.pgc.enableBusyCursor();
        this.active = activeState;
        String terminalName = this.tfName.getText();
        String terminalModel = this.tfModel.getText();
        String terminalPort = this.portTypeInternal ? this.cbPort.getSelectedEntry() : this.tfPort.getText();
        String terminalFactory = this.tfFactory.getText();
        Properties ap = new Properties();
        ap.setProperty("name", terminalName);
        ap.setProperty("model", terminalModel);
        ap.setProperty("port", terminalPort);
        ap.setProperty("factory", terminalFactory);
        this.checkUnsavedChanges(ap);
        if (this.debug) {
            System.out.println("OK Button pushed.          name: [" + terminalName + "]\n" + "         model: [" + terminalModel + "]\n" + "          port: [" + terminalPort + "]\n" + "       factory: [" + terminalFactory + "]\n" + "        active: [" + this.active + "]\n" + "unsavedChanges: [" + this.unsavedChanges + "]\n" + "addNewTerminal: [" + this.addNewTerminal + "]\n" + "        active: [" + this.active + "]\n" + " activeDefault: [" + this.activeDefault + "]\n" + "unsavedChanges: [" + this.unsavedChanges + "]");
        }
        if (!this.unsavedChanges) {
            this.pgc.disableBusyCursor();
            return ap;
        }
        try {
            this.pgc.checkTerminalPropertyFormat(ap);
        }
        catch (ScTerminalPropertyFormatException stpfe) {
            this.pgc.disableBusyCursor();
            this.pgc.popupError("Error in Terminal Properties", stpfe.getMessage());
            return null;
        }
        if (!this.checkTerminalName(terminalName)) {
            return null;
        }
        if (!this.checkTerminalPort(terminalName)) {
            return null;
        }
        if (!this.addNewTerminal) {
            this.pgc.removeTerminal(this.tfnameDefault, this.activeDefault);
        }
        try {
            this.pgc.addTerminal(ap, this.active);
        }
        catch (ScTerminalPropertyFormatException stpfe) {
            this.pgc.disableBusyCursor();
            this.pgc.popupWarning("Terminal Property Format Error", stpfe.getMessage());
            if (!this.addNewTerminal) {
                try {
                    this.pgc.enableBusyCursor();
                    this.pgc.addTerminal(this.defaultTerminalProperties, this.activeDefault);
                }
                catch (ScTerminalPropertyFormatException stpfe2) {
                    this.pgc.disableBusyCursor();
                    this.pgc.popupError("Can't Recover Previous Terminal State", stpfe2.getMessage());
                }
            }
            this.pgc.disableBusyCursor();
            return null;
        }
        this.activeDefault = this.active;
        this.addNewTerminal = false;
        this.setDefaultsFromProperties(ap);
        this.pgc.disableBusyCursor();
        return ap;
    }

    public void passwordAction(PluginPassword pp) {
    }

    public void setDefaultsFromProperties(Properties p) {
        this.tfFactoryDefault = p.getProperty("factory");
        this.tfnameDefault = p.getProperty("name");
        this.tfModelDefault = p.getProperty("model");
        this.tfPortDefault = p.getProperty("port");
    }

    public void sliderAction(PluginSlider sl) {
    }

    public void textAction(PluginTextField tf) {
    }

    public void toggleButtonAction(boolean toggleButtonState) {
    }
}

