/*
 * Decompiled with CFR 0.152.
 */
package com.scmmicro.smartos.physical;

import com.scmmicro.smartos.exceptions.BadParameterException;
import com.scmmicro.smartos.exceptions.BadParameterValueException;
import com.scmmicro.smartos.exceptions.CardException;
import com.scmmicro.smartos.exceptions.CommunicationException;
import com.scmmicro.smartos.exceptions.TimeOutException;
import com.scmmicro.smartos.physical.Drive;
import com.scmmicro.smartos.physical.DriveListener;
import com.scmmicro.smartos.util.Buffer;
import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.terminal.scm.SCMI2c.I2CCardMovementListener;
import com.sun.opencard.terminal.scm.SCMI2c.I2CDeviceAccessException;
import com.sun.opencard.terminal.scm.SCMI2c.I2CErrorException;
import com.sun.opencard.terminal.scm.SCMI2c.I2CIllegalRegisterException;
import com.sun.opencard.terminal.scm.SCMI2c.I2CMappingLayer;
import com.sun.opencard.terminal.scm.SCMI2c.I2CNoCardException;
import com.sun.opencard.terminal.scm.SCMI2c.I2CShortCircuitException;
import com.sun.opencard.terminal.scm.SCMI2c.I2CTimeoutException;

public class I2CDrive
extends Drive
implements I2CCardMovementListener {
    boolean verbose = false;
    I2CMappingLayer m_rI2CMappingLayer = null;
    DriveListener m_rDriveListener = null;
    byte CardState = 0;
    private static final int UART_CONTROL = 15;
    private static final int UART_CONTROL_UEN = 64;
    private static final int UART_CONTROL_RST = 32;
    private static final int UART_CONTROL_CONV = 16;
    private static final int UART_CONTROL_TS = 8;
    private static final int UART_CONTROL_PE = 4;
    private static final int UART_CONTROL_RESEND = 3;

    public I2CDrive() {
        this.debug("Start I2CDrive ...");
    }

    private synchronized void InitUART(long l) throws CommunicationException, CardException, BadParameterException, TimeOutException {
        try {
            long l2 = 32L;
            this.m_rI2CMappingLayer.writeRegister(15, l2);
            l2 = l == 0L ? 71L : 79L;
            this.m_rI2CMappingLayer.writeRegister(15, l2);
        }
        catch (Exception exception) {
            throw new CommunicationException(exception.toString());
        }
    }

    public synchronized void cardMovement(boolean bl) {
        byte by = 0;
        if (bl) {
            by = -96;
            this.CardState = 1;
            this.debug("card inserted 0xA0");
        } else {
            by = -95;
            this.CardState = 0;
            this.debug("card removed 0xA1");
        }
        this.m_rDriveListener.cardMovement(by);
    }

    public void close() throws CommunicationException {
        this.m_rI2CMappingLayer = null;
        this.debug("Reader CLOSE OK");
    }

    void debug(String string) {
        if (!this.verbose) {
            System.out.println("I2CDrive : " + string);
        } else {
            try {
                OCFDebug.debugln((String)("I2CDrive:: " + string));
            }
            catch (Exception exception) {}
        }
    }

    DriveListener getListener() {
        return this.m_rDriveListener;
    }

    public int getNumReceived() throws CommunicationException, CardException {
        int n;
        try {
            n = this.m_rI2CMappingLayer.getNumReceived();
        }
        catch (I2CErrorException i2CErrorException) {
            throw new CardException();
        }
        catch (I2CDeviceAccessException i2CDeviceAccessException) {
            throw new CommunicationException();
        }
        return n;
    }

    public synchronized long getParameter(byte by) throws CommunicationException, CardException, BadParameterException, TimeOutException {
        int n;
        long l = super.getParameter(by);
        if (l > 0L) {
            return l;
        }
        if (this.m_rI2CMappingLayer == null) {
            throw new CommunicationException("no Connection is openned");
        }
        switch (by) {
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 8;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 10;
                break;
            }
            case 14: {
                this.debug(" GetCardState :" + this.CardState);
                return this.CardState;
            }
            case 31: {
                return 5L;
            }
            case 17: {
                n = 0;
                break;
            }
            case 29: {
                try {
                    this.m_rI2CMappingLayer.checkShortCircuit();
                    return 0L;
                }
                catch (I2CErrorException i2CErrorException) {
                    throw new CommunicationException();
                }
                catch (I2CShortCircuitException i2CShortCircuitException) {
                    throw new CommunicationException();
                }
                catch (I2CDeviceAccessException i2CDeviceAccessException) {
                    throw new CommunicationException();
                }
            }
            default: {
                throw new BadParameterException();
            }
        }
        try {
            l = this.m_rI2CMappingLayer.readRegister(n);
        }
        catch (I2CIllegalRegisterException i2CIllegalRegisterException) {
            throw new CommunicationException();
        }
        catch (I2CErrorException i2CErrorException) {
            throw new CommunicationException();
        }
        catch (I2CDeviceAccessException i2CDeviceAccessException) {
            throw new CommunicationException();
        }
        return l;
    }

    public void open() throws CommunicationException {
        if (this.m_rI2CMappingLayer == null) {
            try {
                this.debug("Try to Open I2CDriver on " + this.DriverAddress);
                this.m_rI2CMappingLayer = new I2CMappingLayer(this.DriverAddress, (I2CCardMovementListener)this);
                this.debug("I2CDriver Opened");
            }
            catch (I2CDeviceAccessException i2CDeviceAccessException) {
                this.debug("I2CDriver I2CDeviceAccessException");
                throw new CommunicationException();
            }
            catch (I2CErrorException i2CErrorException) {
                this.debug("I2CErrorException Opened");
                throw new CommunicationException();
            }
            catch (Exception exception) {
                this.debug("What's the problem !!!  (exception) = " + exception.toString());
                throw new CommunicationException();
            }
            this.debug("I2CDriver Opened");
        }
    }

    public synchronized void receiveBlock(Buffer buffer) throws CommunicationException, CardException, TimeOutException {
        byte[] byArray = new byte[buffer.getCapacity()];
        try {
            int n = this.m_rI2CMappingLayer.receiveBlock(byArray);
        }
        catch (I2CNoCardException i2CNoCardException) {
            try {
                OCFDebug.debugln((String)"I2CDrive:: receiveBlock I2CNoCardException");
            }
            catch (Exception exception) {}
            throw new CardException();
        }
        catch (I2CTimeoutException i2CTimeoutException) {
            try {
                OCFDebug.debugln((String)"I2CDrive:: receiveBlock I2CTimeoutException");
            }
            catch (Exception exception) {}
            throw new TimeOutException();
        }
        catch (I2CErrorException i2CErrorException) {
            try {
                OCFDebug.debugln((String)"I2CDrive:: receiveBlock I2CErrorException");
            }
            catch (Exception exception) {}
            throw new CommunicationException();
        }
        catch (I2CDeviceAccessException i2CDeviceAccessException) {
            try {
                OCFDebug.debugln((String)"I2CDrive:: receiveBlock I2CDeviceAccessException");
            }
            catch (Exception exception) {}
            throw new CommunicationException();
        }
        buffer.setData(byArray);
    }

    public synchronized void sendBlock(Buffer buffer) throws CommunicationException, CardException, TimeOutException {
        int n;
        byte[] byArray = new byte[buffer.getLength()];
        System.arraycopy(buffer.getData(), 0, byArray, 0, byArray.length);
        if (!this.verbose) {
            n = byArray.length;
            System.out.println("I2CDrive:: sendBlock: sending " + n + " bytes:");
            int n2 = 0;
            while (n2 < n) {
                System.out.print(String.valueOf(Integer.toHexString(0xFF & byArray[n2])) + " ");
                System.out.println("\ndone\n");
                ++n2;
            }
        } else {
            n = byArray.length;
            try {
                OCFDebug.debugln((String)("I2CDrive:sendBlock: sending " + n + " bytes:"));
            }
            catch (Exception exception) {}
            int n3 = 0;
            while (n3 < n) {
                try {
                    OCFDebug.debugln((String)(String.valueOf(Integer.toHexString(0xFF & byArray[n3])) + " "));
                }
                catch (Exception exception) {}
                ++n3;
            }
        }
        try {
            n = this.m_rI2CMappingLayer.sendBlock(byArray);
            if (n != buffer.getLength()) {
                if (!this.verbose) {
                    System.out.println("I2CDrive:: sendBlock:actually sent " + n + " bytes");
                } else {
                    try {
                        OCFDebug.debugln((String)("I2CDrive:: SendBlock: Only sent " + n + " bytes"));
                    }
                    catch (Exception exception) {}
                }
                throw new CommunicationException();
            }
            if (!this.verbose) {
                System.out.println("I2CDrive:: sendBlock:Sent " + n + " bytes");
            } else {
                try {
                    OCFDebug.debugln((String)("I2CDrive:: SendBlock: Sent " + n + " bytes"));
                }
                catch (Exception exception) {}
            }
        }
        catch (I2CNoCardException i2CNoCardException) {
            if (!this.verbose) {
                System.out.println("I2CDrive:sendBlock:I2CNoCardException");
            } else {
                try {
                    OCFDebug.debugln((String)"I2CDrive:: sendBlock: I2CNoCardException");
                }
                catch (Exception exception) {}
            }
            throw new CardException();
        }
        catch (I2CTimeoutException i2CTimeoutException) {
            if (!this.verbose) {
                System.out.println("I2CDrive:sendBlock:I2CTimeoutException");
            } else {
                try {
                    OCFDebug.debugln((String)"I2CDrive:: sendBlock:I2CTimeoutException");
                }
                catch (Exception exception) {}
            }
            throw new TimeOutException();
        }
        catch (I2CErrorException i2CErrorException) {
            if (!this.verbose) {
                System.out.println("I2CDrive:sendBlock:I2CErrorException");
            } else {
                try {
                    OCFDebug.debugln((String)"I2CDrive:: sendBlock:I2CErrorException");
                }
                catch (Exception exception) {}
            }
            throw new CommunicationException();
        }
        catch (I2CDeviceAccessException i2CDeviceAccessException) {
            if (!this.verbose) {
                System.out.println("I2CDrive:sendBlock:I2CDeviceAccessException");
            } else {
                try {
                    OCFDebug.debugln((String)"I2CDrive:: sendBlock:I2CDeviceAccessException");
                }
                catch (Exception exception) {}
            }
            throw new CommunicationException();
        }
        catch (Exception exception) {
            if (!this.verbose) {
                System.out.println("Exception:" + exception);
            } else {
                try {
                    OCFDebug.debugln((String)("I2CDrive:: sendBlock:Exception" + exception));
                }
                catch (Exception exception2) {}
            }
            throw new CommunicationException();
        }
    }

    public void setListener(DriveListener driveListener) throws CommunicationException {
        this.m_rDriveListener = driveListener;
        this.debug("Set Listener on I2CDriver ");
        this.open();
        this.debug("Done ...");
    }

    public synchronized void setParameter(byte by, long l) throws CommunicationException, CardException, BadParameterException, BadParameterValueException, TimeOutException {
        int n;
        super.setParameter(by, l);
        if (this.m_rI2CMappingLayer == null) {
            throw new CommunicationException("no Connection is openned");
        }
        switch (by) {
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 8;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 10;
                break;
            }
            case 17: {
                n = 0;
                break;
            }
            case 22: {
                try {
                    this.m_rI2CMappingLayer.cardPowerManagement((int)l);
                }
                catch (I2CDeviceAccessException i2CDeviceAccessException) {
                    throw new CardException();
                }
                catch (I2CErrorException i2CErrorException) {
                    throw new CommunicationException();
                }
                return;
            }
            case 15: {
                try {
                    this.debug("setParam:PLP_RECEPTIME value = " + l + "mS");
                    this.m_rI2CMappingLayer.setReceiveTimeout((int)l);
                }
                catch (I2CDeviceAccessException i2CDeviceAccessException) {
                    throw new CommunicationException(i2CDeviceAccessException.toString());
                }
                catch (I2CErrorException i2CErrorException) {
                    throw new CommunicationException(i2CErrorException.toString());
                }
                return;
            }
            case 16: {
                try {
                    this.debug("setParam:PLP_TRANSMITTIME value = " + l + "mS");
                    this.m_rI2CMappingLayer.setSendTimeout((int)l);
                }
                catch (I2CDeviceAccessException i2CDeviceAccessException) {
                    throw new CommunicationException(i2CDeviceAccessException.toString());
                }
                catch (I2CErrorException i2CErrorException) {
                    throw new CommunicationException(i2CErrorException.toString());
                }
                return;
            }
            case 30: {
                try {
                    this.debug("setParam:PLP_TS_TIMEOUT m_nTsTimeout = " + this.m_nTsTimeout + "mS");
                    this.m_rI2CMappingLayer.setReceiveTimeout((int)l);
                }
                catch (I2CDeviceAccessException i2CDeviceAccessException) {
                    throw new CommunicationException(i2CDeviceAccessException.toString());
                }
                catch (I2CErrorException i2CErrorException) {
                    throw new CommunicationException(i2CErrorException.toString());
                }
                return;
            }
            case 26: {
                this.InitUART(l);
                return;
            }
            default: {
                throw new BadParameterException();
            }
        }
        try {
            this.m_rI2CMappingLayer.writeRegister(n, (long)((int)l));
        }
        catch (I2CIllegalRegisterException i2CIllegalRegisterException) {
            throw new CommunicationException();
        }
        catch (I2CErrorException i2CErrorException) {
            throw new CommunicationException();
        }
        catch (I2CDeviceAccessException i2CDeviceAccessException) {
            throw new CommunicationException();
        }
    }
}

