/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard;

import com.sun.smartcard.AIDSpec;
import com.sun.smartcard.Card;
import com.sun.smartcard.CardSpec;
import com.sun.smartcard.OCFClientSocket;
import com.sun.smartcard.OCFDecoder;
import com.sun.smartcard.OCFEncoder;
import com.sun.smartcard.ReaderSpec;
import com.sun.smartcard.Smartcard;
import com.sun.smartcard.SmartcardCardLockedException;
import com.sun.smartcard.SmartcardCardUnlockedException;
import com.sun.smartcard.SmartcardException;
import com.sun.smartcard.SmartcardVerifyErrorException;
import com.sun.smartcard.TimeoutSpec;
import java.util.Vector;

public class PinCardService {
    OCFClientSocket server = new OCFClientSocket();
    Card card;

    public PinCardService(Card card) throws SmartcardException {
        this.card = card;
    }

    public void changePin(String string, String string2) throws Exception {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.card.getClientHandle()));
        vector.add(new Long(this.card.getCardHandle()));
        vector.add(string);
        vector.add(string2);
        String string3 = OCFEncoder.encode(vector);
        String string4 = this.server.serverResponse("CardService", "PinCardService", "changePin", string3);
        OCFDecoder.decode(string4);
    }

    public boolean isLocked() throws Exception {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.card.getClientHandle()));
        vector.add(new Long(this.card.getCardHandle()));
        String string = OCFEncoder.encode(vector);
        String string2 = this.server.serverResponse("CardService", "PinCardService", "isLocked", string);
        try {
            OCFDecoder.decode(string2);
        }
        catch (SmartcardCardLockedException smartcardCardLockedException) {
            return true;
        }
        catch (SmartcardCardUnlockedException smartcardCardUnlockedException) {
            return false;
        }
        return false;
    }

    public void lock() throws Exception {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.card.getClientHandle()));
        vector.add(new Long(this.card.getCardHandle()));
        String string = OCFEncoder.encode(vector);
        String string2 = this.server.serverResponse("CardService", "PinCardService", "lock", string);
        OCFDecoder.decode(string2);
    }

    public static void main(String[] stringArray) {
        Smartcard smartcard = null;
        try {
            smartcard = new Smartcard("client1");
            Card card = smartcard.waitForCardInserted(new CardSpec(), new ReaderSpec(), new AIDSpec(), new TimeoutSpec());
            System.out.println("Card inserted: " + card);
            PinCardService pinCardService = (PinCardService)card.getCardService("com.sun.smartcard.PinCardService");
            if (pinCardService.validatePin("$$$$java")) {
                System.out.println("Valid Pin");
            }
            System.out.println("Is Card Locked ? " + pinCardService.isLocked());
            if (pinCardService.validateAndUnlock("$$$$java")) {
                System.out.println("Unlocked card");
            }
            System.out.println("Is Card Locked ? " + pinCardService.isLocked());
            try {
                pinCardService.lock();
            }
            catch (SmartcardCardLockedException smartcardCardLockedException) {
                System.out.println("Card Already Locked!");
            }
            System.out.println("Is Card Locked ? " + pinCardService.isLocked());
            pinCardService.changePin("$$$$java", "12345678");
            if (pinCardService.validatePin("$$$$java")) {
                System.out.println("Valid Pin");
            } else {
                System.out.println("Invalid Pin");
            }
            pinCardService.changePin("12345678", "$$$$java");
            if (pinCardService.validateAndUnlock("$$$$java")) {
                System.out.println("Unlocked card");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (smartcard != null) {
            smartcard.cleanup();
        }
    }

    public boolean validateAndUnlock(String string) throws Exception {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.card.getClientHandle()));
        vector.add(new Long(this.card.getCardHandle()));
        vector.add(string);
        String string2 = OCFEncoder.encode(vector);
        String string3 = this.server.serverResponse("CardService", "PinCardService", "validateAndUnlock", string2);
        try {
            OCFDecoder.decode(string3);
        }
        catch (SmartcardVerifyErrorException smartcardVerifyErrorException) {
            return false;
        }
        return true;
    }

    public boolean validatePin(String string) throws Exception {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.card.getClientHandle()));
        vector.add(new Long(this.card.getCardHandle()));
        vector.add(string);
        String string2 = OCFEncoder.encode(vector);
        String string3 = this.server.serverResponse("CardService", "PinCardService", "validatePin", string2);
        try {
            OCFDecoder.decode(string3);
        }
        catch (SmartcardVerifyErrorException smartcardVerifyErrorException) {
            return false;
        }
        return true;
    }
}

