/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard;

import com.sun.smartcard.AIDSpec;
import com.sun.smartcard.Card;
import com.sun.smartcard.CardSpec;
import com.sun.smartcard.OCFClientSocket;
import com.sun.smartcard.OCFDecoder;
import com.sun.smartcard.OCFEncoder;
import com.sun.smartcard.ReaderSpec;
import com.sun.smartcard.Smartcard;
import com.sun.smartcard.SmartcardException;
import com.sun.smartcard.TimeoutSpec;
import java.util.Vector;

public class PassThruCardService {
    OCFClientSocket server = new OCFClientSocket();
    Card card;

    public PassThruCardService(Card card) throws SmartcardException {
        this.card = card;
    }

    public static void main(String[] stringArray) {
        Smartcard smartcard = null;
        try {
            smartcard = new Smartcard("client1");
            Card card = smartcard.waitForCardInserted(new CardSpec(), new ReaderSpec(), new AIDSpec(), new TimeoutSpec());
            System.out.println("Card inserted: " + card);
            PassThruCardService passThruCardService = (PassThruCardService)card.getCardService("com.sun.smartcard.PassThruCardService");
            byte[] byArray = "Hello".getBytes();
            byte[] byArray2 = passThruCardService.sendCommandAPDU(byArray);
            System.out.println("Response :");
            if (byArray2 == null) {
                System.out.println(" No Response");
            } else {
                System.out.println("\tStatusWord: ");
                int n = 0;
                while (n < 2) {
                    System.out.print(byArray2[n]);
                    ++n;
                }
                System.out.println("\tOutputData: ");
                int n2 = 2;
                while (n2 < byArray2.length) {
                    System.out.print(byArray2[n2]);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (smartcard != null) {
            smartcard.cleanup();
        }
    }

    public byte[] sendCommandAPDU(byte[] byArray) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.card.getClientHandle()));
        vector.add(new Long(this.card.getCardHandle()));
        vector.add(byArray);
        String string = OCFEncoder.encode(vector);
        String string2 = this.server.serverResponse("CardService", "PassThruCardService", "sendCommandAPDU", string);
        Vector vector2 = OCFDecoder.decode(string2);
        String string3 = (String)vector2.elementAt(1);
        return string3.getBytes();
    }
}

