/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.cmd;

import com.sun.opencard.cmd.CmdUtils;
import com.sun.opencard.cmd.OCFGetOpt;
import com.sun.smartcard.AIDSpec;
import com.sun.smartcard.Card;
import com.sun.smartcard.CardSpec;
import com.sun.smartcard.CardletAdminCardService;
import com.sun.smartcard.ReaderSpec;
import com.sun.smartcard.Smartcard;
import com.sun.smartcard.SmartcardReaderNotSupportedException;
import com.sun.smartcard.TimeoutSpec;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class OCFLoad {
    private Hashtable hash = new Hashtable();
    private String aid = "";
    private byte[] pin = null;
    private String reader = "";
    private int slot;
    private boolean unload = false;
    private boolean propSpecified = false;
    private boolean verbose = false;
    private String inFile = "";
    private String propFile = "";
    private String type = "";
    private static ResourceBundle messages;
    private static MessageFormat msgFormatter;
    private StringBuffer optionsOnCmdLine = new StringBuffer("");

    private void Usage() {
        System.out.println(messages.getString("OCFLoad.usage"));
        System.exit(1);
    }

    private boolean hasOption(int n) {
        String string = this.optionsOnCmdLine.toString();
        return string.indexOf(n) != -1;
    }

    private static void initialize() {
        try {
            Locale locale = CmdUtils.initLocale();
            msgFormatter = new MessageFormat("");
            msgFormatter.setLocale(locale);
            messages = CmdUtils.getMessageBundle(locale);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        OCFLoad oCFLoad = new OCFLoad();
        oCFLoad.run(stringArray);
    }

    private void parseCmdLine(String[] stringArray) {
        block16: {
            OCFGetOpt oCFGetOpt = new OCFGetOpt(stringArray, "P:p:A:uvr:s:i:");
            int n = -1;
            while ((n = oCFGetOpt.getopt()) != -1) {
                this.optionsOnCmdLine.append((char)n);
                switch (n) {
                    case 118: {
                        this.verbose = true;
                        break;
                    }
                    case 65: {
                        this.aid = oCFGetOpt.optArgGet();
                        break;
                    }
                    case 80: {
                        this.pin = oCFGetOpt.optArgGet().getBytes();
                        break;
                    }
                    case 115: {
                        this.slot = Integer.parseInt(oCFGetOpt.optArgGet());
                        break;
                    }
                    case 114: {
                        this.reader = oCFGetOpt.optArgGet();
                        break;
                    }
                    case 105: {
                        this.inFile = oCFGetOpt.optArgGet();
                        break;
                    }
                    case 117: {
                        this.unload = true;
                        break;
                    }
                    case 112: {
                        this.propFile = oCFGetOpt.optArgGet();
                        break;
                    }
                    default: {
                        this.Usage();
                        break;
                    }
                }
            }
            int n2 = oCFGetOpt.optIndexGet();
            if (n2 < stringArray.length) {
                this.propSpecified = true;
            }
            if (!this.hasOption(105)) break block16;
            try {
                this.parseInFile(this.inFile, this.hash);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.prtError("OCFLoad.noInputFile");
            }
            catch (Exception exception) {
                if (this.verbose) {
                    exception.printStackTrace();
                }
                this.prtError("OCFLoad.parsefile");
            }
        }
    }

    private void parseInFile(String string, Hashtable hashtable) throws Exception {
        block2: {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                Hashtable hashtable2 = (Hashtable)objectInputStream.readObject();
                hashtable2.putAll(hashtable);
                hashtable.putAll(hashtable2);
            }
            catch (StreamCorruptedException streamCorruptedException) {
                byte[] byArray = CmdUtils.inputStreamToByteArray(fileInputStream);
                if (this.hasOption(117)) break block2;
                hashtable.put(new String(String.valueOf(this.type) + ".binary"), byArray);
                if (!this.verbose) break block2;
                System.out.print("OCFLoad::File not a .capx file, assuming");
                System.out.println(" it to be a " + this.type + " type  file");
            }
        }
    }

    private void parsePropFile(String string, Hashtable hashtable) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.indexOf(this.type) == -1) {
                hashtable.put(new String(String.valueOf(this.type) + "." + string2), properties.getProperty(string2));
                continue;
            }
            hashtable.put(string2, properties.getProperty(string2));
        }
    }

    private void prtError(String string) {
        System.out.println(messages.getString(string));
        System.exit(1);
    }

    private void reParseCmdLine(String[] stringArray) {
        Object object;
        OCFGetOpt oCFGetOpt = new OCFGetOpt(stringArray, "P:p:A:uvr:s:i:");
        int n = -1;
        while ((n = oCFGetOpt.getopt()) != -1) {
        }
        int n2 = oCFGetOpt.optIndexGet();
        while (n2 < stringArray.length) {
            StringTokenizer stringTokenizer;
            object = "";
            String string = "";
            if (stringArray[n2].indexOf("=") == -1) {
                this.Usage();
            }
            if ((stringTokenizer = new StringTokenizer(stringArray[n2], "=")).hasMoreTokens()) {
                object = stringTokenizer.nextToken();
            }
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
            if (!((String)object).equals("") && !string.equals("")) {
                if (((String)object).indexOf(this.type) == -1) {
                    this.hash.put(new String(String.valueOf(this.type) + "." + (String)object), string);
                } else {
                    this.hash.put(object, string);
                }
            } else {
                this.Usage();
            }
            ++n2;
        }
        if (this.hasOption(65)) {
            this.hash.put(new String(String.valueOf(this.type) + ".aid"), this.aid);
        }
        if (this.hasOption(80)) {
            this.hash.put(new String(String.valueOf(this.type) + ".pin"), this.pin);
        }
        if (this.hasOption(117)) {
            this.hash.put(new String(String.valueOf(this.type) + ".unload"), new Boolean(this.unload));
        }
        if (this.hasOption(118)) {
            this.hash.put(new String(String.valueOf(this.type) + ".verbose"), new Boolean(this.verbose));
        }
        if (this.hasOption(112)) {
            try {
                this.parsePropFile(this.propFile, this.hash);
            }
            catch (Exception exception) {
                if (this.verbose) {
                    exception.printStackTrace();
                }
                this.prtError("OCFLoad.parsePropfile");
            }
        }
        if (this.hash.containsKey(".binary")) {
            object = (byte[])this.hash.get(".binary");
            if (this.verbose) {
                System.out.println("length of binary:" + ((Object)object).length);
            }
            this.hash.remove(".binary");
            this.hash.put(new String(String.valueOf(this.type) + ".binary"), object);
        }
    }

    public void run(String[] stringArray) {
        OCFLoad.initialize();
        ReaderSpec readerSpec = null;
        this.parseCmdLine(stringArray);
        if (!this.validArgs()) {
            this.Usage();
        }
        Smartcard smartcard = null;
        CardletAdminCardService cardletAdminCardService = null;
        try {
            readerSpec = !this.reader.equals("") ? new ReaderSpec(this.reader) : new ReaderSpec();
            if (this.verbose) {
                System.out.println("reader is :" + readerSpec.toString());
            }
            smartcard = new Smartcard("OCFLoad", "1");
            Card card = smartcard.waitForCardInserted(new CardSpec(), readerSpec, new AIDSpec(), new TimeoutSpec());
            if (this.verbose) {
                System.out.println("Card inserted: " + card);
            }
            this.type = card.getCardName();
            if (this.verbose) {
                System.out.println("OCFLoad::card name is :" + this.type);
            }
            cardletAdminCardService = (CardletAdminCardService)card.getCardService("com.sun.smartcard.CardletAdminCardService");
            if (this.verbose) {
                System.out.println("OCFLoad::loaded props before reparsing : " + this.hash);
            }
            this.reParseCmdLine(stringArray);
            if (this.verbose) {
                System.out.println("OCFLoad::loaded props after reparsing : " + this.hash);
            }
            if (this.verbose) {
                System.out.println("loaded props finally are : " + this.hash);
            }
            String string = "";
            if (this.pin != null && this.verbose) {
                System.out.println("OCFLoad::pin is :" + this.pin.toString());
                string = this.pin.toString();
            } else if (this.verbose) {
                System.out.println("OCFLoad::master pin is null");
            }
            if (this.hasOption(117) && this.hasOption(65)) {
                cardletAdminCardService.unloadApplet(string, this.aid);
            } else if (this.hasOption(117) && !this.hasOption(65)) {
                cardletAdminCardService.unloadAllApplets(string);
            } else {
                if (this.hash != null && this.verbose) {
                    System.out.println("OCFLoad::hash :" + this.hash);
                }
                cardletAdminCardService.loadApplet(string, this.hash);
            }
            this.prtError("OCFLoad.success");
        }
        catch (SmartcardReaderNotSupportedException smartcardReaderNotSupportedException) {
            System.out.println(messages.getString("OCFLoad.unknownCardReader"));
        }
        catch (Exception exception) {
            if (this.verbose) {
                exception.printStackTrace();
            }
            System.out.println(messages.getString("OCFLoad.getservice"));
            if (smartcard != null) {
                smartcard.cleanup();
            }
            this.Usage();
        }
        smartcard.cleanup();
    }

    private boolean validArgs() {
        if (this.propSpecified || this.hasOption(112)) {
            this.propSpecified = true;
        }
        if ((this.propSpecified || this.hasOption(105)) && this.unload) {
            return false;
        }
        if (this.optionsOnCmdLine.equals("")) {
            if (this.verbose) {
                System.out.println("no options specified");
            }
            return false;
        }
        return this.propSpecified || this.hasOption(105) || this.hasOption(117);
    }
}

