/*
 * Decompiled with CFR 0.152.
 */
package com.ibutton.oc.terminal.jib;

import com.ibutton.Access;
import com.ibutton.iButton;
import com.ibutton.jib.JibButton;
import com.ibutton.oc.terminal.jib.iButtonDriver;
import com.ibutton.oc.terminal.jib.iButtonDriverException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.Pollable;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.Slot;

public class iButtonCardTerminal
extends CardTerminal
implements Pollable {
    private boolean doDebug = true;
    private iButtonDriver driver = null;
    private String address;
    private boolean busy = false;
    private boolean cardPresent = false;
    private Slot ibAdapter_slot;
    private boolean noPoll = false;
    private boolean closePoll = true;
    private int delayNum = 0;
    private Hashtable hash;
    private Hashtable revHash;
    private Object[] ATRArray;
    private Access access = null;
    private static int MAX_IBUTTONS = 10;

    public iButtonCardTerminal(String string, String string2, String string3) {
        super(string, string2, string3);
        this.address = string3;
        this.hash = new Hashtable(MAX_IBUTTONS);
        this.revHash = new Hashtable(MAX_IBUTTONS);
        this.ATRArray = new Object[MAX_IBUTTONS];
    }

    private void add(JibButton jibButton) {
        int n = 0;
        while (n < MAX_IBUTTONS) {
            if (!this.hash.contains(Integer.toString(n))) {
                this.hash.put(jibButton.toString(), Integer.toString(n));
                this.revHash.put(Integer.toString(n), jibButton.toString());
                this.ATRArray[n] = null;
                this.cardInserted(n);
                return;
            }
            ++n;
        }
    }

    public void close() {
        block2: {
            this.busy = true;
            this.closePoll = false;
            if (this.driver == null) break block2;
            try {
                CardTerminalRegistry.getRegistry().removePollable((Pollable)this);
                this.driver.driverClose();
                this.driver = null;
            }
            catch (Exception exception) {
                this.driver = null;
            }
        }
    }

    public int[] getAdapterId() {
        return this.driver.getAdapterId();
    }

    private byte[] getCachedATR(int n) {
        byte[] byArray;
        if (this.doDebug) {
            System.out.println("Getting ATR for: " + n);
        }
        if ((byArray = (byte[])this.ATRArray[n]) != null) {
            byArray = (byte[])byArray.clone();
        }
        return byArray;
    }

    public CardID getCardID(int n) throws CardTerminalException {
        byte[] byArray;
        if (this.doDebug) {
            System.out.println("getCardID called with slot = " + n);
        }
        if ((byArray = this.getCachedATR(n)) != null) {
            if (this.doDebug) {
                System.out.println("Returning cached ATR");
            }
            return new CardID((Slot)this.slots.elementAt(n), byArray);
        }
        return this.internalReset(n, 500);
    }

    public CardID getCardID(int n, int n2) throws CardTerminalException {
        byte[] byArray = this.getCachedATR(n);
        if (byArray != null) {
            System.out.println("Returning cached ATR");
            return new CardID((Slot)this.slots.elementAt(n), byArray);
        }
        return this.internalReset(n, n2);
    }

    private int[] getRomId(int n) {
        String string = (String)this.revHash.get(Integer.toString(n));
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = 0;
        int[] nArray = new int[8];
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            nArray[n2] = Integer.valueOf(string2, 16);
            ++n2;
        }
        return nArray;
    }

    public int[] getiButtonId(int n) {
        return this.getRomId(n);
    }

    protected Properties internalFeatures(Properties properties) {
        return null;
    }

    protected CardID internalReset(int n, int n2) throws CardTerminalException {
        if (this.doDebug) {
            System.out.println("internalReset called with slot " + n);
        }
        if (this.driver == null) {
            throw new CardTerminalException("Driver is not installed");
        }
        try {
            int[] nArray = this.getRomId(n);
            JibButton jibButton = new JibButton(this.access, nArray);
            jibButton.select();
            byte[] byArray = this.driver.driverReset(jibButton, n2);
            this.setCachedATR(n, byArray);
            CardID cardID = new CardID((Slot)this.slots.elementAt(n), byArray);
            return cardID;
        }
        catch (iButtonDriverException iButtonDriverException2) {
            throw new CardTerminalException("Can not reset the card" + iButtonDriverException2.getMessage());
        }
    }

    protected synchronized ResponseAPDU internalSendAPDU(int n, CommandAPDU commandAPDU, int n2) throws CardTerminalException {
        this.busy = true;
        try {
            if (this.driver == null) {
                throw new CardTerminalException("Driver is not installed");
            }
            try {
                int[] nArray = this.getRomId(n);
                JibButton jibButton = new JibButton(this.access, nArray);
                jibButton.select();
                byte[] byArray = this.driver.driverSendAPDU(jibButton, commandAPDU.getBytes(), n2);
                ResponseAPDU responseAPDU = new ResponseAPDU(byArray);
                Object var6_9 = null;
                this.busy = false;
                return responseAPDU;
            }
            catch (iButtonDriverException iButtonDriverException2) {
                throw new CardTerminalException("Can not communicate with the card " + iButtonDriverException2.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.busy = false;
            throw throwable;
        }
    }

    public boolean isCardPresent(int n) throws CardTerminalException {
        if (this.driver == null) {
            return false;
        }
        int[] nArray = this.getRomId(n);
        if (nArray == null) {
            return false;
        }
        JibButton jibButton = new JibButton(this.access, nArray);
        return jibButton.select();
    }

    public void open() throws CardTerminalException {
        block2: {
            if (this.driver != null) break block2;
            try {
                this.driver = new iButtonDriver(this.address, this.type);
                this.addSlots(MAX_IBUTTONS);
                this.driver.driverOpen();
                this.access = this.driver.getAccess();
                CardTerminalRegistry.getRegistry().addPollable((Pollable)this);
            }
            catch (iButtonDriverException iButtonDriverException2) {
                System.out.println("Couldn't create an instance iButtonDriver for " + this.address);
                this.noPoll = true;
            }
        }
    }

    public void poll() throws CardTerminalException {
        String string = null;
        if (!this.closePoll) {
            return;
        }
        if (this.noPoll) {
            return;
        }
        if (this.delayNum < 3) {
            ++this.delayNum;
            return;
        }
        if (!this.busy) {
            iButtonCardTerminal iButtonCardTerminal2 = this;
            synchronized (iButtonCardTerminal2) {
                try {
                    Object object;
                    Object object2;
                    Enumeration enumeration = this.driver.getiButtons();
                    Vector<Object> vector = new Vector<Object>();
                    Vector<String> vector2 = new Vector<String>();
                    boolean bl = false;
                    Object var8_8 = null;
                    while (enumeration.hasMoreElements()) {
                        object2 = (JibButton)enumeration.nextElement();
                        vector.addElement(object2);
                        vector2.addElement(((iButton)object2).toString());
                    }
                    object2 = vector.elements();
                    while (object2.hasMoreElements()) {
                        JibButton jibButton = (JibButton)object2.nextElement();
                        object = jibButton.toString();
                        if (this.hash.containsKey(object)) continue;
                        this.add(jibButton);
                    }
                    object = this.hash.keys();
                    while (object.hasMoreElements()) {
                        string = (String)object.nextElement();
                        if (vector2.contains(string)) continue;
                        Integer n = new Integer((String)this.hash.get(string));
                        this.cardRemoved(n);
                        this.hash.remove(string);
                        this.revHash.remove(n.toString());
                    }
                }
                catch (iButtonDriverException iButtonDriverException2) {
                    throw new CardTerminalException("Can not communicate with the card " + iButtonDriverException2.getMessage());
                }
            }
        }
    }

    private void setCachedATR(int n, byte[] byArray) {
        if (this.doDebug) {
            System.out.println("Setting ATR for slot: " + n);
        }
        this.ATRArray[n] = byArray.clone();
    }
}

