/*
 * Decompiled with CFR 0.152.
 */
package com.ibutton.oc;

import com.ibutton.oc.JibAPI;
import com.ibutton.oc.JibEvent;
import com.ibutton.oc.JibListener;
import com.ibutton.oc.terminal.jib.iButtonCardTerminal;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.comm.CommPortIdentifier;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.InvalidSlotChannelException;
import opencard.core.terminal.Pollable;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.Slot;
import opencard.core.terminal.SlotChannel;

public class JibUtil
extends JibAPI
implements CTListener {
    private boolean openCard = false;
    public static final int MAX_JIB_AIDS = 16;
    public int numTimes = 0;
    static boolean isButtonInserted = false;
    static boolean firstPort = true;
    String nativeDevString;
    SlotChannel channel;
    Slot blueDot;
    String[] AIDStrings;

    public JibUtil() {
        super(null);
        this.listeners = new Vector();
    }

    public JibUtil(String string) {
        super(null);
        this.listeners = new Vector();
        this.nativeDevString = string;
    }

    public void addPort(String string, String string2) throws CardTerminalException {
        iButtonCardTerminal iButtonCardTerminal2 = new iButtonCardTerminal("iButtonAdapter", string2, string);
        CardTerminalRegistry cardTerminalRegistry = CardTerminalRegistry.getRegistry();
        cardTerminalRegistry.add((CardTerminal)iButtonCardTerminal2);
        cardTerminalRegistry.setPollInterval(500);
        cardTerminalRegistry.addPollable((Pollable)iButtonCardTerminal2);
        iButtonCardTerminal2.addCTListener(this);
        firstPort = false;
    }

    void addPorts() throws CardTerminalException {
        int n = 0;
        try {
            while (SmartCard.isStarted() && n < 100) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
                ++n;
            }
            if (!SmartCard.isStarted()) {
                SmartCard.start();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception.toString());
        }
        if (n == 100) {
            throw new RuntimeException("Timed Out on SmartCard.start()");
        }
        CardTerminalRegistry cardTerminalRegistry = CardTerminalRegistry.getRegistry();
        Enumeration enumeration = cardTerminalRegistry.getCardTerminals();
        while (enumeration.hasMoreElements()) {
            iButtonCardTerminal iButtonCardTerminal2 = (iButtonCardTerminal)((Object)enumeration.nextElement());
        }
        cardTerminalRegistry.addCTListener((CTListener)this);
    }

    void addPorts(String string) throws CardTerminalException {
        if (string != null) {
            if (string.length() != 0) {
                this.addPort(string, "iBUTTON_PORT_TYPE_LEGACY_SERIAL");
                return;
            }
        } else {
            this.addPort(null, "iBUTTON_PORT_TYPE_LEGACY_PARALLEL");
            Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
            while (enumeration.hasMoreElements()) {
                CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
                if (commPortIdentifier.getPortType() != 1) continue;
                this.addPort(commPortIdentifier.getName(), "iBUTTON_PORT_TYPE_SERIAL");
            }
        }
    }

    public void cardInserted(CardTerminalEvent cardTerminalEvent) throws CardTerminalException, InvalidSlotChannelException {
        this.blueDot = cardTerminalEvent.getSlot();
        if (this.blueDot.getSlotID() != 0) {
            return;
        }
        this.channel = this.blueDot.getCardTerminal().openSlotChannel(this.blueDot);
        isButtonInserted = true;
        this.setChannel(this.channel);
        try {
            int n = this.listeners.size();
            int n2 = 0;
            while (n2 < n) {
                JibListener jibListener = (JibListener)this.listeners.elementAt(n2);
                JibEvent jibEvent = new JibEvent(this, this.channel);
                jibListener.iButtonInserted(jibEvent);
                ++n2;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.out.println("cardInserted() - " + noSuchElementException + "\n" + this.toString());
            return;
        }
    }

    public void cardRemoved(CardTerminalEvent cardTerminalEvent) {
        if (cardTerminalEvent.getSlot().getSlotID() != 0) {
            return;
        }
        this.blueDot = null;
        this.AIDStrings = null;
        isButtonInserted = false;
        try {
            int n = this.listeners.size();
            int n2 = 0;
            while (n2 < n) {
                JibListener jibListener = (JibListener)this.listeners.elementAt(n2);
                JibEvent jibEvent = new JibEvent(this, null);
                jibListener.iButtonRemoved(jibEvent);
                ++n2;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.out.println("cardRemoved() - " + noSuchElementException + "\n" + this.toString());
            return;
        }
        try {
            this.channel.getCardTerminal().closeSlotChannel(this.channel);
        }
        catch (CardTerminalException cardTerminalException) {
            System.out.println("cardRemoved() - " + (Object)((Object)cardTerminalException) + "\n" + this.toString());
        }
    }

    public String[] getCardApplets() throws CardTerminalException {
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        ResponseAPDU responseAPDU = null;
        this.AIDStrings = new String[16];
        int n = 0;
        while (n < 16) {
            byArray[0] = (byte)n;
            responseAPDU = this.getAIDByNumber(n);
            byArray2 = responseAPDU.data();
            if (byArray2 != null) {
                short s = (short)((short)(byArray2[0] & 0xFF) + (short)(byArray2[1] << 8));
                this.AIDStrings[n] = new String(byArray2, 2, (int)s);
            } else {
                this.AIDStrings[n] = null;
            }
            ++n;
        }
        return this.AIDStrings;
    }

    public static int getMaxAIDSize() {
        return 16;
    }

    public void shutDown() {
        if (this.openCard) {
            try {
                SmartCard.shutdown();
            }
            catch (CardTerminalException cardTerminalException) {
                System.out.println("Caught CardTerminalException on shutdown:" + cardTerminalException.toString());
            }
        } else {
            CardTerminalRegistry cardTerminalRegistry = CardTerminalRegistry.getRegistry();
            Enumeration enumeration = cardTerminalRegistry.getCardTerminals();
            while (enumeration.hasMoreElements()) {
                iButtonCardTerminal iButtonCardTerminal2 = (iButtonCardTerminal)((Object)enumeration.nextElement());
                try {
                    cardTerminalRegistry.remove((CardTerminal)iButtonCardTerminal2);
                }
                catch (CardTerminalException cardTerminalException) {
                    System.out.println("Caught CardTerminalException on CardTerminal removal:" + cardTerminalException.toString());
                }
            }
            cardTerminalRegistry.removeCTListener((CTListener)this);
            try {
                SmartCard.shutdown();
            }
            catch (CardTerminalException cardTerminalException) {
                System.out.println("Caught CardTerminalException on shutdown:" + cardTerminalException.toString());
            }
        }
    }

    public void startPolling() throws CardTerminalException {
        this.addPorts(this.nativeDevString);
        JibAPI.connectEmulator(JibAPI.iButtonEmulator, false);
    }

    public void startPolling(boolean bl) throws CardTerminalException {
        this.openCard = bl;
        if (bl) {
            this.addPorts();
        } else {
            this.addPorts(this.nativeDevString);
        }
        if (JibAPI.iButtonEmulator != null) {
            new JibAPI.ConnectorThread(JibAPI.iButtonEmulator).start();
        }
    }
}

