/*
 * Decompiled with CFR 0.152.
 */
package com.ibutton.oc;

import com.ibutton.oc.JibAPI;
import com.ibutton.oc.JibMultiEvent;
import com.ibutton.oc.JibMultiListener;
import com.ibutton.oc.terminal.jib.iButtonCardTerminal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import javax.comm.CommPortIdentifier;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.InvalidSlotChannelException;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.Slot;
import opencard.core.terminal.SlotChannel;

public class JibMultiFactory
extends JibAPI
implements CTListener {
    private boolean openCard = false;
    public static final int MAX_JIB_AIDS = 16;
    public int numTimes = 0;
    private static Object semObj = new Object();
    private static boolean started = false;
    static int isButtonInserted = 0;
    static boolean firstPort = true;
    String nativeDevString;
    Hashtable hash;
    String[] AIDStrings;

    public JibMultiFactory() {
        super(null);
        this.listeners = new Vector();
        this.hash = new Hashtable(10);
    }

    public JibMultiFactory(String string) {
        super(null);
        this.listeners = new Vector();
        this.nativeDevString = string;
    }

    public void addPort(String string, String string2) throws CardTerminalException {
        iButtonCardTerminal iButtonCardTerminal2 = new iButtonCardTerminal("iButtonAdapter", string2, string);
        CardTerminalRegistry cardTerminalRegistry = CardTerminalRegistry.getRegistry();
        cardTerminalRegistry.add((CardTerminal)iButtonCardTerminal2);
        cardTerminalRegistry.setPollInterval(500);
        firstPort = false;
    }

    void addPorts(String string) throws CardTerminalException {
        if (string != null) {
            if (string.length() != 0) {
                this.addPort(string, "iBUTTON_PORT_TYPE_LEGACY_SERIAL");
                return;
            }
        } else {
            this.addPort(null, "iBUTTON_PORT_TYPE_LEGACY_PARALLEL");
            Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
            while (enumeration.hasMoreElements()) {
                CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
                if (commPortIdentifier.getPortType() != 1) continue;
                this.addPort(commPortIdentifier.getName(), "iBUTTON_PORT_TYPE_SERIAL");
            }
            CardTerminalRegistry cardTerminalRegistry = CardTerminalRegistry.getRegistry();
            cardTerminalRegistry.addCTListener((CTListener)this);
        }
    }

    void addPorts(String string, String string2) throws CardTerminalException {
        Object object;
        int n;
        block11: {
            n = 0;
            try {
                while (SmartCard.isStarted() && n < 100) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++n;
                }
                if (SmartCard.isStarted()) break block11;
                object = semObj;
                synchronized (object) {
                    started = true;
                    SmartCard.start();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception " + exception.toString());
            }
        }
        if (n == 100) {
            throw new RuntimeException("Timed Out on SmartCard.start()");
        }
        object = CardTerminalRegistry.getRegistry();
        if (string != null) {
            Enumeration enumeration = object.getCardTerminals();
            while (enumeration.hasMoreElements()) {
                object.remove((CardTerminal)enumeration.nextElement());
            }
            this.addPort(string2, string);
            Properties properties = System.getProperties();
            ((Hashtable)properties).put("OpenCard.terminals", "com.ibutton.oc.terminal.jib.iButtonCardTerminalFactory|iButtonAdapter|" + string + "|" + string2);
            System.setProperties(properties);
        }
        object.addCTListener((CTListener)this);
    }

    public void cardInserted(CardTerminalEvent cardTerminalEvent) throws CardTerminalException, InvalidSlotChannelException {
        Slot slot = cardTerminalEvent.getSlot();
        int n = this.listeners.size();
        if (n != 0) {
            SlotChannel slotChannel = slot.getCardTerminal().openSlotChannel(slot);
            this.hash.put(new Integer(slot.getSlotID()).toString(), slotChannel);
            ++isButtonInserted;
            int n2 = this.listeners.size();
            try {
                int n3 = 0;
                while (n3 < n2) {
                    JibMultiListener jibMultiListener = (JibMultiListener)this.listeners.elementAt(n3);
                    JibMultiEvent jibMultiEvent = new JibMultiEvent(this, slotChannel, slot.getSlotID());
                    jibMultiListener.iButtonInserted(jibMultiEvent);
                    ++n3;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                System.out.println("cardInserted() - " + noSuchElementException + "\n" + this.toString());
                return;
            }
        }
    }

    public void cardRemoved(CardTerminalEvent cardTerminalEvent) {
        block5: {
            int n = this.listeners.size();
            if (n == 0) break block5;
            Slot slot = cardTerminalEvent.getSlot();
            SlotChannel slotChannel = (SlotChannel)this.hash.remove(new Integer(slot.getSlotID()).toString());
            --isButtonInserted;
            this.AIDStrings = null;
            try {
                int n2 = this.listeners.size();
                int n3 = 0;
                while (n3 < n2) {
                    JibMultiListener jibMultiListener = (JibMultiListener)this.listeners.elementAt(n3);
                    JibMultiEvent jibMultiEvent = new JibMultiEvent(this, null, slot.getSlotID());
                    jibMultiListener.iButtonRemoved(jibMultiEvent);
                    ++n3;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                System.out.println("cardRemoved() - " + noSuchElementException + "\n" + this.toString());
                return;
            }
            try {
                slotChannel.getCardTerminal().closeSlotChannel(slotChannel);
            }
            catch (CardTerminalException cardTerminalException) {
                System.out.println("cardRemoved() - " + (Object)((Object)cardTerminalException) + "\n" + this.toString());
            }
        }
    }

    public String[] getCardApplets() throws CardTerminalException {
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        ResponseAPDU responseAPDU = null;
        this.AIDStrings = new String[16];
        int n = 0;
        while (n < 16) {
            byArray[0] = (byte)n;
            responseAPDU = this.getAIDByNumber(n);
            byArray2 = responseAPDU.data();
            if (byArray2 != null) {
                short s = (short)((short)(byArray2[0] & 0xFF) + (short)(byArray2[1] << 8));
                this.AIDStrings[n] = new String(byArray2, 2, (int)s);
            } else {
                this.AIDStrings[n] = null;
            }
            ++n;
        }
        return this.AIDStrings;
    }

    public static int getMaxAIDSize() {
        return 16;
    }

    public void setSlot(int n) {
        SlotChannel slotChannel = (SlotChannel)this.hash.get(new Integer(n).toString());
        this.setChannel(slotChannel);
    }

    public void shutDown() {
        Object object;
        if (this.openCard) {
            Object object2 = semObj;
            synchronized (object2) {
                if (started) {
                    started = false;
                    try {
                        SmartCard.shutdown();
                        while (SmartCard.isStarted()) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    catch (CardTerminalException cardTerminalException) {
                        System.out.println("Could not ShutDown: CardTerminalException thrown, " + cardTerminalException.toString());
                    }
                }
            }
        }
        CardTerminalRegistry cardTerminalRegistry = CardTerminalRegistry.getRegistry();
        Enumeration enumeration = cardTerminalRegistry.getCardTerminals();
        while (enumeration.hasMoreElements()) {
            object = (iButtonCardTerminal)((Object)enumeration.nextElement());
            try {
                cardTerminalRegistry.remove((CardTerminal)object);
            }
            catch (CardTerminalException cardTerminalException) {
                System.out.println("Could not remove card terminal: " + cardTerminalException.toString());
            }
        }
        cardTerminalRegistry.removeCTListener((CTListener)this);
        object = semObj;
        synchronized (object) {
            if (started) {
                started = false;
                try {
                    SmartCard.shutdown();
                }
                catch (CardTerminalException cardTerminalException) {
                    System.out.println("Could not ShutDown: CardTerminalException thrown, " + cardTerminalException.toString());
                }
            }
        }
    }

    public void startPolling(boolean bl) throws CardTerminalException {
        this.openCard = bl;
        if (bl) {
            this.addPorts(null, null);
        } else {
            this.addPorts(this.nativeDevString);
        }
        if (JibAPI.iButtonEmulator != null) {
            new JibAPI.ConnectorThread(JibAPI.iButtonEmulator).start();
        }
    }

    public void startPolling(boolean bl, String string, String string2) throws CardTerminalException {
        this.openCard = bl;
        if (bl) {
            this.addPorts(string, string2);
        } else {
            this.addPorts(this.nativeDevString);
        }
        if (JibAPI.iButtonEmulator != null) {
            new JibAPI.ConnectorThread(JibAPI.iButtonEmulator).start();
        }
    }
}

