/*
 * Decompiled with CFR 0.152.
 */
package com.ibutton.oc;

import com.ibutton.oc.CommandAPDU;
import com.ibutton.oc.JibEvent;
import com.ibutton.oc.JibListener;
import com.ibutton.oc.JibMultiEvent;
import com.ibutton.oc.JibMultiListener;
import com.ibutton.oc.emulator.AbstractIBVM;
import com.ibutton.oc.emulator.AbstractStatus;
import com.ibutton.oc.emulator.InterruptedExecution;
import com.ibutton.oc.terminal.jib.iButtonCardTerminal;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Vector;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.InvalidSlotChannelException;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;

public class JibAPI {
    private SlotChannel gChannel;
    static final byte CLA = -48;
    static final byte INS = -107;
    private String password;
    public static final int PASSWORD_LENGTH_SIZE = 1;
    public static final int PASSWORD_SIZE = 8;
    public static final int AID_LENGTH_SIZE = 1;
    public static final int AID_SIZE = 16;
    public static final int AID_LENGTH_OFFSET = 9;
    public static final int AID_NAME_OFFSET = 10;
    public static final int CLASS_FILE_HEADER_SIZE = 26;
    public static int APDU_PACKET_LENGTH = 64;
    opencard.core.terminal.CommandAPDU _apdu;
    private static Vector jibapis = new Vector();
    protected Vector listeners = new Vector();
    protected static Vector emulatorListeners = new Vector();
    private static StateListener stateListener = new StateListener();
    private static SlotChannel emulatedChannel;
    protected static AbstractIBVM iButtonEmulator;
    private static int pollingPause;

    static {
        iButtonEmulator = null;
        pollingPause = 3000;
    }

    public JibAPI() {
        this.gChannel = null;
        this._apdu = new opencard.core.terminal.CommandAPDU(4);
        jibapis.addElement(this);
    }

    public JibAPI(SlotChannel slotChannel) {
        this.gChannel = slotChannel;
        this._apdu = new opencard.core.terminal.CommandAPDU(4);
        jibapis.addElement(this);
    }

    public void addJiBListener(JibListener jibListener) {
        if (iButtonEmulator == null) {
            this.listeners.addElement(jibListener);
        } else {
            emulatorListeners.addElement(jibListener);
        }
    }

    public void addJiBListener(JibMultiListener jibMultiListener) {
        if (iButtonEmulator == null) {
            this.listeners.addElement(jibMultiListener);
        } else {
            emulatorListeners.addElement(jibMultiListener);
        }
    }

    private opencard.core.terminal.CommandAPDU buildAPDU(byte by, byte by2, byte by3, byte by4) {
        this._apdu.setLength(0);
        this._apdu.append(by);
        this._apdu.append(by2);
        this._apdu.append(by3);
        this._apdu.append(by4);
        return this._apdu;
    }

    private static opencard.core.terminal.CommandAPDU buildAPDU(byte by, byte by2, byte by3, byte by4, byte[] byArray) {
        opencard.core.terminal.CommandAPDU commandAPDU = new opencard.core.terminal.CommandAPDU(byArray.length + 5);
        commandAPDU.setLength(0);
        commandAPDU.append(by);
        commandAPDU.append(by2);
        commandAPDU.append(by3);
        commandAPDU.append(by4);
        commandAPDU.append((byte)byArray.length);
        commandAPDU.append(byArray);
        return commandAPDU;
    }

    protected static void connectEmulator(AbstractIBVM abstractIBVM, boolean bl) {
        if (abstractIBVM != null) {
            if (abstractIBVM.getStatus().status != 0) {
                JibAPI.dispatchEvent(abstractIBVM, true);
            }
            if (bl) {
                abstractIBVM.addStatusListener(stateListener);
            }
        }
    }

    public ResponseAPDU deleteAppletByAID(String string) throws CardTerminalException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length() + string.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)string.length();
            System.arraycopy(string.getBytes(), 0, byArray, this.password.length() + 2, string.length());
        } else {
            byArray = new byte[2 + string.length()];
            byArray[0] = 0;
            byArray[1] = (byte)string.length();
            System.arraycopy(string.getBytes(), 0, byArray, 2, string.length());
        }
        opencard.core.terminal.CommandAPDU commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-107, (byte)3, (byte)2, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU deleteAppletByNumber(int n) throws CardTerminalException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)n;
        } else {
            byArray = new byte[]{0, (byte)n};
        }
        opencard.core.terminal.CommandAPDU commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-107, (byte)3, (byte)1, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU deleteAppletByNumber(int n, boolean bl) throws CardTerminalException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)n;
        } else {
            byArray = new byte[]{0, (byte)n};
        }
        opencard.core.terminal.CommandAPDU commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-107, (byte)3, (byte)1, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU deleteSelectedApplet() throws CardTerminalException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[1 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
        } else {
            byArray = new byte[2];
            byArray[0] = 0;
        }
        opencard.core.terminal.CommandAPDU commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-107, (byte)3, (byte)0, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    private static void disconnectEmulator(AbstractIBVM abstractIBVM) {
        if (abstractIBVM != null) {
            abstractIBVM.removeStatusListener(stateListener);
            if (abstractIBVM.getStatus().status != 0) {
                JibAPI.dispatchEvent(abstractIBVM, false);
            }
        }
    }

    private static void dispatchEvent(AbstractIBVM abstractIBVM, boolean bl) {
        try {
            if (emulatedChannel == null) {
                emulatedChannel = new EmulatedTerminal().openSlotChannel(-1);
            }
        }
        catch (InvalidSlotChannelException invalidSlotChannelException) {
            invalidSlotChannelException.printStackTrace();
        }
        catch (CardTerminalException cardTerminalException) {
            cardTerminalException.printStackTrace();
        }
        try {
            JibMultiEvent jibMultiEvent = new JibMultiEvent(abstractIBVM, emulatedChannel, -1);
            JibEvent jibEvent = new JibEvent(abstractIBVM, emulatedChannel);
            int n = emulatorListeners.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = emulatorListeners.elementAt(n2);
                if (e instanceof JibMultiListener) {
                    if (bl) {
                        ((JibMultiListener)e).iButtonInserted(jibMultiEvent);
                    } else {
                        ((JibMultiListener)e).iButtonRemoved(jibMultiEvent);
                    }
                } else if (bl) {
                    ((JibListener)e).iButtonInserted(jibEvent);
                } else {
                    ((JibListener)e).iButtonRemoved(jibEvent);
                }
                ++n2;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.out.println("dispatchEvent() - " + noSuchElementException);
            return;
        }
    }

    public ResponseAPDU getAIDByNumber(int n) throws CardTerminalException {
        int n2 = 0;
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        opencard.core.terminal.CommandAPDU commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-107, (byte)1, (byte)14, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        if (responseAPDU.sw() == 33875) {
            return responseAPDU;
        }
        n2 = responseAPDU.data().length;
        byArray = new byte[n2 + 4];
        byte[] byArray2 = responseAPDU.data();
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = byArray2[n3];
            ++n3;
        }
        byArray[n2] = responseAPDU.sw1();
        byArray[n2 + 1] = responseAPDU.sw2();
        byArray[n2 + 2] = -112;
        byArray[n2 + 3] = 0;
        return new ResponseAPDU(byArray);
    }

    public ResponseAPDU getATR() throws CardTerminalException {
        opencard.core.terminal.CommandAPDU commandAPDU = this.buildAPDU((byte)-48, (byte)-107, (byte)1, (byte)11);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU getAppletGCMode() throws CardTerminalException {
        opencard.core.terminal.CommandAPDU commandAPDU = this.buildAPDU((byte)-48, (byte)-107, (byte)1, (byte)3);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU getCommandPINMode() throws CardTerminalException {
        opencard.core.terminal.CommandAPDU commandAPDU = this.buildAPDU((byte)-48, (byte)-107, (byte)1, (byte)4);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU getCommitBufferSize() throws CardTerminalException {
        opencard.core.terminal.CommandAPDU commandAPDU = this.buildAPDU((byte)-48, (byte)-107, (byte)1, (byte)10);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public static AbstractIBVM getEmulator() {
        return iButtonEmulator;
    }

    public ResponseAPDU getEphemeralGCMode() throws CardTerminalException {
        opencard.core.terminal.CommandAPDU commandAPDU = this.buildAPDU((byte)-48, (byte)-107, (byte)1, (byte)2);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU getErrorReportingMode() throws CardTerminalException {
        opencard.core.terminal.CommandAPDU commandAPDU = this.buildAPDU((byte)-48, (byte)-107, (byte)1, (byte)9);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU getExceptionMode() throws CardTerminalException {
        opencard.core.terminal.CommandAPDU commandAPDU = this.buildAPDU((byte)-48, (byte)-107, (byte)1, (byte)7);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU getFirmwareVersionString() throws CardTerminalException {
        opencard.core.terminal.CommandAPDU commandAPDU = this.buildAPDU((byte)-48, (byte)-107, (byte)1, (byte)0);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU getFreeRAM() throws CardTerminalException {
        opencard.core.terminal.CommandAPDU commandAPDU = this.buildAPDU((byte)-48, (byte)-107, (byte)1, (byte)1);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU getLastError() throws CardTerminalException {
        opencard.core.terminal.CommandAPDU commandAPDU = this.buildAPDU((byte)-48, (byte)-107, (byte)1, (byte)15);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU getLoadPINMode() throws CardTerminalException {
        opencard.core.terminal.CommandAPDU commandAPDU = this.buildAPDU((byte)-48, (byte)-107, (byte)1, (byte)5);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public int getLoadPacketSize() {
        return APDU_PACKET_LENGTH;
    }

    public ResponseAPDU getPORCount() throws CardTerminalException {
        opencard.core.terminal.CommandAPDU commandAPDU = this.buildAPDU((byte)-48, (byte)-107, (byte)2, (byte)0);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU getRandomBytes(int n) throws CardTerminalException {
        if (n > 120) {
            n = 120;
        }
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        opencard.core.terminal.CommandAPDU commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-107, (byte)1, (byte)13, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU getRealTimeClock() throws CardTerminalException {
        opencard.core.terminal.CommandAPDU commandAPDU = this.buildAPDU((byte)-48, (byte)-107, (byte)1, (byte)12);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU getRestoreMode() throws CardTerminalException {
        opencard.core.terminal.CommandAPDU commandAPDU = this.buildAPDU((byte)-48, (byte)-107, (byte)1, (byte)6);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU loadApplet(String string, String string2, String string3) throws CardTerminalException, FileNotFoundException, IOException {
        opencard.core.terminal.CommandAPDU commandAPDU;
        int n;
        byte[] byArray = new byte[APDU_PACKET_LENGTH];
        String string4 = string;
        String string5 = string2;
        String string6 = String.valueOf(string5) + string4;
        File file = new File(string5, string4);
        FileInputStream fileInputStream = new FileInputStream(file);
        long l = file.length();
        long l2 = fileInputStream.available();
        byte[] byArray2 = new byte[26 + (int)l];
        if (this.password != null) {
            byArray2[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray2, 1, this.password.length());
        }
        int n2 = 0;
        while (n2 < 16) {
            if (n2 >= string3.length()) break;
            byArray2[n2 + 10] = (byte)string3.charAt(n2);
            ++n2;
        }
        byArray2[9] = (byte)n2;
        if (l <= l2) {
            fileInputStream.read(byArray2, 26, (int)l);
        } else {
            byte[] byArray3 = new byte[(int)l2];
            long l3 = 0L;
            while (l3 < l) {
                fileInputStream.read(byArray3);
                System.arraycopy(byArray3, 0, byArray2, (int)l3 + 26, byArray3.length);
                l3 += l2;
            }
        }
        fileInputStream.close();
        int n3 = 0;
        boolean bl = true;
        byte[] byArray4 = new byte[2];
        byArray4[0] = -112;
        byte[] byArray5 = byArray4;
        ResponseAPDU responseAPDU = new ResponseAPDU(byArray5);
        while ((long)n3 < l + 26L - (long)APDU_PACKET_LENGTH) {
            n = 0;
            while (n < APDU_PACKET_LENGTH && n < byArray2.length) {
                byArray[n] = byArray2[n + n3];
                ++n;
            }
            n3 += APDU_PACKET_LENGTH;
            if (bl) {
                commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-90, (byte)1, (byte)0, byArray);
                bl = false;
            } else {
                commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-90, (byte)2, (byte)0, byArray);
            }
            responseAPDU = this.sendAPDU(commandAPDU);
            if ((long)n3 >= l + 26L || responseAPDU.sw() == 25345) continue;
            n3 = (int)(l + 26L + 1L);
        }
        if ((long)n3 < l + 26L) {
            byArray = new byte[(int)(l + 26L - (long)n3)];
            n = 0;
            while ((long)n < l + 26L - (long)n3) {
                byArray[n] = byArray2[n + n3];
                ++n;
            }
            commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-90, (byte)2, (byte)0, byArray);
            responseAPDU = this.sendAPDU(commandAPDU);
        }
        return responseAPDU;
    }

    public ResponseAPDU masterErase() throws CardTerminalException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[1 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
        } else {
            byArray = new byte[]{0};
        }
        opencard.core.terminal.CommandAPDU commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-107, (byte)0, (byte)0, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU process(opencard.core.terminal.CommandAPDU commandAPDU) throws CardTerminalException {
        return this.sendAPDU(commandAPDU);
    }

    public ResponseAPDU readFirmwareVersionID() throws CardTerminalException {
        opencard.core.terminal.CommandAPDU commandAPDU = this.buildAPDU((byte)-48, (byte)-107, (byte)1, (byte)0);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU readFreeRAM() throws CardTerminalException {
        opencard.core.terminal.CommandAPDU commandAPDU = this.buildAPDU((byte)-48, (byte)-107, (byte)1, (byte)1);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public void removeAllJibAPIs() {
        int n = 0;
        while (n < jibapis.size()) {
            ((JibAPI)jibapis.elementAt(n)).removeAllListeners();
            ++n;
        }
        jibapis.removeAllElements();
    }

    public void removeAllListeners() {
        this.listeners.removeAllElements();
    }

    public static void removeEmulatorListeners() {
        emulatorListeners.removeAllElements();
    }

    public void removeJiBListener(JibListener jibListener) {
        if (iButtonEmulator == null) {
            this.listeners.removeElement(jibListener);
        } else {
            emulatorListeners.removeElement(jibListener);
        }
    }

    public void removeJiBListener(JibMultiListener jibMultiListener) {
        if (iButtonEmulator == null) {
            this.listeners.removeElement(jibMultiListener);
        } else {
            emulatorListeners.removeElement(jibMultiListener);
        }
    }

    public ResponseAPDU select(String string) throws CardTerminalException {
        byte[] byArray = new byte[string.length()];
        System.arraycopy(string.getBytes(), 0, byArray, 0, string.length());
        opencard.core.terminal.CommandAPDU commandAPDU = JibAPI.buildAPDU((byte)0, (byte)-92, (byte)4, (byte)0, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU sendAPDU(opencard.core.terminal.CommandAPDU commandAPDU) throws CardTerminalException {
        if (iButtonEmulator != null) {
            try {
                return iButtonEmulator.sendAPDU(new CommandAPDU(commandAPDU));
            }
            catch (InterruptedExecution interruptedExecution) {
                return null;
            }
        }
        return this.gChannel.sendAPDU(commandAPDU);
    }

    public ResponseAPDU setAppletGCMode(int n) throws CardTerminalException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)n;
        } else {
            byArray = new byte[]{0, (byte)n};
        }
        opencard.core.terminal.CommandAPDU commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-107, (byte)0, (byte)3, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    protected void setChannel(SlotChannel slotChannel) {
        this.gChannel = slotChannel;
    }

    public ResponseAPDU setCommandPINMode(int n) throws CardTerminalException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)n;
        } else {
            byArray = new byte[]{0, (byte)n};
        }
        opencard.core.terminal.CommandAPDU commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-107, (byte)0, (byte)4, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU setCommitBufferSize(int n) throws CardTerminalException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[3 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)(n & 0xFF);
            byArray[this.password.length() + 2] = (byte)(n >>> 16);
        } else {
            byArray = new byte[]{0, (byte)(n & 0xFF), (byte)(n >>> 16)};
        }
        opencard.core.terminal.CommandAPDU commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-107, (byte)0, (byte)2, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU setCommonPIN(String string) throws CardTerminalException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[string.length() + this.password.length() + 2];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)string.length();
            System.arraycopy(string.getBytes(), 0, byArray, this.password.length() + 2, string.length());
        } else {
            byArray = new byte[2 + string.length()];
            byArray[0] = 0;
            byArray[1] = (byte)string.length();
            System.arraycopy(string.getBytes(), 0, byArray, 2, string.length());
        }
        opencard.core.terminal.CommandAPDU commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-107, (byte)0, (byte)1, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public static void setEmulator(AbstractIBVM abstractIBVM) {
        AbstractIBVM abstractIBVM2 = iButtonEmulator;
        iButtonEmulator = abstractIBVM;
        if (abstractIBVM2 != abstractIBVM) {
            JibAPI.disconnectEmulator(abstractIBVM2);
            JibAPI.connectEmulator(abstractIBVM, true);
        }
    }

    public ResponseAPDU setEphemeralGCMode(int n) throws CardTerminalException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)n;
        } else {
            byArray = new byte[]{0, (byte)n};
        }
        opencard.core.terminal.CommandAPDU commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-107, (byte)0, (byte)2, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU setErrorReportingMode(int n) throws CardTerminalException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)n;
        } else {
            byArray = new byte[]{0, (byte)n};
        }
        opencard.core.terminal.CommandAPDU commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-107, (byte)0, (byte)9, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU setExceptionMode(int n) throws CardTerminalException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)n;
        } else {
            byArray = new byte[]{0, (byte)n};
        }
        opencard.core.terminal.CommandAPDU commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-107, (byte)0, (byte)7, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public ResponseAPDU setLoadPINMode(int n) throws CardTerminalException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)n;
        } else {
            byArray = new byte[]{0, (byte)n};
        }
        opencard.core.terminal.CommandAPDU commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-107, (byte)0, (byte)5, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    public boolean setLoadPacketSize(int n) {
        if (n < 64 || n > 164) {
            return false;
        }
        APDU_PACKET_LENGTH = n;
        return true;
    }

    public void setPIN(String string) {
        this.password = string;
    }

    public static void setPollingPause(int n) {
        pollingPause = n;
    }

    public ResponseAPDU setRestoreMode(int n) throws CardTerminalException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)n;
        } else {
            byArray = new byte[]{0, (byte)n};
        }
        opencard.core.terminal.CommandAPDU commandAPDU = JibAPI.buildAPDU((byte)-48, (byte)-107, (byte)0, (byte)6, byArray);
        ResponseAPDU responseAPDU = this.sendAPDU(commandAPDU);
        return responseAPDU;
    }

    protected static class ConnectorThread
    extends Thread {
        private AbstractIBVM emulator;

        ConnectorThread(AbstractIBVM abstractIBVM) {
            this.emulator = abstractIBVM;
        }

        public void run() {
            try {
                Thread.sleep(pollingPause);
            }
            catch (InterruptedException interruptedException) {}
            JibAPI.connectEmulator(this.emulator, false);
        }
    }

    private static class StateListener
    implements PropertyChangeListener {
        StateListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n = ((AbstractStatus)propertyChangeEvent.getOldValue()).status;
            int n2 = ((AbstractStatus)propertyChangeEvent.getNewValue()).status;
            if (n != 0 && n2 == 0) {
                JibAPI.dispatchEvent(iButtonEmulator, false);
            } else if (n == 0 && n2 != 0) {
                JibAPI.dispatchEvent(iButtonEmulator, true);
            }
        }
    }

    private static class EmulatedTerminal
    extends iButtonCardTerminal {
        public EmulatedTerminal() {
            super("Emulated iButton", "Emulator", null);
        }

        public ResponseAPDU internalSendAPDU(int n, opencard.core.terminal.CommandAPDU commandAPDU, int n2) {
            try {
                return iButtonEmulator.sendAPDU(new CommandAPDU(commandAPDU));
            }
            catch (InterruptedExecution interruptedExecution) {
                return null;
            }
        }
    }
}

