/*
 * Decompiled with CFR 0.152.
 */
package com.ibutton.oc;

import opencard.core.terminal.APDU;

public class CommandAPDU
extends opencard.core.terminal.CommandAPDU {
    private byte[] header;
    private byte lc;
    protected int le;
    protected byte[] data;
    protected boolean nonISO;
    public static final int CASE_NON_ISO = 0;
    public static final int CASE_1 = 2;
    public static final int CASE_2S = 8;
    public static final int CASE_2E = 12;
    public static final int CASE_3S = 32;
    public static final int CASE_3E = 48;
    public static final int CASE_4S = 128;
    public static final int CASE_4E = 192;
    public static final int CLASS = 0;
    public static final int INSTRUCTION = 1;
    public static final int P1 = 2;
    public static final int P2 = 3;

    public CommandAPDU() {
        this(0, 0, 0, 0, new byte[0], 0);
    }

    public CommandAPDU(byte by, byte by2, byte by3, byte by4) {
        this(by, by2, by3, by4, new byte[0], 0);
    }

    public CommandAPDU(byte by, byte by2, byte by3, byte by4, int n) {
        this(by, by2, by3, by4, new byte[0], n);
    }

    public CommandAPDU(byte by, byte by2, byte by3, byte by4, byte[] byArray) {
        this(by, by2, by3, by4, byArray, 0);
    }

    public CommandAPDU(byte by, byte by2, byte by3, byte by4, byte[] byArray, int n) {
        super(0);
        if (byArray != null) {
            this.lc = (byte)byArray.length;
            this.data = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.data, 0, byArray.length);
            ((APDU)this).apdu_buffer = new byte[this.data.length + 6];
        } else {
            this.lc = 0;
            this.data = new byte[0];
            ((APDU)this).apdu_buffer = new byte[4];
        }
        this.header = new byte[4];
        this.header[0] = by;
        this.header[1] = by2;
        this.header[2] = by3;
        this.header[3] = by4;
        this.le = (byte)n;
        this.setLength(0);
        this.append(by);
        this.append(by2);
        this.append(by3);
        this.append(by4);
        if (byArray != null) {
            this.append(this.lc);
            this.append(this.data);
            this.append((byte)n);
        }
    }

    protected CommandAPDU(opencard.core.terminal.CommandAPDU commandAPDU) {
        super(commandAPDU.getBuffer());
        byte[] byArray = commandAPDU.getBuffer();
        this.header = new byte[4];
        System.arraycopy(byArray, 0, this.header, 0, 4);
        this.lc = 0;
        if (byArray.length > 4) {
            this.lc = byArray[4];
            this.data = new byte[this.lc & 0xFF];
            System.arraycopy(byArray, 5, this.data, 0, this.data.length);
        } else {
            this.data = new byte[0];
        }
        if (byArray.length > 5 + this.data.length) {
            this.le = byArray[5 + this.data.length];
        }
    }

    public CommandAPDU(byte[] byArray) {
        this(byArray, true);
    }

    public CommandAPDU(byte[] byArray, int n) {
        this(byArray[0], byArray[1], byArray[2], byArray[3], new byte[0], n);
    }

    public CommandAPDU(byte[] byArray, boolean bl) {
        super(byArray);
        this.header = new byte[4];
        System.arraycopy(byArray, 0, this.header, 0, 4);
        this.lc = 0;
        if (byArray.length > 4) {
            this.lc = byArray[4];
            this.data = new byte[this.lc & 0xFF];
            System.arraycopy(byArray, 5, this.data, 0, this.data.length);
        } else {
            this.data = new byte[0];
        }
        if (byArray.length > 5 + this.data.length) {
            this.le = byArray[5 + this.data.length];
        }
    }

    public CommandAPDU(byte[] byArray, byte[] byArray2) {
        this(byArray, byArray2, true);
    }

    public CommandAPDU(byte[] byArray, byte[] byArray2, int n) {
        this(byArray[0], byArray[1], byArray[2], byArray[3], byArray2, n);
    }

    public CommandAPDU(byte[] byArray, byte[] byArray2, boolean bl) {
        this(byArray, byArray2, 0);
    }

    public byte classByte() {
        return this.header[0];
    }

    public byte[] data() {
        return this.data;
    }

    public byte[] header() {
        return this.header;
    }

    public byte instruction() {
        return this.header[1];
    }

    public int isoCase() {
        boolean bl;
        if (this.nonISO) {
            return 0;
        }
        boolean bl2 = bl = this.lc() < 256 && this.le < 256;
        if (this.lc() <= 0) {
            if (this.le < 0) {
                return 2;
            }
            return bl ? 8 : 12;
        }
        if (this.le < 0) {
            return bl ? 32 : 48;
        }
        return bl ? 128 : 192;
    }

    public int lc() {
        return this.data == null ? 0 : this.data.length;
    }

    public int le() {
        return this.le;
    }

    public int le(int n) {
        this.le = n;
        return n;
    }

    public byte p1() {
        return this.header[2];
    }

    public byte p2() {
        return this.header[3];
    }
}

