/*
 * Decompiled with CFR 0.152.
 */
package com.ibutton.jib;

public class JibReturnPacket {
    int csb;
    int groupID;
    int[] data;
    public static final int CSB_OK = 0;
    public static final int CMD_OK = 0;

    public JibReturnPacket(int n, int n2, int[] nArray) {
        this.csb = n;
        this.groupID = n2;
        if (nArray != null) {
            this.data = new int[nArray.length];
            System.arraycopy(nArray, 0, this.data, 0, nArray.length);
        }
    }

    public JibReturnPacket(int[] nArray) {
        this.csb = nArray[0];
        this.groupID = nArray[1];
        this.data = new int[nArray.length - 3];
        System.arraycopy(nArray, 3, this.data, 0, nArray.length - 3);
    }

    public int getCSB() {
        return this.csb;
    }

    public int getGroupID() {
        return this.groupID;
    }

    public byte[] getReturnBytes() {
        byte[] byArray = new byte[this.data.length];
        int n = 0;
        while (n < this.data.length) {
            byArray[n] = (byte)(this.data[n] & 0xFF);
            ++n;
        }
        return byArray;
    }

    public char[] getReturnChars() {
        char[] cArray = new char[this.data.length];
        int n = 0;
        while (n < this.data.length) {
            cArray[n] = (char)this.data[n];
            ++n;
        }
        return cArray;
    }

    public char[] getReturnChars(int n, int n2) {
        char[] cArray = new char[this.data.length - n];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = (char)this.data[n3 + n];
            ++n3;
        }
        return cArray;
    }

    public int getReturnInteger() {
        return this.getReturnInteger(0);
    }

    public int getReturnInteger(int n) {
        return this.data[n];
    }

    public int[] getReturnInts() {
        return this.data;
    }

    public int getReturnShort() {
        return this.getReturnShort(0);
    }

    public int getReturnShort(int n) {
        return this.data[n];
    }

    public String getReturnString() {
        return new String(this.getReturnChars());
    }
}

